/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import java.io.PrintStream;
import java.util.Arrays;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.bindings.CompressedUnsignedLongArrayByteIterable;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.tree.Dumpable;
import jetbrains.exodus.tree.btree.BTreeBalancePolicy;
import jetbrains.exodus.tree.btree.BTreeMutable;
import jetbrains.exodus.tree.btree.BTreeTraverser;
import jetbrains.exodus.tree.btree.BaseLeafNodeMutable;
import jetbrains.exodus.tree.btree.BasePage;
import jetbrains.exodus.tree.btree.BasePageMutable;
import jetbrains.exodus.tree.btree.ILeafNode;
import jetbrains.exodus.tree.btree.InternalPage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternalPageMutable
extends BasePageMutable {
    protected BasePageMutable[] children;
    private long[] childrenAddresses;

    InternalPageMutable(BTreeMutable tree, InternalPage page) {
        super(tree, page);
    }

    private InternalPageMutable(InternalPageMutable page, int from, int length) {
        super((BTreeMutable)page.getTree());
        BTreeBalancePolicy bp = this.getBalancePolicy();
        this.createChildren(Math.max((length & 0x7FFFFFFE) + 2, ((BTreeMutable)this.tree).isDup() ? bp.getDupPageMaxSize() : bp.getPageMaxSize()));
        System.arraycopy(page.keys, from, this.keys, 0, length);
        System.arraycopy(page.keysAddresses, from, this.keysAddresses, 0, length);
        System.arraycopy(page.children, from, this.children, 0, length);
        System.arraycopy(page.childrenAddresses, from, this.childrenAddresses, 0, length);
        this.size = length;
    }

    InternalPageMutable(BTreeMutable tree, BasePageMutable page1, BasePageMutable page2) {
        super(tree);
        BTreeBalancePolicy bp = this.getBalancePolicy();
        this.createChildren(tree.isDup() ? bp.getDupPageMaxSize() : bp.getPageMaxSize());
        this.set(0, page1.getMinKey(), page1);
        this.set(1, page2.getMinKey(), page2);
        this.size = 2;
    }

    @Override
    protected void load(@NotNull ByteIterator it, int keyAddressLen) {
        super.load(it, keyAddressLen);
        CompressedUnsignedLongArrayByteIterable.loadLongs(this.childrenAddresses, it, this.size);
    }

    @Override
    protected boolean isBottom() {
        return false;
    }

    @Override
    protected void createChildren(int max) {
        super.createChildren(max);
        this.children = new BasePageMutable[max];
        this.childrenAddresses = new long[max];
    }

    @Override
    public long getChildAddress(int index2) {
        return this.childrenAddresses[index2];
    }

    @Override
    @NotNull
    public BasePage getChild(int index2) {
        if (this.children[index2] == null) {
            return this.getTree().loadPage(this.childrenAddresses[index2]);
        }
        return this.children[index2];
    }

    @Override
    public boolean childExists(@NotNull ByteIterable key, long pageAddress) {
        int index2 = InternalPage.binarySearchGuessUnsafe(this, key);
        return index2 >= 0 && (this.childrenAddresses[index2] == pageAddress || this.getChild(index2).childExists(key, pageAddress));
    }

    @Override
    protected byte getType() {
        return ((BTreeMutable)this.getTree()).getInternalPageType();
    }

    @NotNull
    private BasePageMutable getMutableChild(int index2) {
        if (index2 >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index2 + " >= " + this.size);
        }
        BTreeMutable tree = (BTreeMutable)this.getTree();
        if (this.children[index2] == null) {
            long childAddress = this.childrenAddresses[index2];
            tree.addExpiredLoggable(childAddress);
            this.children[index2] = tree.loadPage(childAddress).getMutableCopy(tree);
            this.childrenAddresses[index2] = -1L;
        }
        return this.children[index2];
    }

    @Override
    protected void setMutableChild(int index2, @NotNull BasePageMutable child) {
        if (this.children[index2] != child) {
            BaseLeafNodeMutable key = child.keys[0];
            if (key != null) {
                this.keys[index2] = key;
                this.keysAddresses[index2] = key.getAddress();
            }
            this.children[index2] = child;
            ((BTreeMutable)this.getTree()).addExpiredLoggable(this.childrenAddresses[index2]);
            this.childrenAddresses[index2] = -1L;
        }
    }

    @Override
    @Nullable
    public BasePageMutable put(@NotNull ByteIterable key, @NotNull ByteIterable value, boolean overwrite, boolean[] result) {
        int pos = this.binarySearch(key);
        if (pos >= 0 && !overwrite) {
            return null;
        }
        if (pos < 0 && (pos = -pos - 2) < 0) {
            pos = 0;
        }
        BTreeMutable tree = (BTreeMutable)this.getTree();
        BasePageMutable child = this.getChild(pos).getMutableCopy(tree);
        BasePageMutable newChild = child.put(key, value, overwrite, result);
        if (result[0]) {
            tree.addExpiredLoggable(this.childrenAddresses[pos]);
            this.set(pos, child.getMinKey(), child);
            if (newChild != null) {
                return this.insertAt(pos + 1, newChild.getMinKey(), newChild);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public BasePageMutable putRight(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        int pos = this.size - 1;
        BTreeMutable tree = (BTreeMutable)this.getTree();
        BasePageMutable child = this.getChild(pos).getMutableCopy(tree);
        BasePageMutable newChild = child.putRight(key, value);
        tree.addExpiredLoggable(this.childrenAddresses[pos]);
        this.set(pos, child.getMinKey(), child);
        if (newChild != null) {
            return this.insertAt(pos + 1, newChild.getMinKey(), newChild);
        }
        return null;
    }

    @Override
    protected void set(int pos, @NotNull ILeafNode key, @Nullable BasePageMutable child) {
        super.set(pos, key, child);
        this.children[pos] = child;
        this.childrenAddresses[pos] = -1L;
    }

    @Override
    protected void copyChildren(int from, int to) {
        if (from >= this.size) {
            return;
        }
        super.copyChildren(from, to);
        System.arraycopy(this.children, from, this.children, to, this.size - from);
        System.arraycopy(this.childrenAddresses, from, this.childrenAddresses, to, this.size - from);
    }

    @Override
    protected void decrementSize(int value) {
        int initialSize = this.size;
        super.decrementSize(value);
        for (int i = this.size; i < initialSize; ++i) {
            this.children[i] = null;
            this.childrenAddresses[i] = 0L;
        }
    }

    @Override
    protected BasePageMutable split(int from, int length) {
        InternalPageMutable result = new InternalPageMutable(this, from, length);
        this.decrementSize(length);
        return result;
    }

    @Override
    public ILeafNode get(@NotNull ByteIterable key) {
        return InternalPage.get(key, this);
    }

    @Override
    public ILeafNode find(@NotNull BTreeTraverser stack, int depth, @NotNull ByteIterable key, @Nullable ByteIterable value, boolean equalOrNext) {
        return InternalPage.find(stack, depth, key, value, equalOrNext, this);
    }

    @Override
    public boolean keyExists(@NotNull ByteIterable key) {
        return InternalPage.keyExists(key, this);
    }

    @Override
    public boolean exists(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return InternalPage.exists(key, value, this);
    }

    @Override
    protected long getBottomPagesCount() {
        long result = 0L;
        for (int i = 0; i < this.getSize(); ++i) {
            result += this.getChild(i).getBottomPagesCount();
        }
        return result;
    }

    @Override
    @NotNull
    protected BasePageMutable.ReclaimFlag saveChildren() {
        BasePageMutable.ReclaimFlag result = BasePageMutable.ReclaimFlag.RECLAIM;
        for (int i = 0; i < this.size; ++i) {
            if (this.childrenAddresses[i] != -1L) continue;
            this.childrenAddresses[i] = this.children[i].save();
            this.keysAddresses[i] = this.children[i].keysAddresses[0];
            result = BasePageMutable.ReclaimFlag.PRESERVE;
        }
        return result;
    }

    @Override
    protected ByteIterable[] getByteIterables(@NotNull BasePageMutable.ReclaimFlag flag) {
        return new ByteIterable[]{CompressedUnsignedLongByteIterable.getIterable((this.size << 1) + flag.value), CompressedUnsignedLongArrayByteIterable.getIterable(this.keysAddresses, this.size), CompressedUnsignedLongArrayByteIterable.getIterable(this.childrenAddresses, this.size)};
    }

    public String toString() {
        return "Internal* [" + this.size + ']';
    }

    @Override
    public void dump(PrintStream out, int level, Dumpable.ToString renderer) {
        InternalPage.dump(out, level, renderer, this);
    }

    @Override
    protected void mergeWithRight(BasePageMutable _page) {
        InternalPageMutable page = (InternalPageMutable)_page;
        int newPageSize = this.size + page.size;
        if (newPageSize >= this.keys.length) {
            int newArraySize = (newPageSize & 0x7FFFFFFE) + 2;
            this.keys = Arrays.copyOf(this.keys, newArraySize);
            this.keysAddresses = Arrays.copyOf(this.keysAddresses, newArraySize);
            this.children = Arrays.copyOf(this.children, newArraySize);
            this.childrenAddresses = Arrays.copyOf(this.childrenAddresses, newArraySize);
        }
        System.arraycopy(page.keys, 0, this.keys, this.size, page.size);
        System.arraycopy(page.keysAddresses, 0, this.keysAddresses, this.size, page.size);
        System.arraycopy(page.children, 0, this.children, this.size, page.size);
        System.arraycopy(page.childrenAddresses, 0, this.childrenAddresses, this.size, page.size);
        this.size += page.size;
    }

    @Override
    protected void mergeWithLeft(BasePageMutable _page) {
        InternalPageMutable page = (InternalPageMutable)_page;
        page.mergeWithRight(this);
        this.keys = page.keys;
        this.keysAddresses = page.keysAddresses;
        this.children = page.children;
        this.childrenAddresses = page.childrenAddresses;
        this.size = page.size;
    }

    protected void removeChild(int pos) {
        this.copyChildren(pos + 1, pos);
        this.decrementSize(1);
    }

    @Override
    public boolean delete(@NotNull ByteIterable key, @Nullable ByteIterable value) {
        int pos = InternalPage.binarySearchGuess(this, key);
        BasePageMutable child = this.getMutableChild(pos);
        if (!child.delete(key, value)) {
            return false;
        }
        int childSize = child.getSize();
        if (childSize > 0) {
            this.set(pos, child.getMinKey(), child);
        }
        BTreeBalancePolicy balancePolicy = this.getBalancePolicy();
        if (pos > 0) {
            BasePage left = this.getChild(pos - 1);
            if (balancePolicy.needMerge(left, child)) {
                this.getMutableChild(pos - 1).mergeWithRight(child);
                this.removeChild(pos);
            }
        } else if (pos + 1 < this.getSize()) {
            BasePage right = this.getChild(pos + 1);
            if (balancePolicy.needMerge(child, right)) {
                BasePageMutable mutableRight = this.getMutableChild(pos + 1);
                mutableRight.mergeWithLeft(child);
                this.removeChild(pos);
                this.set(pos, mutableRight.getMinKey(), mutableRight);
            }
        } else if (childSize == 0) {
            this.removeChild(pos);
        }
        return true;
    }

    @Override
    protected BasePageMutable mergeWithChildren() {
        BasePageMutable result = this;
        while (!((BasePage)result).isBottom() && result.getSize() == 1) {
            result = result.getMutableChild(0);
        }
        return result;
    }
}

