/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.gc;

import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.execution.DelegatingJobProcessor;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.JobProcessorAdapter;
import jetbrains.exodus.core.execution.LatchJob;
import jetbrains.exodus.core.execution.ThreadJobProcessor;
import jetbrains.exodus.core.execution.ThreadJobProcessorPool;
import jetbrains.exodus.gc.BackgroundCleaningJob;
import jetbrains.exodus.gc.CleanEntireLogJob;
import jetbrains.exodus.gc.GarbageCollector;
import jetbrains.exodus.gc.GcJob;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0019J\u0006\u0010\u001d\u001a\u00020\u0019J\u0006\u0010\u001e\u001a\u00020\u0019J\u0006\u0010\u001f\u001a\u00020\u0011J\u0006\u0010 \u001a\u00020\u0019J\u000e\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0013J\u0006\u0010#\u001a\u00020\u0019J\u000e\u0010$\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010%\u001a\u00020\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u001e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Ljetbrains/exodus/gc/BackgroundCleaner;", "", "gc", "Ljetbrains/exodus/gc/GarbageCollector;", "(Ljetbrains/exodus/gc/GarbageCollector;)V", "backgroundCleaningJob", "Ljetbrains/exodus/gc/BackgroundCleaningJob;", "isCleaning", "", "()Z", "setCleaning", "(Z)V", "isCurrentThread", "isFinished", "<set-?>", "isSuspended", "processor", "Ljetbrains/exodus/core/execution/JobProcessorAdapter;", "threadId", "", "getThreadId$xodus_environment", "()J", "setThreadId$xodus_environment", "(J)V", "addBeforeGcAction", "", "action", "Ljava/lang/Runnable;", "checkThread", "cleanEntireLog", "finish", "getJobProcessor", "queueCleaningJob", "queueCleaningJobAt", "millis", "resume", "setJobProcessor", "suspend", "Companion", "xodus-environment"})
public final class BackgroundCleaner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GarbageCollector gc;
    @NotNull
    private final BackgroundCleaningJob backgroundCleaningJob;
    @NotNull
    private JobProcessorAdapter processor;
    private long threadId;
    private volatile boolean isSuspended;
    private volatile boolean isCleaning;

    public BackgroundCleaner(@NotNull GarbageCollector gc) {
        Intrinsics.checkNotNullParameter(gc, "gc");
        this.gc = gc;
        this.backgroundCleaningJob = new BackgroundCleaningJob(this.gc);
        this.processor = this.setJobProcessor(this.gc.getEnvironment$xodus_environment().getEnvironmentConfig().isLogCacheShared() ? (JobProcessorAdapter)new DelegatingJobProcessor<JobProcessorAdapter>(ThreadJobProcessorPool.getOrCreateJobProcessor("Exodus shared background cleaner")) : (JobProcessorAdapter)new ThreadJobProcessor(Intrinsics.stringPlus("Exodus background cleaner for ", this.gc.getEnvironment$xodus_environment().getLocation())));
    }

    public final long getThreadId$xodus_environment() {
        return this.threadId;
    }

    public final void setThreadId$xodus_environment(long l) {
        this.threadId = l;
    }

    public final boolean isSuspended() {
        return this.isSuspended;
    }

    public final boolean isCleaning() {
        return this.isCleaning;
    }

    public final void setCleaning(boolean bl) {
        this.isCleaning = bl;
    }

    @NotNull
    public final JobProcessorAdapter setJobProcessor(@NotNull JobProcessorAdapter processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        if (processor instanceof ThreadJobProcessor) {
            this.threadId = ((ThreadJobProcessor)processor).getId();
        } else if (processor instanceof DelegatingJobProcessor) {
            Object delegate = ((DelegatingJobProcessor)processor).getDelegate();
            if (delegate instanceof ThreadJobProcessor) {
                this.threadId = ((ThreadJobProcessor)delegate).getId();
            } else {
                throw new ExodusException(Intrinsics.stringPlus("Unexpected job processor: ", processor));
            }
        }
        if (processor.getExceptionHandler() == null) {
            processor.setExceptionHandler(BackgroundCleaner::setJobProcessor$lambda-0);
        }
        processor.start();
        this.processor = processor;
        return processor;
    }

    @NotNull
    public final JobProcessorAdapter getJobProcessor() {
        return this.processor;
    }

    public final void addBeforeGcAction(@NotNull Runnable action) {
        Intrinsics.checkNotNullParameter(action, "action");
        this.backgroundCleaningJob.addBeforeGcAction(action);
    }

    public final boolean isFinished() {
        return this.processor.isFinished();
    }

    public final boolean isCurrentThread() {
        return this.threadId == Thread.currentThread().getId();
    }

    public final void finish() {
        Job job = this.processor.getCurrentJob();
        GcJob gcJob = job instanceof GcJob ? (GcJob)job : null;
        if (gcJob != null) {
            gcJob.cancel();
        }
        this.backgroundCleaningJob.cancel();
        this.processor.waitForLatchJob(new LatchJob(this){
            final /* synthetic */ BackgroundCleaner this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void execute() {
                try {
                    BackgroundCleaner.access$getGc$p(this.this$0).deletePendingFiles$xodus_environment();
                }
                finally {
                    this.release();
                }
            }
        }, 100L);
        this.processor.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void suspend() {
        BackgroundCleaningJob $this$synchronized$iv = this.backgroundCleaningJob;
        boolean $i$f$synchronized = false;
        synchronized ($this$synchronized$iv) {
            boolean bl = false;
            BackgroundCleaningJob $this$suspend_u24lambda_u2d1 = $this$synchronized$iv;
            boolean bl2 = false;
            if (!this.isSuspended()) {
                this.isSuspended = true;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        BackgroundCleaningJob $this$synchronized$iv = this.backgroundCleaningJob;
        boolean $i$f$synchronized = false;
        synchronized ($this$synchronized$iv) {
            boolean bl = false;
            BackgroundCleaningJob $this$resume_u24lambda_u2d2 = $this$synchronized$iv;
            boolean bl2 = false;
            this.isSuspended = false;
            this.queueCleaningJob();
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void queueCleaningJob() {
        if (this.gc.getEnvironment$xodus_environment().getEnvironmentConfig().isGcEnabled()) {
            this.backgroundCleaningJob.renew$xodus_environment(this.gc);
            this.processor.queue(this.backgroundCleaningJob);
        }
    }

    public final void queueCleaningJobAt(long millis) {
        if (this.gc.getEnvironment$xodus_environment().getEnvironmentConfig().isGcEnabled()) {
            this.backgroundCleaningJob.renew$xodus_environment(this.gc);
            this.processor.queueAt(this.backgroundCleaningJob, millis);
        }
    }

    public final void cleanEntireLog() {
        this.processor.waitForLatchJob(new CleanEntireLogJob(this.gc), 0L);
    }

    public final void checkThread() {
        if (!this.isCurrentThread()) {
            throw new ExodusException("Background cleaner thread expected as current one");
        }
    }

    private static final void setJobProcessor$lambda-0(JobProcessor $noName_0, Job $noName_1, Throwable t) {
        Companion.getLogger().error(t.getMessage(), t);
    }

    public static final /* synthetic */ GarbageCollector access$getGc$p(BackgroundCleaner $this) {
        return $this.gc;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/exodus/gc/BackgroundCleaner$Companion;", "Lmu/KLogging;", "()V", "xodus-environment"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

