/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.core.dataStructures.ConcurrentLongObjectCache;
import jetbrains.exodus.core.dataStructures.SoftConcurrentLongObjectCache;
import jetbrains.exodus.core.execution.SharedTimer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StoreGetCache {
    private static final int SINGLE_CHUNK_GENERATIONS = 4;
    private final SoftConcurrentLongObjectCache<ValueEntry> cache;
    private final int minTreeSize;
    private final int maxValueSize;

    StoreGetCache(int cacheSize, int minTreeSize, int maxValueSize) {
        this.cache = new SoftConcurrentLongObjectCache<ValueEntry>(cacheSize){

            @Override
            @NotNull
            protected ConcurrentLongObjectCache<ValueEntry> newChunk(int chunkSize) {
                return new ConcurrentLongObjectCache<ValueEntry>(chunkSize, 4){

                    @Override
                    @Nullable
                    protected SharedTimer.ExpirablePeriodicTask getCacheAdjuster() {
                        return null;
                    }
                };
            }
        };
        this.minTreeSize = minTreeSize;
        this.maxValueSize = maxValueSize;
    }

    int getMinTreeSize() {
        return this.minTreeSize;
    }

    int getMaxValueSize() {
        return this.maxValueSize;
    }

    void close() {
        this.cache.close();
    }

    @Nullable
    ByteIterable tryKey(long treeRootAddress, @NotNull ByteIterable key) {
        int keyHashCode = key.hashCode();
        ValueEntry ve = (ValueEntry)this.cache.tryKey(treeRootAddress ^ (long)keyHashCode);
        return ve == null || ve.treeRootAddress != treeRootAddress || ve.keyHashCode != keyHashCode || !ve.key.equals(key) ? null : ve.value;
    }

    void cacheObject(long treeRootAddress, @NotNull ByteIterable key, @NotNull ArrayByteIterable value) {
        ArrayByteIterable keyCopy = key instanceof ArrayByteIterable ? (ArrayByteIterable)key : new ArrayByteIterable(key);
        int keyHashCode = keyCopy.hashCode();
        this.cache.cacheObject(treeRootAddress ^ (long)keyHashCode, new ValueEntry(treeRootAddress, keyHashCode, keyCopy, value));
    }

    float hitRate() {
        return this.cache.hitRate();
    }

    private static class ValueEntry {
        private final long treeRootAddress;
        private final int keyHashCode;
        @NotNull
        private final ArrayByteIterable key;
        @NotNull
        private final ArrayByteIterable value;

        ValueEntry(long treeRootAddress, int keyHashCode, @NotNull ArrayByteIterable key, @NotNull ArrayByteIterable value) {
            this.treeRootAddress = treeRootAddress;
            this.keyHashCode = keyHashCode;
            this.key = key;
            this.value = value;
        }
    }
}

