/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class MergeSortedIterable
extends EntityIterableBase {
    @NotNull
    private final List<EntityIterable> sorted;
    @NotNull
    private final Comparator<Entity> comparator;

    public MergeSortedIterable(@Nullable PersistentStoreTransaction txn, @NotNull List<EntityIterable> sorted2, @NotNull Comparator<Entity> comparator) {
        super(txn);
        this.sorted = sorted2;
        this.comparator = comparator;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.MERGE_SORTED;
    }

    @Override
    public boolean isSortedById() {
        return false;
    }

    @Override
    public boolean canBeCached() {
        return false;
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        long result = 0L;
        for (EntityIterable it : this.sorted) {
            result += ((EntityIterableBase)it).getSource().countImpl(txn);
        }
        return result;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new MergeSortedIterator();
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntityIterableHandleBase(this.getStore(), MergeSortedIterable.getType()){

            @Override
            public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                return false;
            }

            @Override
            public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                return false;
            }

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                builder.append(MergeSortedIterable.this.sorted.size());
                for (EntityIterable it : MergeSortedIterable.this.sorted) {
                    builder.append('-');
                    ((EntityIterableHandleBase)((EntityIterableBase)it).getSource().getHandle()).toString(builder);
                }
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                hash.apply(MergeSortedIterable.this.sorted.size());
                for (EntityIterable it : MergeSortedIterable.this.sorted) {
                    hash.applyDelimiter();
                    hash.apply(((EntityIterableBase)it).getSource().getHandle());
                }
            }
        };
    }

    static {
        MergeSortedIterable.registerType(MergeSortedIterable.getType(), (txn, store, parameters) -> {
            int size = Integer.parseInt((String)parameters[0]);
            ArrayList<EntityIterable> sorted2 = new ArrayList<EntityIterable>(size);
            for (int i = 0; i < size; ++i) {
                sorted2.add((EntityIterable)parameters[i + 1]);
            }
            return new MergeSortedIterable(txn, sorted2, (o1, o2) -> o1.getId().compareTo(o2.getId()));
        });
    }

    private final class MergeSortedIterator
    extends NonDisposableEntityIterator {
        private final PriorityQueue<EntityWithSource> queue;

        private MergeSortedIterator() {
            super(MergeSortedIterable.this);
            this.queue = new PriorityQueue(MergeSortedIterable.this.sorted.size(), (o1, o2) -> {
                Entity e1 = MergeSortedIterable.this.getEntity(((EntityWithSource)o1).id);
                Entity e2 = MergeSortedIterable.this.getEntity(((EntityWithSource)o2).id);
                return MergeSortedIterable.this.comparator.compare(e1, e2);
            });
            for (EntityIterable it : MergeSortedIterable.this.sorted) {
                EntityId id;
                EntityIterator i = it.iterator();
                if (!i.hasNext() || (id = i.nextId()) == null) continue;
                this.queue.add(new EntityWithSource(id, i));
            }
        }

        @Override
        protected boolean hasNextImpl() {
            return !this.queue.isEmpty();
        }

        @Override
        public EntityId nextIdImpl() {
            EntityWithSource pair = this.queue.poll();
            EntityId result = pair.id;
            EntityIterator i = pair.source;
            if (i.hasNext()) {
                this.queue.offer(new EntityWithSource(i.nextId(), i));
            }
            return result;
        }

        private final class EntityWithSource {
            private final EntityId id;
            private final EntityIterator source;

            private EntityWithSource(EntityId id, EntityIterator source) {
                this.id = id;
                this.source = source;
            }
        }
    }
}

