/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntitiesWithCertainLinkIterable;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleDecorator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.LinksIteratorWithTarget;
import jetbrains.exodus.entitystore.util.EntityIdSetFactory;
import jetbrains.exodus.env.Cursor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Ljetbrains/exodus/entitystore/iterate/FilterEntitiesWithCertainLinkIterable;", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "entitiesWithLink", "Ljetbrains/exodus/entitystore/iterate/EntitiesWithCertainLinkIterable;", "filter", "(Ljetbrains/exodus/entitystore/PersistentStoreTransaction;Ljetbrains/exodus/entitystore/iterate/EntitiesWithCertainLinkIterable;Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;)V", "linkId", "", "getLinkId", "()I", "canBeReordered", "", "depth", "getEntityTypeId", "getHandleImpl", "Ljetbrains/exodus/entitystore/EntityIterableHandle;", "getIteratorImpl", "Ljetbrains/exodus/entitystore/EntityIterator;", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "reverse", "getReverseIteratorImpl", "isSortedById", "union", "Ljetbrains/exodus/entitystore/EntityIterable;", "right", "xodus-entity-store"})
public final class FilterEntitiesWithCertainLinkIterable
extends EntityIterableBase {
    @NotNull
    private final EntitiesWithCertainLinkIterable entitiesWithLink;
    @NotNull
    private final EntityIterableBase filter;

    public FilterEntitiesWithCertainLinkIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntitiesWithCertainLinkIterable entitiesWithLink, @NotNull EntityIterableBase filter) {
        Intrinsics.checkNotNullParameter(txn, "txn");
        Intrinsics.checkNotNullParameter(entitiesWithLink, "entitiesWithLink");
        Intrinsics.checkNotNullParameter(filter, "filter");
        super(txn);
        this.entitiesWithLink = entitiesWithLink;
        EntityIterableBase entityIterableBase = filter.getSource();
        Intrinsics.checkNotNullExpressionValue(entityIterableBase, "filter.source");
        this.filter = entityIterableBase;
    }

    public final int getLinkId() {
        return this.entitiesWithLink.getLinkId$xodus_entity_store();
    }

    @Override
    @NotNull
    public EntityIterable union(@NotNull EntityIterable right) {
        Intrinsics.checkNotNullParameter(right, "right");
        if (right instanceof FilterEntitiesWithCertainLinkIterable && (this.entitiesWithLink == ((FilterEntitiesWithCertainLinkIterable)right).entitiesWithLink || this.getLinkId() == ((FilterEntitiesWithCertainLinkIterable)right).getLinkId() && this.getEntityTypeId() == ((FilterEntitiesWithCertainLinkIterable)right).getEntityTypeId())) {
            PersistentStoreTransaction persistentStoreTransaction = this.getTransaction();
            Intrinsics.checkNotNullExpressionValue(persistentStoreTransaction, "transaction");
            return new FilterEntitiesWithCertainLinkIterable(persistentStoreTransaction, this.entitiesWithLink, (EntityIterableBase)this.filter.union(((FilterEntitiesWithCertainLinkIterable)right).filter));
        }
        EntityIterable entityIterable = super.union(right);
        Intrinsics.checkNotNullExpressionValue(entityIterable, "super.union(right)");
        return entityIterable;
    }

    @Override
    public int getEntityTypeId() {
        return this.entitiesWithLink.getEntityTypeId();
    }

    @Override
    public boolean isSortedById() {
        return this.entitiesWithLink.isSortedById();
    }

    @Override
    public boolean canBeReordered() {
        return true;
    }

    @Override
    public int depth() {
        return 1000;
    }

    @Override
    @NotNull
    public EntityIterator getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter(txn, "txn");
        return this.getIteratorImpl(txn, false);
    }

    @Override
    @NotNull
    public EntityIterator getReverseIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter(txn, "txn");
        return this.getIteratorImpl(txn, true);
    }

    private final EntityIteratorBase getIteratorImpl(PersistentStoreTransaction txn, boolean reverse) {
        EntityIteratorBase entityIteratorBase;
        EntityIdSet entityIdSet = this.filter.toSet(txn);
        Intrinsics.checkNotNullExpressionValue(entityIdSet, "filter.toSet(txn)");
        EntityIdSet idSet2 = entityIdSet;
        LinksIteratorWithTarget it = reverse ? this.entitiesWithLink.getReverseIteratorImpl(txn) : this.entitiesWithLink.getIteratorImpl(txn);
        EntityIteratorBase $this$getIteratorImpl_u24lambda_u2d1 = entityIteratorBase = new EntityIteratorBase(this, it, idSet2){
            @NotNull
            private EntityIdSet distinctIds;
            @Nullable
            private EntityId id;
            final /* synthetic */ FilterEntitiesWithCertainLinkIterable this$0;
            final /* synthetic */ LinksIteratorWithTarget $it;
            final /* synthetic */ EntityIdSet $idSet;
            {
                this.this$0 = $receiver;
                this.$it = $it;
                this.$idSet = $idSet;
                super($receiver);
                this.distinctIds = EntityIdSetFactory.newSet();
                this.id = this.nextAvailableId();
            }

            protected boolean hasNextImpl() {
                return this.id != null;
            }

            @Nullable
            protected EntityId nextIdImpl() {
                EntityId result = this.id;
                EntityIdSet entityIdSet = this.distinctIds.add(result);
                Intrinsics.checkNotNullExpressionValue(entityIdSet, "distinctIds.add(result)");
                this.distinctIds = entityIdSet;
                this.id = this.nextAvailableId();
                return result;
            }

            private final EntityId nextAvailableId() {
                while (this.$it.hasNext()) {
                    EntityId next = this.$it.nextId();
                    if (!this.$idSet.contains(this.$it.getTargetId()) || this.distinctIds.contains(next)) continue;
                    return next;
                }
                return null;
            }
        };
        boolean bl = false;
        Cursor cursor = it.getCursor();
        if (cursor != null) {
            Cursor it2 = cursor;
            boolean bl2 = false;
            $this$getIteratorImpl_u24lambda_u2d1.setCursor(it2);
        }
        return entityIteratorBase;
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        PersistentEntityStoreImpl persistentEntityStoreImpl = this.getStore();
        EntityIterableType entityIterableType = EntityIterableType.FILTER_LINKS;
        EntityIterableHandle entityIterableHandle = this.entitiesWithLink.getHandle();
        return new EntityIterableHandleDecorator(this, persistentEntityStoreImpl, entityIterableType, entityIterableHandle){
            @NotNull
            private final int[] linkIds;
            final /* synthetic */ FilterEntitiesWithCertainLinkIterable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                int[] nArray = new int[]{this.this$0.getLinkId()};
                int[] nArray2 = EntityIterableHandleDecorator.mergeFieldIds(nArray, FilterEntitiesWithCertainLinkIterable.access$getFilter$p(this.this$0).getHandle().getLinkIds());
                Intrinsics.checkNotNullExpressionValue(nArray2, "mergeFieldIds(intArrayOf\u2026), filter.handle.linkIds)");
                this.linkIds = nArray2;
            }

            @NotNull
            public int[] getLinkIds() {
                return this.linkIds;
            }

            public void toString(@NotNull StringBuilder builder) {
                Intrinsics.checkNotNullParameter(builder, "builder");
                super.toString(builder);
                this.applyDecoratedToBuilder(builder);
                builder.append('-');
                ((EntityIterableHandleBase)FilterEntitiesWithCertainLinkIterable.access$getFilter$p(this.this$0).getHandle()).toString(builder);
            }

            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                Intrinsics.checkNotNullParameter(hash, "hash");
                super.hashCode(hash);
                hash.applyDelimiter();
                hash.apply(FilterEntitiesWithCertainLinkIterable.access$getFilter$p(this.this$0).getHandle());
            }

            public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                Intrinsics.checkNotNullParameter(source, "source");
                Intrinsics.checkNotNullParameter(target, "target");
                return this.decorated.isMatchedLinkAdded(source, target, linkId) || FilterEntitiesWithCertainLinkIterable.access$getFilter$p(this.this$0).getHandle().isMatchedLinkAdded(source, target, linkId);
            }

            public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int id) {
                Intrinsics.checkNotNullParameter(source, "source");
                Intrinsics.checkNotNullParameter(target, "target");
                return this.decorated.isMatchedLinkDeleted(source, target, id) || FilterEntitiesWithCertainLinkIterable.access$getFilter$p(this.this$0).getHandle().isMatchedLinkDeleted(source, target, id);
            }
        };
    }

    public static final /* synthetic */ EntityIterableBase access$getFilter$p(FilterEntitiesWithCertainLinkIterable $this) {
        return $this.filter;
    }
}

