/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.lang.ref.SoftReference;
import java.util.BitSet;
import jetbrains.exodus.core.dataStructures.SoftLongObjectCache;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import jetbrains.exodus.entitystore.BlobVault;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\u0018\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Ljetbrains/exodus/entitystore/BlobStringsCache;", "", "()V", "bf", "Ljava/lang/ref/SoftReference;", "Ljava/util/BitSet;", "bloomFilter", "getBloomFilter", "()Ljava/util/BitSet;", "cache", "Ljetbrains/exodus/core/dataStructures/SoftLongObjectCache;", "Lkotlin/Pair;", "", "", "hitRate", "", "getHitRate", "()F", "cacheObject", "", "blobVault", "Ljetbrains/exodus/entitystore/BlobVault;", "blobHandle", "", "value", "getObject", "tryKey", "BlobStringsCacheCreator", "Companion", "xodus-openAPI"})
public final class BlobStringsCache {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final SoftLongObjectCache<Pair<Integer, String>> cache = new SoftLongObjectCache(BLOB_STRING_CACHE_SIZE);
    @NotNull
    private SoftReference<BitSet> bf = new SoftReference<Object>(null);
    @Deprecated
    private static final int BLOB_STRING_CACHE_SIZE;
    @Deprecated
    private static final int BLOOM_FILTER_SIZE;

    @Nullable
    public final String tryKey(@NotNull BlobVault blobVault, long blobHandle) {
        Intrinsics.checkNotNullParameter(blobVault, "blobVault");
        long cacheKey = Companion.cacheKey(blobVault, blobHandle);
        Pair pair = (Pair)this.cache.tryKey(cacheKey);
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        int id = ((Number)pair2.component1()).intValue();
        String result = (String)pair2.component2();
        return id == blobVault.getIdentity() ? result : null;
    }

    @Nullable
    public final String getObject(@NotNull BlobVault blobVault, long blobHandle) {
        Intrinsics.checkNotNullParameter(blobVault, "blobVault");
        long cacheKey = Companion.cacheKey(blobVault, blobHandle);
        Pair pair = (Pair)this.cache.getObject(cacheKey);
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        int id = ((Number)pair2.component1()).intValue();
        String result = (String)pair2.component2();
        return id == blobVault.getIdentity() ? result : null;
    }

    public final void cacheObject(@NotNull BlobVault blobVault, long blobHandle, @NotNull String value) {
        Intrinsics.checkNotNullParameter(blobVault, "blobVault");
        Intrinsics.checkNotNullParameter(value, "value");
        long cacheKey = Companion.cacheKey(blobVault, blobHandle);
        int bit = (int)(cacheKey % (long)BLOOM_FILTER_SIZE);
        BitSet filter = this.getBloomFilter();
        if (filter.get(bit)) {
            this.cache.cacheObject(cacheKey, TuplesKt.to(blobVault.getIdentity(), value));
        } else {
            filter.set(bit, true);
        }
    }

    public final float getHitRate() {
        return this.cache.hitRate();
    }

    private final BitSet getBloomFilter() {
        BitSet result = this.bf.get();
        if (result == null) {
            result = new BitSet(BLOOM_FILTER_SIZE);
            this.bf = new SoftReference<BitSet>(result);
        }
        return result;
    }

    static {
        Integer n = Integer.getInteger("exodus.entityStore.blobStringsCacheSize", 4096);
        Intrinsics.checkNotNullExpressionValue(n, "getInteger(\"exodus.entit\u2026tringsCacheSize\", 0x1000)");
        BLOB_STRING_CACHE_SIZE = ((Number)n).intValue();
        BLOOM_FILTER_SIZE = HashUtil.getCeilingPrime(BLOB_STRING_CACHE_SIZE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/exodus/entitystore/BlobStringsCache$BlobStringsCacheCreator;", "", "()V", "instance", "Ljetbrains/exodus/entitystore/BlobStringsCache;", "getInstance", "()Ljetbrains/exodus/entitystore/BlobStringsCache;", "xodus-openAPI"})
    public static final class BlobStringsCacheCreator {
        @NotNull
        private final BlobStringsCache instance = new BlobStringsCache();

        @NotNull
        public final BlobStringsCache getInstance() {
            return this.instance;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000e"}, d2={"Ljetbrains/exodus/entitystore/BlobStringsCache$Companion;", "", "()V", "BLOB_STRING_CACHE_SIZE", "", "getBLOB_STRING_CACHE_SIZE", "()I", "BLOOM_FILTER_SIZE", "getBLOOM_FILTER_SIZE", "cacheKey", "", "blobVault", "Ljetbrains/exodus/entitystore/BlobVault;", "blobHandle", "xodus-openAPI"})
    private static final class Companion {
        private Companion() {
        }

        public final int getBLOB_STRING_CACHE_SIZE() {
            return BLOB_STRING_CACHE_SIZE;
        }

        public final int getBLOOM_FILTER_SIZE() {
            return BLOOM_FILTER_SIZE;
        }

        public final long cacheKey(@NotNull BlobVault blobVault, long blobHandle) {
            Intrinsics.checkNotNullParameter(blobVault, "blobVault");
            return blobHandle ^ (long)blobVault.getIdentity() << 32;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

