/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import java.util.Arrays;

public class LongArrayList
implements Cloneable {
    private long[] data;
    private int size;

    public LongArrayList(int initialCapacity) {
        this.data = new long[initialCapacity];
    }

    public LongArrayList() {
        this(4);
    }

    public void trimToSize() {
        int oldCapacity = this.data.length;
        if (this.size < oldCapacity) {
            this.data = Arrays.copyOf(this.data, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            int newCapacity;
            if (oldCapacity == 0) {
                oldCapacity = 1;
            }
            if ((newCapacity = (oldCapacity << 3) / 5 + 1) < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = Arrays.copyOf(this.data, newCapacity);
        }
    }

    public int getCapacity() {
        return this.data.length;
    }

    public void setCapacity(int capacity) {
        this.data = new long[capacity];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(long element) {
        return this.indexOf(element) >= 0;
    }

    public int indexOf(long element) {
        return LongArrayList.indexOf(this.data, this.size, element);
    }

    public static int indexOf(long[] array, long element) {
        return LongArrayList.indexOf(array, array.length, element);
    }

    public static int indexOf(long[] array, int size, long element) {
        for (int i = 0; i < size; ++i) {
            if (element != array[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long element) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (element != this.data[i]) continue;
            return i;
        }
        return -1;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.size);
    }

    public final Object clone() throws CloneNotSupportedException {
        LongArrayList v = (LongArrayList)super.clone();
        v.data = new long[this.size];
        System.arraycopy(this.data, 0, v.data, 0, this.size);
        return v;
    }

    public long[] toArray() {
        long[] result = new long[this.size];
        System.arraycopy(this.data, 0, result, 0, this.size);
        return result;
    }

    public long[] toArray(long[] a) {
        if (a.length < this.size) {
            a = new long[this.size];
        }
        System.arraycopy(this.data, 0, a, 0, this.size);
        return a;
    }

    public long[] getInstantArray() {
        return this.data;
    }

    public long get(int index2) {
        this.checkRange(index2);
        return this.data[index2];
    }

    public long set(int index2, long element) {
        this.checkRange(index2);
        long oldValue = this.data[index2];
        this.data[index2] = element;
        return oldValue;
    }

    public void add(long element) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = element;
    }

    public void add(int index2, long element) {
        if (index2 > this.size || index2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, index2, this.data, index2 + 1, this.size - index2);
        this.data[index2] = element;
        ++this.size;
    }

    public long remove(int index2) {
        this.checkRange(index2);
        long oldValue = this.data[index2];
        int numMoved = this.size - index2 - 1;
        if (numMoved > 0) {
            System.arraycopy(this.data, index2 + 1, this.data, index2, numMoved);
        }
        --this.size;
        return oldValue;
    }

    public void clear() {
        this.size = 0;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        int numMoved = this.size - toIndex;
        System.arraycopy(this.data, toIndex, this.data, fromIndex, numMoved);
        this.size -= toIndex - fromIndex;
    }

    private void checkRange(int index2) {
        if (index2 >= this.size || index2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + this.size);
        }
    }
}

