/*_############################################################################
  _## 
  _##  SNMP4J-AgentX - SubAgentXIndexRegistryEntry.java  
  _## 
  _##  Copyright (C) 2005-2026  Frank Fock (SNMP4J.org)
  _##  
  _##  This program is free software; you can redistribute it and/or modify
  _##  it under the terms of the GNU General Public License version 2 as 
  _##  published by the Free Software Foundation.
  _##
  _##  This program is distributed in the hope that it will be useful,
  _##  but WITHOUT ANY WARRANTY; without even the implied warranty of
  _##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  _##  GNU General Public License for more details.
  _##
  _##  You should have received a copy of the GNU General Public License
  _##  along with this program; if not, write to the Free Software
  _##  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  _##  MA  02110-1301  USA
  _##  
  _##########################################################################*/


package org.snmp4j.agent.agentx.subagent.index;

import org.snmp4j.agent.agentx.master.index.IndexEntry;
import org.snmp4j.agent.agentx.master.index.IndexRegistryEntry;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class SubAgentXIndexRegistryEntry extends IndexRegistryEntry {

  public SubAgentXIndexRegistryEntry(OctetString context, VariableBinding indexType) {
    super(context, indexType);
  }

  @Override
  protected IndexEntry newIndexEntry(int sessionID, Variable indexValue) {
    return new SubAgentXIndexEntry(sessionID, indexValue);
  }

  @Override
  protected void duplicateAllocation(IndexEntry entry) {
    ((SubAgentXIndexEntry)entry).incReferenceCount();
  }

  @Override
  protected void addUsed(IndexEntry entry) {
    // do not add any used
  }

  @Override
  protected boolean removeEntry(IndexEntry entryKey) {
    SubAgentXIndexEntry entry = (SubAgentXIndexEntry)entryKey; 
    if (entry.getReferenceCount() > 0) {
      entry.decReferenceCount();
      return false;
    }
    super.removeEntry(entryKey);
    return true;
  }
}
