/*_############################################################################
  _## 
  _##  SNMP4J-AgentX - SubAgentXIndexEntry.java  
  _## 
  _##  Copyright (C) 2005-2026  Frank Fock (SNMP4J.org)
  _##  
  _##  This program is free software; you can redistribute it and/or modify
  _##  it under the terms of the GNU General Public License version 2 as 
  _##  published by the Free Software Foundation.
  _##
  _##  This program is distributed in the hope that it will be useful,
  _##  but WITHOUT ANY WARRANTY; without even the implied warranty of
  _##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  _##  GNU General Public License for more details.
  _##
  _##  You should have received a copy of the GNU General Public License
  _##  along with this program; if not, write to the Free Software
  _##  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  _##  MA  02110-1301  USA
  _##  
  _##########################################################################*/

package org.snmp4j.agent.agentx.subagent.index;

import org.snmp4j.agent.agentx.master.index.IndexEntry;
import org.snmp4j.smi.Variable;

/**
 * {@link SubAgentXIndexEntry} extends {@link IndexEntry} by a reference counter to allow save removal
 * of index entries if the counter is 0.
 */
public class SubAgentXIndexEntry extends IndexEntry {

    private int referenceCount = 0;

    /**
     * Creates a {@link SubAgentXIndexEntry} instance.
     * @param sessionID
     *    session ID.
     * @param indexValue
     *    the value of the index.
     */
    public SubAgentXIndexEntry(int sessionID, Variable indexValue) {
        super(sessionID, indexValue);
    }

    /**
     * Gets the reference count.
     * @return
     *    the reference count (0 means no references left).
     */
    public int getReferenceCount() {
        return referenceCount;
    }

    /**
     * Increments the reference count by one.
     */
    public synchronized void incReferenceCount() {
        referenceCount++;
    }

    /**
     * Decrements the reference count by one (if it is greater than zero).
     */
    public synchronized void decReferenceCount() {
        if (referenceCount > 0) referenceCount--;
    }
}

