/*_############################################################################
  _## 
  _##  SNMP4J-AgentX - AgentXPending.java  
  _## 
  _##  Copyright (C) 2005-2026  Frank Fock (SNMP4J.org)
  _##  
  _##  This program is free software; you can redistribute it and/or modify
  _##  it under the terms of the GNU General Public License version 2 as 
  _##  published by the Free Software Foundation.
  _##
  _##  This program is distributed in the hope that it will be useful,
  _##  but WITHOUT ANY WARRANTY; without even the implied warranty of
  _##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  _##  GNU General Public License for more details.
  _##
  _##  You should have received a copy of the GNU General Public License
  _##  along with this program; if not, write to the Free Software
  _##  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  _##  MA  02110-1301  USA
  _##  
  _##########################################################################*/

package org.snmp4j.agent.agentx.master;

import org.snmp4j.agent.agentx.AgentXPDU;
import org.snmp4j.agent.agentx.subagent.AgentXRequest;
import org.snmp4j.agent.request.SnmpSubRequest;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.request.SubRequestIterator;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.smi.Address;

import java.io.Serializable;

/**
 * The {@code AgentXPending} interface is implemented
 * by classes holding sub-agent AgentX request state information in a SNMP4J-AgentX master agent.
 *
 * @author Frank Fock
 * @version 4.1.0
 */
public interface AgentXPending<A extends Address> extends Serializable {

    /**
     * Gets the AgentX PDU.
     * @return
     *    the {@link AgentXPDU}.
     */
    AgentXPDU getAgentXPDU();

    /**
     * Get the affected {@link AgentXRegEntry}.
     * @return
     *   the affected registration.
     */
    AgentXRegEntry<A> getRegistration();

    /**
     * Gets the master agent session.
     * @return
     *   the {@link AgentXMasterSession}.
     */
    AgentXMasterSession<A> getSession();

    /**
     * Checks if the request is still pending.
     * @return
     *    {@code true} if the request is still pending.
     */
    boolean isPending();

    /**
     * Sets the pending flag.
     * @param pending
     *    {@code false} if the response for the request has been received or the request timed out.
     */
    void setPending(boolean pending);

    /**
     * Gets the SNMP request that triggered the AgentX request.
     * @return
     *    a {@link SnmpRequest}.
     */
    SnmpRequest getRequest();

    /**
     * Get the references to the SNMP sub-requests that triggered the AgentX request.
     * @return
     *    an iterator on the SNMP requests associated with this AgentX pending request.
     */
    SubRequestIterator<SnmpRequest.SnmpSubRequest> getReferences();

    /**
     * Set the timestamp to the current time (in milliseconds).
     */
    void updateTimestamp();

    /**
     * Gets the timestamp (in milliseconds) when {@link #updateTimestamp()}
     * had been called last.
     *
     * @return {@link System#currentTimeMillis()} when {@link #updateTimestamp()}
     * had been called or zero if it had not been called yet.
     */
    long getTimestamp();

    /**
     * Sets the timeout of the request.
     * @param timeoutSeconds
     *    a timeout value in seconds.
     */
    void setTimeout(int timeoutSeconds);

    /**
     * Gets the timeout seconds set for this pending AgentX request.
     *
     * @return the timeout value in seconds.
     */
    int getTimeout();
}
