/*_############################################################################
  _## 
  _##  SNMP4J-AgentX - AgentXTDomainAddressFactory.java  
  _## 
  _##  Copyright (C) 2005-2026  Frank Fock (SNMP4J.org)
  _##  
  _##  This program is free software; you can redistribute it and/or modify
  _##  it under the terms of the GNU General Public License version 2 as 
  _##  published by the Free Software Foundation.
  _##
  _##  This program is distributed in the hope that it will be useful,
  _##  but WITHOUT ANY WARRANTY; without even the implied warranty of
  _##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  _##  GNU General Public License for more details.
  _##
  _##  You should have received a copy of the GNU General Public License
  _##  along with this program; if not, write to the Free Software
  _##  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  _##  MA  02110-1301  USA
  _##  
  _##########################################################################*/

package org.snmp4j.agent.agentx;

import org.snmp4j.agent.mo.snmp.TDomainAddressFactoryImpl;
import org.snmp4j.agent.mo.snmp.TransportDomains;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.unix.UnixDomainAddress;

import java.nio.file.Path;

public class AgentXTDomainAddressFactory extends TDomainAddressFactoryImpl {

    private static final LogAdapter logger =
            LogFactory.getLogger(AgentXTDomainAddressFactory.class);

    public AgentXTDomainAddressFactory() {
    }

    @Override
    public Address createAddress(OID transportDomain, OctetString address) {
        if (TransportDomains.transportDomainLocal.equals(transportDomain)) {
            return new UnixDomainAddress(Path.of(address.toString()));
        }
        return super.createAddress(transportDomain, address);
    }

    @Override
    public boolean isValidAddress(OID transportDomain, OctetString address) {
        if (TransportDomains.transportDomainLocal.equals(transportDomain)) {
            new UnixDomainAddress(Path.of(address.toString())).isValid();
        }
        return super.isValidAddress(transportDomain, address);
    }

    @Override
    public OID[] getTransportDomain(Address address) {
        if (address instanceof UnixDomainAddress) {
            return new OID[] { TransportDomains.transportDomainLocal };
        }
        return super.getTransportDomain(address);
    }

    @Override
    public OctetString getAddress(Address address) {
        if (address instanceof UnixDomainAddress) {
            return new OctetString(address.toByteArray());
        }
        return super.getAddress(address);
    }
}
