/*_############################################################################
  _## 
  _##  SNMP4J-AgentX - AgentXRemoveAgentCapsPDU.java  
  _## 
  _##  Copyright (C) 2005-2026  Frank Fock (SNMP4J.org)
  _##  
  _##  This program is free software; you can redistribute it and/or modify
  _##  it under the terms of the GNU General Public License version 2 as 
  _##  published by the Free Software Foundation.
  _##
  _##  This program is distributed in the hope that it will be useful,
  _##  but WITHOUT ANY WARRANTY; without even the implied warranty of
  _##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  _##  GNU General Public License for more details.
  _##
  _##  You should have received a copy of the GNU General Public License
  _##  along with this program; if not, write to the Free Software
  _##  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  _##  MA  02110-1301  USA
  _##  
  _##########################################################################*/

package org.snmp4j.agent.agentx;

import java.io.*;
import java.nio.*;

import org.snmp4j.smi.*;

/**
 * The {@link AgentXRemoveAgentCapsPDU} represents a MIB region which can be an entire MIB or a single object-instance.
 */
public class AgentXRemoveAgentCapsPDU extends AgentXContextPDU {

    private static final long serialVersionUID = -4417974339806785162L;

    private OID id;

    /**
     * Creates a new {@link AgentXRemoveAgentCapsPDU} from context and agent caps {@link OID}.
     * @param context
     *   the SNMPv3 context.
     * @param id
     *   the agent caps {@link OID}.
     */
    public AgentXRemoveAgentCapsPDU(OctetString context, OID id) {
        super(AGENTX_REMOVEAGENTCAPS_PDU, context);
        this.id = id;
    }

    /**
     * Creates a {@link AgentXRemoveAgentCapsPDU} from a {@link AgentXMessageHeader}.
     * @param header
     *    the message header.
     */
    public AgentXRemoveAgentCapsPDU(AgentXMessageHeader header) {
        super(header);
        if (header.getType() != AGENTX_REMOVEAGENTCAPS_PDU) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected void decodeAfterContext(ByteBuffer buf, int length) throws
            IOException {
        id = new OID();
        AgentXProtocol.decodeOID(buf, id);
    }

    @Override
    protected void encodeAfterContext(ByteBuffer buf) {
        AgentXProtocol.encodeOID(buf, id, false);
    }

    @Override
    protected int getAfterContextLength() {
        return AgentXProtocol.getOIDLength(id);
    }

    /**
     * Gets the agent caps {@link OID}.
     * @return
     *    the agent caps {@link OID}.
     */
    public OID getId() {
        return id;
    }

    /**
     * Sets the agent caps {@link OID} associated with this region entry.
     * @param id
     *    an agent caps {@link OID}.
     */
    public void setId(OID id) {
        this.id = id;
    }
}
