/*_############################################################################
  _## 
  _##  SNMP4J-AgentX - AgentXParseException.java  
  _## 
  _##  Copyright (C) 2005-2026  Frank Fock (SNMP4J.org)
  _##  
  _##  This program is free software; you can redistribute it and/or modify
  _##  it under the terms of the GNU General Public License version 2 as 
  _##  published by the Free Software Foundation.
  _##
  _##  This program is distributed in the hope that it will be useful,
  _##  but WITHOUT ANY WARRANTY; without even the implied warranty of
  _##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  _##  GNU General Public License for more details.
  _##
  _##  You should have received a copy of the GNU General Public License
  _##  along with this program; if not, write to the Free Software
  _##  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  _##  MA  02110-1301  USA
  _##  
  _##########################################################################*/

package org.snmp4j.agent.agentx;

import java.io.IOException;

/**
 * The {@link AgentXParseException} represents the AgentX BER encoding parse exception.
 */
public class AgentXParseException extends IOException {

    private static final long serialVersionUID = -5201526181692556627L;

    private final AgentXMessageHeader agentXHeader;

    /**
     * Creates a {@link AgentXMessageHeader}
     * @param header
     *    the message header (as complet as possible).
     * @param exception
     *    the {@link IOException} if available.
     */
    public AgentXParseException(AgentXMessageHeader header, IOException exception) {
        super(exception.getMessage());
        this.agentXHeader = header;
        super.initCause(exception);
    }

    /**
     * Gets the AgentX header.
     * @return
     *    a possibly incomplete {@link AgentXMessageHeader} or {@code null} if the header could not be parsed.
     */
    public AgentXMessageHeader getAgentXHeader() {
        return agentXHeader;
    }
}
