/*_############################################################################
  _## 
  _##  SNMP4J-AgentX - AgentXMessageHeader.java  
  _## 
  _##  Copyright (C) 2005-2026  Frank Fock (SNMP4J.org)
  _##  
  _##  This program is free software; you can redistribute it and/or modify
  _##  it under the terms of the GNU General Public License version 2 as 
  _##  published by the Free Software Foundation.
  _##
  _##  This program is distributed in the hope that it will be useful,
  _##  but WITHOUT ANY WARRANTY; without even the implied warranty of
  _##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  _##  GNU General Public License for more details.
  _##
  _##  You should have received a copy of the GNU General Public License
  _##  along with this program; if not, write to the Free Software
  _##  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  _##  MA  02110-1301  USA
  _##  
  _##########################################################################*/

package org.snmp4j.agent.agentx;

import org.snmp4j.transport.MessageLength;

/**
 * The {@code AgentXMessageHeader} represents the AgentX header values.
 *
 * @author Frank Fock
 * @version 1.0
 */
public class AgentXMessageHeader extends MessageLength {

    private static final long serialVersionUID = -4401111336131096427L;

    private final byte type;
    private final byte flags;
    private final int sessionID;
    private final int transactionID;
    private final int packetID;

    /**
     * Creates an {@link AgentXMessageHeader}.
     * @param type
     *   the AgentX PDU type, see {@link AgentXPDU#AGENTX_OPEN_PDU} for example.
     * @param flags
     *   the AgentX FLAG set (bitwise OR), see {@link AgentXProtocol#FLAG_INSTANCE_REGISTRATION} for example.
     * @param sessionID
     *    a session ID.
     * @param transactionID
     *    a transaction ID.
     * @param packetID
     *    a packet ID.
     * @param payloadLength
     *    the payload length (BER encoded).
     */
    public AgentXMessageHeader(byte type, byte flags,
                               int sessionID,
                               int transactionID,
                               int packetID,
                               int payloadLength) {
        super(AgentXProtocol.HEADER_LENGTH, payloadLength);
        this.type = type;
        this.flags = flags;
        this.sessionID = sessionID;
        this.transactionID = transactionID;
        this.packetID = packetID;
    }

    /**
     * Gets the PDU type.
     * @return
     *    the AgentX PDU type.
     */
    public byte getType() {
        return type;
    }

    /**
     * Gets the flags set.
     * @return
     *    the flags set.
     */
    public byte getFlags() {
        return flags;
    }

    /**
     * Gets the transaction ID.
     * @return
     *    the transaction ID.
     */
    public int getTransactionID() {
        return transactionID;
    }

    /**
     * Gets the packet ID.
     * @return
     *    the packet ID.
     */
    public int getPacketID() {
        return packetID;
    }

    /**
     * Gets the session ID.
     * @return
     *    the session ID.
     */
    public int getSessionID() {
        return sessionID;
    }
}
