/*_############################################################################
  _## 
  _##  SNMP4J-AgentX - AgentXCommitSetPDU.java  
  _## 
  _##  Copyright (C) 2005-2026  Frank Fock (SNMP4J.org)
  _##  
  _##  This program is free software; you can redistribute it and/or modify
  _##  it under the terms of the GNU General Public License version 2 as 
  _##  published by the Free Software Foundation.
  _##
  _##  This program is distributed in the hope that it will be useful,
  _##  but WITHOUT ANY WARRANTY; without even the implied warranty of
  _##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  _##  GNU General Public License for more details.
  _##
  _##  You should have received a copy of the GNU General Public License
  _##  along with this program; if not, write to the Free Software
  _##  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  _##  MA  02110-1301  USA
  _##  
  _##########################################################################*/

package org.snmp4j.agent.agentx;

import java.io.Serial;
import java.nio.ByteBuffer;
import java.io.IOException;

/**
 * The {@link AgentXCommitSetPDU} represents the agentx-CleanupSet-PDU defined by RFC 2741.
 */
public class AgentXCommitSetPDU extends AgentXPDU {

    @Serial
    private static final long serialVersionUID = 7565202303478262014L;

    /**
     * Creates a {@link AgentXCommitSetPDU}.
     */
    public AgentXCommitSetPDU() {
        super(AGENTX_COMMITSET_PDU);
    }

    /**
     * Creates a {@link AgentXCommitSetPDU} from a {@link AgentXMessageHeader}.
     * @param header
     *    the message header.
     */
    public AgentXCommitSetPDU(AgentXMessageHeader header) {
        super(header);
        if (header.getType() != AGENTX_COMMITSET_PDU) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected void encodePayload(ByteBuffer buf) {
    }

    @Override
    public int getPayloadLength() {
        return 0;
    }

    @Override
    public void decodePayload(ByteBuffer buf, int length) throws IOException {
    }

    @Override
    protected void beforeEncode() {
    }

}
