/*_############################################################################
  _## 
  _##  SNMP4J-AgentX - AgentXCommandListener.java  
  _## 
  _##  Copyright (C) 2005-2026  Frank Fock (SNMP4J.org)
  _##  
  _##  This program is free software; you can redistribute it and/or modify
  _##  it under the terms of the GNU General Public License version 2 as 
  _##  published by the Free Software Foundation.
  _##
  _##  This program is distributed in the hope that it will be useful,
  _##  but WITHOUT ANY WARRANTY; without even the implied warranty of
  _##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  _##  GNU General Public License for more details.
  _##
  _##  You should have received a copy of the GNU General Public License
  _##  along with this program; if not, write to the Free Software
  _##  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  _##  MA  02110-1301  USA
  _##  
  _##########################################################################*/

package org.snmp4j.agent.agentx;

import org.snmp4j.smi.Address;

import java.util.EventListener;
import java.util.Map;

/**
 * The {@link AgentXCommandListener} interface is implemented by AgentX master or sub-agents to process AgentX
 * messages.
 *
 * @author Frank Fock
 * @version 3.0.0
 */
public interface AgentXCommandListener extends EventListener {

    /**
     * Process an AgentX message.
     * @param event
     *    the AgentX message and necessary context information.
     * @param <A> {@link Address} type of peer that trigger this command.
     */
    <A extends Address> void processCommand(AgentXCommandEvent<A> event);

    /**
     * Close all sessions associated with this {@link AgentXCommandListener} and return the AgentX status of the
     * close operation together with the {@link AgentXSession} object.
     * @param reason
     *    the AgentX reason ({@link AgentXProtocol#REASON_SHUTDOWN}, {@link AgentXProtocol#REASON_TIMEOUTS},
     *    {@link AgentXProtocol#REASON_BY_MANAGER}, {@link AgentXProtocol#REASON_PROTOCOL_ERROR},
     *    {@link AgentXProtocol#REASON_PARSE_ERROR}, {@link AgentXProtocol#REASON_OTHER}) for closing the session.
     * @return
     *    a map of the AgentXSession session objects hold by this agent and the corresponding AgentX error code. An
     *    error code of {@link AgentXProtocol#AGENTX_SUCCESS} indicates that this session was successfully closed.
     * @since 3.0.0
     */
    Map<AgentXSession<?>,Integer> closeAllSessions(byte reason);

}
