/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.subagent;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.AgentState;
import org.snmp4j.agent.AgentStateListener;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOQueryWithSource;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.NotificationOriginator;
import org.snmp4j.agent.agentx.AgentXCommandListener;
import org.snmp4j.agent.agentx.AgentXMessageDispatcher;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.MOInputFactory;
import org.snmp4j.agent.io.MOPersistenceProvider;
import org.snmp4j.agent.io.MOServerPersistence;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOPriorityProvider;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.util.MOTableSizeLimit;
import org.snmp4j.agent.mo.util.VariableProvider;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.request.SubRequestIterator;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.WorkerPool;

public abstract class SubagentXConfigManager
implements Runnable,
VariableProvider {
    private static final LogAdapter logger = LogFactory.getLogger(SubagentXConfigManager.class);
    protected AgentXCommandListener agent;
    protected WorkerPool workerPool;
    protected MOServer[] servers;
    protected AgentXMessageDispatcher dispatcher;
    protected NotificationOriginator notificationOriginator;
    protected MOInputFactory configuration;
    protected MOPersistenceProvider persistenceProvider;
    protected int persistenceImportMode = 2;
    protected MOPriorityProvider priorityProvider;
    protected MOFactory moFactory = DefaultMOFactory.getInstance();
    protected OctetString defaultContext;
    protected AgentState runState = new AgentState();
    protected MOTableSizeLimit<MOTableRow> tableSizeLimit;
    protected List<AgentStateListener<SubagentXConfigManager>> agentStateListeners = new ArrayList<AgentStateListener<SubagentXConfigManager>>(2);

    public SubagentXConfigManager(AgentXCommandListener agentXCommandListener, AgentXMessageDispatcher messageDispatcher, MOServer[] moServers, WorkerPool workerPool, MOInputFactory configurationFactory, MOPersistenceProvider persistenceProvider, MOFactory moFactory) {
        this.agent = agentXCommandListener;
        this.dispatcher = messageDispatcher;
        this.servers = moServers;
        this.workerPool = workerPool;
        this.configuration = configurationFactory;
        this.persistenceProvider = persistenceProvider;
        this.moFactory = moFactory == null ? this.moFactory : moFactory;
    }

    public WorkerPool getWorkerPool() {
        return this.workerPool;
    }

    @Override
    public void run() {
        if (this.runState.getState() < 10) {
            this.initialize();
        }
        if (this.runState.getState() < 20) {
            this.configure();
        }
        if (this.runState.getState() < 30) {
            this.restoreState();
        }
        if (this.runState.getState() < 40) {
            this.launch();
        }
    }

    public synchronized void addAgentStateListener(AgentStateListener<SubagentXConfigManager> agentStateListener) {
        this.agentStateListeners.add(agentStateListener);
    }

    public synchronized boolean removeAgentStateListener(AgentStateListener<SubagentXConfigManager> agentStateListener) {
        return this.agentStateListeners.remove(agentStateListener);
    }

    protected synchronized void fireAgentStateChange() {
        for (AgentStateListener<SubagentXConfigManager> agentStateListener : this.agentStateListeners) {
            agentStateListener.agentStateChanged((Object)this, (org.snmp4j.agent.AgentState)this.runState);
        }
    }

    public synchronized MOServer getServer(OctetString context) {
        for (MOServer s : this.servers) {
            if (!s.isContextSupported(context)) continue;
            return s;
        }
        return null;
    }

    public MOServer[] getServers() {
        return this.servers;
    }

    public org.snmp4j.agent.AgentState getState() {
        return this.runState;
    }

    protected void launch() {
        if (this.tableSizeLimit != null) {
            for (MOServer server : this.servers) {
                DefaultMOServer.unregisterTableRowListener((MOServer)server, this.tableSizeLimit);
                DefaultMOServer.registerTableRowListener((MOServer)server, this.tableSizeLimit);
            }
        }
        this.dispatcher.removeCommandListener(this.agent);
        this.dispatcher.addCommandListener(this.agent);
        try {
            this.launchTransportMappings();
        }
        catch (IOException ex) {
            String txt = "Could not put all transport mappings in listen mode: " + ex.getMessage();
            logger.error((CharSequence)txt, (Throwable)ex);
            this.runState.addError(new ErrorDescriptor(txt, this.runState.getState(), 40, ex));
            return;
        }
        try {
            this.launchAgentXSessions();
        }
        catch (IOException iox) {
            String txt = "Could not establish AgentX connection to a master agent: " + iox.getMessage();
            logger.error((CharSequence)txt, (Throwable)iox);
            this.runState.addError(new ErrorDescriptor(txt, this.runState.getState(), 40, iox));
            return;
        }
        this.runState.advanceState(40);
        this.fireLaunchNotifications();
    }

    public abstract void launchAgentXSessions() throws IOException;

    protected void fireLaunchNotifications() {
        if (this.notificationOriginator != null) {
            this.notificationOriginator.notify(new OctetString(), SnmpConstants.coldStart, new VariableBinding[0]);
        }
    }

    public boolean continueProcessing() {
        if (this.runState.getState() == 35) {
            this.dispatcher.removeCommandListener(this.agent);
            this.dispatcher.addCommandListener(this.agent);
            this.runState.setState(40);
            return true;
        }
        return false;
    }

    public void suspendProcessing() {
        this.dispatcher.removeCommandListener(this.agent);
        this.runState.setState(35);
    }

    public void shutdown() {
        logger.info((CharSequence)"Shutdown agent: suspending request processing");
        this.agent.closeAllSessions((byte)5);
        this.suspendProcessing();
        try {
            if (this.dispatcher != null) {
                logger.info((CharSequence)"Shutdown agent: closing transport mappings");
                SubagentXConfigManager.stopTransportMappings(this.dispatcher.getTransportMappings());
            }
        }
        catch (IOException ex) {
            logger.warn((Serializable)((Object)("Failed to close SNMP session: " + ex.getMessage())));
        }
        logger.info((CharSequence)"Shutdown agent: saving state");
        if (!this.saveState() && this.persistenceProvider != null) {
            logger.error((Serializable)((Object)"Agent state could not be saved!"));
        }
        if (this.tableSizeLimit != null) {
            for (MOServer server : this.servers) {
                DefaultMOServer.unregisterTableRowListener((MOServer)server, this.tableSizeLimit);
            }
        }
        logger.info((CharSequence)"Shutdown agent: unregistering MIB objects");
        this.unregisterMIBs(null);
        logger.info((CharSequence)"Shutdown agent: closing persistence provider");
        try {
            this.persistenceProvider.close();
        }
        catch (Exception e) {
            logger.warn((Serializable)((Object)("Shutdown agent: Failed to close persistence provider: " + e.getMessage())));
        }
        this.runState.setState(-1);
        logger.info((CharSequence)"Shutdown agent: finished");
    }

    public void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                SubagentXConfigManager.this.shutdown();
            }
        });
    }

    protected void launchTransportMappings() throws IOException {
        SubagentXConfigManager.launchTransportMappings(this.dispatcher.getTransportMappings());
    }

    protected static void launchTransportMappings(Collection<? extends TransportMapping<?>> transportMappings) throws IOException {
        ArrayList l = new ArrayList(transportMappings);
        for (TransportMapping<?> tm : l) {
            if (tm.isListening()) continue;
            tm.listen();
        }
    }

    protected static void stopTransportMappings(Collection<? extends TransportMapping<?>> transportMappings) throws IOException {
        ArrayList l = new ArrayList(transportMappings);
        for (TransportMapping<?> tm : l) {
            tm.close();
        }
    }

    public boolean saveState() {
        if (this.persistenceProvider != null) {
            try {
                this.persistenceProvider.store(this.persistenceProvider.getDefaultURI(), this.priorityProvider);
                this.runState.advanceState(50);
                return true;
            }
            catch (IOException ex) {
                String txt = "Failed to save agent state: " + ex.getMessage();
                logger.error((CharSequence)txt, (Throwable)ex);
                this.runState.addError(new ErrorDescriptor(txt, this.runState.getState(), 50, ex));
            }
        }
        return false;
    }

    public boolean restoreState() {
        if (this.persistenceProvider != null) {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((CharSequence)("Restoring persistent data (mode=" + this.persistenceImportMode + ") from " + this.persistenceProvider.getDefaultURI()));
                }
                this.persistenceProvider.restore(this.persistenceProvider.getDefaultURI(), this.persistenceImportMode);
                this.runState.advanceState(30);
                return true;
            }
            catch (FileNotFoundException fnf) {
                String txt = "Saved agent state not found: " + fnf.getMessage();
                logger.warn((Serializable)((Object)txt));
            }
            catch (IOException ex) {
                String txt = "Failed to load agent state: " + ex.getMessage();
                logger.error((CharSequence)txt, (Throwable)ex);
                this.runState.addError(new ErrorDescriptor(txt, this.runState.getState(), 30, ex));
            }
        }
        return false;
    }

    public void configure() {
        if (this.configuration != null) {
            MOInput config = this.configuration.createMOInput();
            if (config == null) {
                logger.debug((Serializable)((Object)("No configuration returned by configuration factory " + String.valueOf(this.configuration))));
                return;
            }
            MOServerPersistence serverPersistence = new MOServerPersistence(this.servers);
            try {
                serverPersistence.loadData(config);
            }
            catch (IOException ex) {
                String txt = "Failed to load agent configuration: " + ex.getMessage();
                logger.error((CharSequence)txt, (Throwable)ex);
                this.runState.addError(new ErrorDescriptor(txt, this.runState.getState(), 20, ex));
                throw new RuntimeException(txt, ex);
            }
            finally {
                try {
                    config.close();
                }
                catch (IOException ex1) {
                    logger.warn((Serializable)((Object)("Failed to close config input stream: " + ex1.getMessage())));
                }
            }
        }
        this.runState.advanceState(20);
    }

    protected void linkCounterListener() {
    }

    public void initialize() {
        this.linkCounterListener();
        try {
            this.registerMIBs(this.getDefaultContext());
        }
        catch (DuplicateRegistrationException drex) {
            logger.error((CharSequence)("Duplicate MO registration: " + drex.getMessage()), (Throwable)drex);
        }
        this.runState.advanceState(10);
    }

    public void setTableSizeLimits(Properties sizeLimits) {
        if (this.tableSizeLimit != null && this.servers != null) {
            for (MOServer server : this.servers) {
                DefaultMOServer.unregisterTableRowListener((MOServer)server, this.tableSizeLimit);
            }
        }
        this.tableSizeLimit = new MOTableSizeLimit(sizeLimits);
        if (this.getState().getState() == 40) {
            for (MOServer server : this.servers) {
                DefaultMOServer.registerTableRowListener((MOServer)server, this.tableSizeLimit);
            }
        }
    }

    public void setTableSizeLimit(int sizeLimit) {
        if (this.tableSizeLimit != null && this.servers != null) {
            for (MOServer server : this.servers) {
                DefaultMOServer.unregisterTableRowListener((MOServer)server, this.tableSizeLimit);
            }
        }
        this.tableSizeLimit = new MOTableSizeLimit(sizeLimit);
        if (this.getState().getState() == 40) {
            for (MOServer server : this.servers) {
                DefaultMOServer.registerTableRowListener((MOServer)server, this.tableSizeLimit);
            }
        }
    }

    public OctetString getDefaultContext() {
        return this.defaultContext;
    }

    protected OctetString getContext(MOGroup mibGroup, OctetString defaultContext) {
        return defaultContext;
    }

    protected void registerMIBs(OctetString context) throws DuplicateRegistrationException {
    }

    protected void unregisterMIBs(OctetString context) {
    }

    public MOPriorityProvider getPriorityProvider() {
        return this.priorityProvider;
    }

    public void setPriorityProvider(MOPriorityProvider priorityProvider) {
        this.priorityProvider = priorityProvider;
    }

    public void setPersistenceImportMode(int importMode) {
        this.persistenceImportMode = importMode;
    }

    public int getPersistenceImportMode() {
        return this.persistenceImportMode;
    }

    public Variable getVariable(String name) {
        OID oid;
        OctetString context = null;
        int pos = name.indexOf(58);
        if (pos >= 0) {
            context = new OctetString(name.substring(0, pos));
            oid = new OID(name.substring(pos + 1, name.length()));
        } else {
            oid = new OID(name);
        }
        MOServer server = this.getServer(context);
        final DefaultMOContextScope scope = new DefaultMOContextScope(context, oid, true, oid, true);
        MOQueryWithSource query = new MOQueryWithSource((MOContextScope)scope, false, (Object)this);
        ManagedObject mo = server.lookup((MOQuery)query, null, null, ManagedObject.class);
        if (mo != null) {
            final VariableBinding vb = new VariableBinding(oid);
            final RequestStatus status = new RequestStatus();
            SubRequest<SnmpRequest.SnmpSubRequest> req = new SubRequest<SnmpRequest.SnmpSubRequest>(){
                private boolean completed;
                private MOQuery query;
                final /* synthetic */ SubagentXConfigManager this$0;
                {
                    this.this$0 = this$0;
                }

                public boolean hasError() {
                    return false;
                }

                public void setErrorStatus(int errorStatus) {
                    status.setErrorStatus(errorStatus);
                }

                public int getErrorStatus() {
                    return status.getErrorStatus();
                }

                public RequestStatus getStatus() {
                    return status;
                }

                public MOScope getScope() {
                    return scope;
                }

                public VariableBinding getVariableBinding() {
                    return vb;
                }

                public Request<?, ?, ?> getRequest() {
                    return null;
                }

                public Object getUndoValue() {
                    return null;
                }

                public void setUndoValue(Object undoInformation) {
                }

                public void completed() {
                    this.completed = true;
                }

                public boolean isComplete() {
                    return this.completed;
                }

                public void setTargetMO(ManagedObject<? super SnmpRequest.SnmpSubRequest> managedObject) {
                }

                public ManagedObject<? super SnmpRequest.SnmpSubRequest> getTargetMO() {
                    return null;
                }

                public int getIndex() {
                    return 0;
                }

                public void setQuery(MOQuery query) {
                    this.query = query;
                }

                public MOQuery getQuery() {
                    return this.query;
                }

                public SubRequestIterator<SnmpRequest.SnmpSubRequest> repetitions() {
                    return null;
                }

                public void updateNextRepetition() {
                }

                public Object getUserObject() {
                    return null;
                }

                public void setUserObject(Object userObject) {
                }
            };
            mo.get((SubRequest)req);
            return vb.getVariable();
        }
        return null;
    }

    public class AgentState
    implements org.snmp4j.agent.AgentState {
        private int state = 0;
        private final List<AgentState.ErrorDescriptor> errorsOccurred = new LinkedList<AgentState.ErrorDescriptor>();

        public int getState() {
            return this.state;
        }

        public void setState(int newState) {
            boolean stateChanged = this.state != newState;
            this.state = newState;
            logger.info((CharSequence)("Agent state set to " + newState + " (" + (stateChanged ? "" : "un") + "changed)"));
            SubagentXConfigManager.this.fireAgentStateChange();
        }

        public void advanceState(int newState) {
            if (this.state < newState) {
                this.state = newState;
                logger.info((CharSequence)("Agent state advanced to " + newState));
                SubagentXConfigManager.this.fireAgentStateChange();
            }
        }

        public void addError(AgentState.ErrorDescriptor error) {
            this.errorsOccurred.add(error);
        }

        public List<AgentState.ErrorDescriptor> getErrors() {
            return new ArrayList<AgentState.ErrorDescriptor>(this.errorsOccurred);
        }
    }

    public static class ErrorDescriptor
    implements AgentState.ErrorDescriptor {
        private final Exception exception;
        private final int sourceState;
        private final int targetState;
        private final String description;

        ErrorDescriptor(String descr, int sourceState, int targetState, Exception ex) {
            this.description = descr;
            this.sourceState = sourceState;
            this.targetState = targetState;
            this.exception = ex;
        }

        public String getDescription() {
            return this.description;
        }

        public int getSourceState() {
            return this.sourceState;
        }

        public int getTargetState() {
            return this.targetState;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

