/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport.unix;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;
import java.util.Optional;
import java.util.Set;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportStateReference;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.SecurityLevel;
import org.snmp4j.smi.Address;
import org.snmp4j.transport.AbstractConnectionOrientedTransportMapping;
import org.snmp4j.transport.AbstractSocketEntry;
import org.snmp4j.transport.AbstractTransportServerThread;
import org.snmp4j.transport.MessageLengthDecoder;
import org.snmp4j.transport.unix.UnixDomainAddress;

public class UnixSocketStreamTransportMapping
extends AbstractConnectionOrientedTransportMapping<UnixDomainAddress, SocketEntry> {
    private static final LogAdapter logger = LogFactory.getLogger(UnixSocketStreamTransportMapping.class);
    protected UnixDomainAddress listenAddress;
    protected ServerThread serverThread;

    public UnixSocketStreamTransportMapping(UnixDomainAddress listenAddress) {
        this.listenAddress = listenAddress;
    }

    public UnixSocketStreamTransportMapping() {
        this(null);
    }

    @Override
    public MessageLengthDecoder getMessageLengthDecoder() {
        return null;
    }

    @Override
    public void setMessageLengthDecoder(MessageLengthDecoder messageLengthDecoder) {
    }

    @Override
    public Class<? extends Address> getSupportedAddressClass() {
        return UnixDomainAddress.class;
    }

    @Override
    public Set<Class<? extends Address>> getSupportedAddressClasses() {
        return super.getSupportedAddressClasses();
    }

    @Override
    public UnixDomainAddress getListenAddress() {
        return this.listenAddress;
    }

    @Override
    public void sendMessage(UnixDomainAddress address, byte[] message, TransportStateReference tmStateReference, long timeoutMillis, int maxRetries) throws IOException {
        if (this.getListenWorkerTask() == null || this.serverThread == null) {
            this.listen();
        }
        if (this.serverThread != null) {
            if (this.suspendedAddresses.size() > 0 && this.suspendedAddresses.contains(address)) {
                this.handleDroppedMessageToSend(address, message, tmStateReference, timeoutMillis, maxRetries);
            } else {
                this.serverThread.sendMessage(address, message, tmStateReference, this.sockets);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.listenAddress != null) {
            super.close();
            if (this.listenAddress.getPath() != null) {
                Files.deleteIfExists(this.listenAddress.getPath());
            }
        }
    }

    @Override
    public boolean close(UnixDomainAddress remoteAddress) throws IOException {
        AbstractSocketEntry remoteSocketEntry = (AbstractSocketEntry)this.sockets.remove(remoteAddress);
        if (remoteSocketEntry == null) {
            return false;
        }
        remoteSocketEntry.getSocketChannel().close();
        return true;
    }

    @Override
    public void listen() throws IOException {
        if (this.getListenWorkerTask() != null) {
            throw new SocketException("Port already listening");
        }
        this.serverThread = new ServerThread(this.listenAddress);
        if (logger.isInfoEnabled()) {
            logger.info("Unix socket address " + String.valueOf(this.getListenAddress()) + " bound successfully");
        }
        this.listenWorkerTask = SNMP4JSettings.getThreadFactory().createWorkerThread("UnixSocketStreamTransportMapping_" + String.valueOf(this.getListenAddress()), this.serverThread, true);
        if (this.getConnectionTimeout() > 0L) {
            this.socketCleaner = SNMP4JSettings.getTimerFactory().createTimer();
        }
        this.getListenWorkerTask().run();
    }

    @Override
    public boolean isListening() {
        return this.serverThread != null && !this.serverThread.isStop();
    }

    @Override
    public void wakeupServerSelector() {
        this.serverThread.getSelector().wakeup();
    }

    private static void postBind(UnixDomainAddress address) {
        address.getPath().toFile().deleteOnExit();
    }

    protected Optional<ByteBuffer> readNextInPacket(SocketChannel socketChannel) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(this.getMaxInboundMessageSize());
        int bytesRead = socketChannel.read(buf);
        if (bytesRead < 0) {
            return Optional.empty();
        }
        byte[] bytes = new byte[bytesRead];
        buf.flip();
        buf.get(bytes);
        return Optional.of(ByteBuffer.wrap(bytes));
    }

    protected class ServerThread
    extends AbstractTransportServerThread<UnixDomainAddress, SocketEntry> {
        private ServerThread(UnixDomainAddress unixDomainAddress) throws IOException {
            super(UnixSocketStreamTransportMapping.this, unixDomainAddress);
            this.selector = Selector.open();
            this.initListener(unixDomainAddress, this.selector);
        }

        public Throwable getLastError() {
            return this.lastError;
        }

        public boolean isStop() {
            return this.stop;
        }

        public void setStop(boolean stop) {
            this.stop = stop;
        }

        protected boolean initListener(UnixDomainAddress address, Selector selector) throws IOException {
            if (address != null) {
                ProtocolFamily family = address.getFamily();
                SocketAddress socketAddress = address.getSocketAddress();
                if (socketAddress != null) {
                    this.ssc = ServerSocketChannel.open(family);
                    this.ssc.bind(socketAddress);
                    this.ssc.configureBlocking(false);
                    UnixSocketStreamTransportMapping.postBind(address);
                    this.ssc.register(selector, 16, null);
                    logger.info("Unix Domain Server listening on " + String.valueOf(this.ssc.getLocalAddress()));
                    return true;
                }
            }
            return false;
        }

        @Override
        public void run() {
            this.doServer(UnixSocketStreamTransportMapping.this.sockets);
        }

        @Override
        protected boolean readMessage(SelectionKey sk, SocketChannel socketChannel, UnixDomainAddress incomingAddress, SocketEntry socketEntry) throws IOException {
            TransportStateReference tmStateReference = new TransportStateReference(UnixSocketStreamTransportMapping.this, UnixSocketStreamTransportMapping.this.listenAddress, null, SecurityLevel.undefined, SecurityLevel.undefined, false, socketChannel);
            Optional<ByteBuffer> byteBufferRead = UnixSocketStreamTransportMapping.this.readNextInPacket(socketChannel);
            byteBufferRead.ifPresent(message -> UnixSocketStreamTransportMapping.this.fireProcessMessage(new UnixDomainAddress((UnixDomainSocketAddress)incomingAddress.getSocketAddress()), message, tmStateReference));
            if (byteBufferRead.isEmpty()) {
                String remote = socketChannel.getRemoteAddress().toString();
                if (logger.isInfoEnabled()) {
                    logger.info("UnixDomainServer: closing connection from: " + remote + " with ID " + String.valueOf(socketEntry));
                }
                socketChannel.close();
                return false;
            }
            return true;
        }

        @Override
        protected void processQueues() {
        }

        @Override
        public SocketEntry createSocketEntry(UnixDomainAddress address, SocketChannel socketChannel, boolean useClientMode, TransportStateReference tmStateReference) {
            return new SocketEntry(address, socketChannel);
        }

        @Override
        protected SocketChannel openSocketChannel(ProtocolFamily family) throws IOException {
            return SocketChannel.open(family);
        }

        @Override
        public SocketEntry removeSocketEntry(UnixDomainAddress incomingAddress) {
            return (SocketEntry)UnixSocketStreamTransportMapping.this.sockets.remove(incomingAddress);
        }

        @Override
        protected UnixDomainAddress createIncomingAddress(SocketChannel socketChannel) throws IOException {
            return new UnixDomainAddress((UnixDomainSocketAddress)socketChannel.getRemoteAddress());
        }
    }

    public static class SocketEntry
    extends AbstractSocketEntry<UnixDomainAddress> {
        public SocketEntry(UnixDomainAddress address, SocketChannel socket) {
            super(address, socket);
            this.setHandshakeFinished(true);
        }

        @Override
        public String toString() {
            return String.valueOf(this.getPeerAddress()) + this.getSocketChannel().toString();
        }

        @Override
        public void closeSession() {
            try {
                this.socketChannel.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public Object getSessionID() {
            return this.socketChannel;
        }
    }
}

