/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportMapping;
import org.snmp4j.TransportStateReference;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.TransportListener;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.transport.TransportStateListener;
import org.snmp4j.util.CommonTimer;
import org.snmp4j.util.DefaultThreadFactory;
import org.snmp4j.util.WorkerTask;

public abstract class AbstractTransportMapping<A extends Address>
implements TransportMapping<A> {
    private static final LogAdapter logger = LogFactory.getLogger(AbstractTransportMapping.class);
    protected List<TransportListener> transportListener = new ArrayList<TransportListener>(1);
    protected int maxInboundMessageSize = 65535;
    protected boolean asyncMsgProcessingSupported = true;
    protected Set<A> suspendedAddresses = ConcurrentHashMap.newKeySet(5);
    protected WorkerTask listenWorkerTask;
    protected transient List<TransportStateListener> transportStateListeners;
    protected long connectionTimeout = 60000L;
    protected CommonTimer socketCleaner;

    protected AbstractTransportMapping() {
    }

    @Override
    public abstract Class<? extends Address> getSupportedAddressClass();

    @Override
    public boolean isListening() {
        return this.listenWorkerTask != null;
    }

    @Override
    public abstract void sendMessage(A var1, byte[] var2, TransportStateReference var3, long var4, int var6) throws IOException;

    @Override
    public synchronized void addTransportListener(TransportListener l) {
        if (!this.transportListener.contains(l)) {
            ArrayList<TransportListener> tlCopy = new ArrayList<TransportListener>(this.transportListener);
            tlCopy.add(l);
            this.transportListener = tlCopy;
        }
    }

    @Override
    public synchronized void removeTransportListener(TransportListener l) {
        if (this.transportListener != null && this.transportListener.contains(l)) {
            ArrayList<TransportListener> tlCopy = new ArrayList<TransportListener>(this.transportListener);
            tlCopy.remove(l);
            this.transportListener = tlCopy;
        }
    }

    public synchronized void removeAllTransportListeners() {
        this.transportListener = new ArrayList<TransportListener>(1);
    }

    protected void fireProcessMessage(A address, ByteBuffer buf, TransportStateReference tmStateReference) {
        if (this.transportListener != null) {
            for (TransportListener aTransportListener : this.transportListener) {
                aTransportListener.processMessage(this, address, buf, tmStateReference);
            }
        }
    }

    @Override
    public abstract void close() throws IOException;

    public void suspendAddress(A addressToSuspendSending) {
        if (this.suspendedAddresses.add(addressToSuspendSending)) {
            logger.info("Messages sending to " + String.valueOf(addressToSuspendSending) + " suspended");
        }
    }

    public boolean resumeAddress(A addressToResumeSending) {
        boolean resumed = this.suspendedAddresses.remove(addressToResumeSending);
        if (resumed) {
            logger.info("Messages sending to " + String.valueOf(addressToResumeSending) + " resumed");
        }
        return resumed;
    }

    protected void handleDroppedMessageToSend(A address, byte[] message, TransportStateReference transportStateReference, long timeoutMillis, int maxRetries) {
        logger.warn((Serializable)((Object)("Dropped message, because this transport mapping is suspended: address=" + String.valueOf(address) + ", message=" + OctetString.fromByteArray(message).toHexString())));
    }

    @Override
    public abstract void listen() throws IOException;

    public CommonTimer getSocketCleaner() {
        return this.socketCleaner;
    }

    @Override
    public int getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public boolean isAsyncMsgProcessingSupported() {
        return this.asyncMsgProcessingSupported;
    }

    public void setAsyncMsgProcessingSupported(boolean asyncMsgProcessingSupported) {
        this.asyncMsgProcessingSupported = asyncMsgProcessingSupported;
    }

    public void setPriority(int newPriority) {
        WorkerTask lt = this.getListenWorkerTask();
        if (lt instanceof Thread) {
            ((Thread)((Object)lt)).setPriority(newPriority);
        } else if (lt instanceof DefaultThreadFactory.WorkerThread) {
            ((DefaultThreadFactory.WorkerThread)lt).getThread().setPriority(newPriority);
        }
    }

    public int getPriority() {
        WorkerTask lt = this.getListenWorkerTask();
        if (lt instanceof Thread) {
            return ((Thread)((Object)lt)).getPriority();
        }
        if (lt instanceof DefaultThreadFactory.WorkerThread) {
            return ((DefaultThreadFactory.WorkerThread)lt).getThread().getPriority();
        }
        return 5;
    }

    public void setThreadName(String name) {
        WorkerTask lt = this.getListenWorkerTask();
        if (lt instanceof Thread) {
            ((Thread)((Object)lt)).setName(name);
        } else if (lt instanceof DefaultThreadFactory.WorkerThread) {
            ((DefaultThreadFactory.WorkerThread)lt).getThread().setName(name);
        }
    }

    public String getThreadName() {
        WorkerTask lt = this.getListenWorkerTask();
        if (lt instanceof Thread) {
            return ((Thread)((Object)lt)).getName();
        }
        if (lt instanceof DefaultThreadFactory.WorkerThread) {
            return ((DefaultThreadFactory.WorkerThread)lt).getThread().getName();
        }
        return null;
    }

    public synchronized void addTransportStateListener(TransportStateListener l) {
        if (this.transportStateListeners == null) {
            this.transportStateListeners = new ArrayList<TransportStateListener>(2);
        }
        this.transportStateListeners.add(l);
    }

    public synchronized void removeTransportStateListener(TransportStateListener l) {
        if (this.transportStateListeners != null) {
            this.transportStateListeners.remove(l);
        }
    }

    @Override
    public abstract A getListenAddress();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireConnectionStateChanged(TransportStateEvent change) {
        block8: {
            List<TransportStateListener> listenersFinalRef;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Firing transport state event: " + String.valueOf(change))));
            }
            if ((listenersFinalRef = this.transportStateListeners) != null) {
                try {
                    ArrayList<TransportStateListener> listeners;
                    List<TransportStateListener> list = listenersFinalRef;
                    synchronized (list) {
                        listeners = new ArrayList<TransportStateListener>(listenersFinalRef);
                    }
                    for (TransportStateListener listener : listeners) {
                        listener.connectionStateChanged(change);
                    }
                }
                catch (RuntimeException ex) {
                    logger.error("Exception in fireConnectionStateChanged: " + ex.getMessage(), ex);
                    if (!SNMP4JSettings.isForwardRuntimeExceptions()) break block8;
                    throw ex;
                }
            }
        }
    }

    public WorkerTask getListenWorkerTask() {
        return this.listenWorkerTask;
    }

    public Set<A> getSuspendedAddresses() {
        return Collections.unmodifiableSet(this.suspendedAddresses);
    }
}

