/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.AssignableFromByteArray;
import org.snmp4j.smi.AssignableFromString;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class OctetString
extends AbstractVariable
implements AssignableFromByteArray,
AssignableFromString {
    private static final long serialVersionUID = 4125661211046256289L;
    private static final char DEFAULT_HEX_DELIMITER = ':';
    private byte[] value = new byte[0];

    public OctetString() {
    }

    public OctetString(byte[] rawValue) {
        this(rawValue, 0, rawValue.length);
    }

    public OctetString(byte[] rawValue, int offset, int length) {
        this.value = new byte[length];
        System.arraycopy(rawValue, offset, this.value, 0, length);
    }

    public OctetString(byte[] rawValuePrefix, byte[] rawValueSuffix) {
        this.value = rawValueSuffix == null ? new byte[rawValuePrefix.length] : new byte[rawValuePrefix.length + rawValueSuffix.length];
        System.arraycopy(rawValuePrefix, 0, this.value, 0, rawValuePrefix.length);
        if (rawValueSuffix != null) {
            System.arraycopy(rawValueSuffix, 0, this.value, rawValuePrefix.length, rawValueSuffix.length);
        }
    }

    public OctetString(String stringValue) {
        this.value = stringValue.getBytes();
    }

    public OctetString(OctetString other) {
        this.value = new byte[0];
        this.append(other);
    }

    public static byte[] toByteArray(OctetString octetString) {
        if (octetString == null) {
            return null;
        }
        return octetString.getValue();
    }

    public void append(byte b2) {
        byte[] newValue = new byte[this.value.length + 1];
        System.arraycopy(this.value, 0, newValue, 0, this.value.length);
        newValue[this.value.length] = b2;
        this.value = newValue;
    }

    public void append(byte[] bytes) {
        byte[] newValue = new byte[this.value.length + bytes.length];
        System.arraycopy(this.value, 0, newValue, 0, this.value.length);
        System.arraycopy(bytes, 0, newValue, this.value.length, bytes.length);
        this.value = newValue;
    }

    public void append(OctetString octetString) {
        this.append(octetString.getValue());
    }

    public void append(String string) {
        this.append(string.getBytes());
    }

    public void clear() {
        this.value = new byte[0];
    }

    @Override
    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeString(outputStream, (byte)4, this.getValue());
    }

    @Override
    public void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte type = new BER.MutableByte();
        byte[] v = BER.decodeString(inputStream, type);
        if (type.getValue() != 4) {
            throw new IOException("Wrong type encountered when decoding OctetString: " + type.getValue());
        }
        this.setValue(v);
    }

    @Override
    public int getBERLength() {
        return this.value.length + BER.getBERLengthOfLength(this.value.length) + 1;
    }

    @Override
    public int getSyntax() {
        return 4;
    }

    public final byte get(int index2) {
        return this.value[index2];
    }

    public final void set(int index2, byte b2) {
        this.value[index2] = b2;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.getValue());
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof OctetString) {
            OctetString other = (OctetString)o;
            return Arrays.equals(this.value, other.value);
        }
        return false;
    }

    public boolean equalsValue(byte[] v) {
        return Arrays.equals(this.value, v);
    }

    @Override
    public int compareTo(Variable o) {
        if (o instanceof OctetString) {
            OctetString other = (OctetString)o;
            int maxlen = Math.min(this.value.length, other.value.length);
            for (int i = 0; i < maxlen; ++i) {
                if (this.value[i] == other.value[i]) continue;
                if ((this.value[i] & 0xFF) < (other.value[i] & 0xFF)) {
                    return -1;
                }
                return 1;
            }
            return this.value.length - other.value.length;
        }
        throw new ClassCastException(o.getClass().getName());
    }

    public OctetString substring(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        byte[] substring = new byte[endIndex - beginIndex];
        System.arraycopy(this.value, beginIndex, substring, 0, substring.length);
        return new OctetString(substring);
    }

    public boolean startsWith(OctetString prefix) {
        if (prefix == null || prefix.length() > this.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (prefix.get(i) == this.value[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isPrintable() {
        for (byte aValue : this.value) {
            char c = (char)aValue;
            if (!OctetString.isNonPrintableCharacter(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNonPrintableCharacter(char c) {
        return (Character.isISOControl(c) || (c & 0xFF) >= 128) && (!Character.isWhitespace(c) || (c & 0xFF) >= 28 && (c & 0xFF) <= 31);
    }

    @Override
    public String toString() {
        if (this.isPrintable()) {
            return new String(this.value);
        }
        Character escapeCharacter = SNMP4JSettings.getDefaultNonPrintableEscapeCharacter();
        if (escapeCharacter != null) {
            String rawString = new String(this.value);
            StringBuilder out = new StringBuilder();
            for (char c : rawString.toCharArray()) {
                if (OctetString.isNonPrintableCharacter(c)) {
                    out.append(escapeCharacter);
                    continue;
                }
                out.append(c);
            }
            return out.toString();
        }
        return this.toHexString();
    }

    public String toHexString() {
        return this.toHexString(':');
    }

    public String toHexString(char separator) {
        return this.toString(separator, 16);
    }

    public static OctetString fromHexString(String hexString) {
        return OctetString.fromHexString(hexString, ':');
    }

    public static OctetString fromHexString(String hexString, char delimiter) {
        return OctetString.fromString(hexString, delimiter, 16);
    }

    public static OctetString fromString(String string, char delimiter, int radix) {
        if (string == null) {
            return null;
        }
        Object delim = "";
        delim = (String)delim + delimiter;
        StringTokenizer st = new StringTokenizer(string, (String)delim);
        byte[] value = new byte[st.countTokens()];
        int n = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            value[n] = (byte)Integer.parseInt(s, radix);
            ++n;
        }
        return new OctetString(value);
    }

    public static OctetString fromHexStringPairs(String hexString) {
        if (hexString == null) {
            return null;
        }
        byte[] value = new byte[hexString.length() / 2];
        for (int i = 0; i < value.length; ++i) {
            int h = i * 2;
            value[i] = (byte)Integer.parseInt(hexString.substring(h, h + 2), 16);
        }
        return new OctetString(value);
    }

    public static OctetString fromString(String string, int radix) {
        if (string == null) {
            return null;
        }
        int digits = (int)Math.round((double)((float)Math.log(256.0)) / Math.log(radix));
        byte[] value = new byte[string.length() / digits];
        int k = 0;
        int n = 0;
        while (n + digits <= string.length()) {
            String s = string.substring(n, n + digits);
            value[k++] = (byte)Integer.parseInt(s, radix);
            n += digits;
        }
        return new OctetString(value, 0, k);
    }

    public static OctetString fromCharArray(char[] string, char delimiter, int radix) {
        if (string == null) {
            return null;
        }
        CharBuffer charBuffer = CharBuffer.allocate(8);
        ByteBuffer byteBuffer = ByteBuffer.allocate(string.length);
        for (char next : string) {
            if (next != delimiter) {
                charBuffer.append(next);
                continue;
            }
            byteBuffer.put((byte)Integer.parseInt(charBuffer.flip(), 0, charBuffer.length(), radix));
        }
        if (charBuffer.position() > 0) {
            byteBuffer.put((byte)Integer.parseInt(charBuffer.flip(), 0, charBuffer.length(), radix));
        }
        Arrays.fill(charBuffer.array(), '\u0000');
        return new OctetString(byteBuffer.flip().array(), 0, byteBuffer.limit());
    }

    public static OctetString fromCharArray(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        return new OctetString(bytes);
    }

    public static OctetString fromString(String stringOrNull) {
        if (stringOrNull == null) {
            return null;
        }
        return new OctetString(stringOrNull);
    }

    public String toString(char separator, int radix) {
        int digits = (int)Math.round((double)((float)Math.log(256.0)) / Math.log(radix));
        StringBuilder buf = new StringBuilder(this.value.length * (digits + 1));
        for (int i = 0; i < this.value.length; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            int v = this.value[i] & 0xFF;
            String val = Integer.toString(v, radix);
            for (int j = 0; j < digits - val.length(); ++j) {
                buf.append('0');
            }
            buf.append(val);
        }
        return buf.toString();
    }

    public String toString(int radix) {
        int digits = (int)Math.round((double)((float)Math.log(256.0)) / Math.log(radix));
        StringBuilder buf = new StringBuilder(this.value.length * (digits + 1));
        for (byte aValue : this.value) {
            int v = aValue & 0xFF;
            String val = Integer.toString(v, radix);
            for (int j = 0; j < digits - val.length(); ++j) {
                buf.append('0');
            }
            buf.append(val);
        }
        return buf.toString();
    }

    public String toASCII(char placeholder) {
        StringBuilder buf = new StringBuilder(this.value.length);
        for (byte aValue : this.value) {
            if (Character.isISOControl((char)aValue) || (aValue & 0xFF) >= 128) {
                buf.append(placeholder);
                continue;
            }
            buf.append((char)aValue);
        }
        return buf.toString();
    }

    @Override
    public void setValue(String value) {
        this.setValue(value.getBytes());
    }

    @Override
    public void setValue(byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("OctetString must not be assigned a null value");
        }
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    public final int length() {
        return this.value.length;
    }

    @Override
    public Object clone() {
        return new OctetString(this.value);
    }

    @Override
    public int getBERPayloadLength() {
        return this.value.length;
    }

    @Override
    public int toInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long toLong() {
        throw new UnsupportedOperationException();
    }

    public OctetString mask(OctetString mask) {
        byte[] masked = new byte[this.value.length];
        System.arraycopy(this.value, 0, masked, 0, this.value.length);
        for (int i = 0; i < mask.length() && i < masked.length; ++i) {
            masked[i] = (byte)(masked[i] & mask.get(i));
        }
        return new OctetString(masked);
    }

    @Override
    public OID toSubIndex(boolean impliedLength) {
        int[] subIndex;
        int offset = 0;
        if (!impliedLength) {
            subIndex = new int[this.length() + 1];
            subIndex[offset++] = this.length();
        } else {
            subIndex = new int[this.length()];
        }
        for (int i = 0; i < this.length(); ++i) {
            subIndex[offset + i] = this.get(i) & 0xFF;
        }
        return new OID(subIndex);
    }

    public static OctetString fromIndex(OID subIndex, int beginIndex, boolean impliedLength) {
        int startIndex = beginIndex + (impliedLength ? 0 : 1);
        int endIndex = impliedLength ? subIndex.size() - beginIndex : startIndex + subIndex.get(beginIndex);
        return new OctetString(subIndex.subOID(startIndex, endIndex).toByteArray());
    }

    @Override
    public void fromSubIndex(OID subIndex, boolean impliedLength) {
        if (impliedLength) {
            this.setValue(subIndex.toByteArray());
        } else {
            OID suffix = new OID(subIndex.getValue(), 1, subIndex.size() - 1);
            this.setValue(suffix.toByteArray());
        }
    }

    public static Collection<OctetString> split(OctetString octetString, OctetString delimOctets) {
        LinkedList<OctetString> parts = new LinkedList<OctetString>();
        int maxDelim = -1;
        for (int i = 0; i < delimOctets.length(); ++i) {
            int delim = delimOctets.get(i) & 0xFF;
            if (delim <= maxDelim) continue;
            maxDelim = delim;
        }
        int startPos = 0;
        for (int i = 0; i < octetString.length(); ++i) {
            int c = octetString.value[i] & 0xFF;
            boolean isDelim = false;
            if (c <= maxDelim) {
                for (int j = 0; j < delimOctets.length(); ++j) {
                    if (c != (delimOctets.get(j) & 0xFF)) continue;
                    if (startPos >= 0 && i > startPos) {
                        parts.add(new OctetString(octetString.value, startPos, i - startPos));
                    }
                    startPos = -1;
                    isDelim = true;
                }
            }
            if (isDelim || startPos >= 0) continue;
            startPos = i;
        }
        if (startPos >= 0) {
            parts.add(new OctetString(octetString.value, startPos, octetString.length() - startPos));
        }
        return parts;
    }

    public static OctetString fromByteArray(byte[] value) {
        if (value == null) {
            return null;
        }
        return new OctetString(value);
    }

    @Override
    public byte[] toByteArray() {
        return this.getValue();
    }
}

