/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.util.Arrays;
import java.util.Objects;

public class ByteArrayWindow {
    private byte[] value;
    private int offset;
    private int length;

    public ByteArrayWindow(byte[] value, int offset, int length) {
        this.value = value;
        this.offset = offset;
        this.length = length;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public int getOffset() {
        return this.offset;
    }

    public void set(int i, byte b2) {
        if (i >= this.length) {
            throw new IndexOutOfBoundsException(i + " >= " + this.length);
        }
        if (i < 0) {
            throw new IndexOutOfBoundsException("" + i);
        }
        this.value[i + this.offset] = b2;
    }

    public byte get(int i) {
        if (i >= this.length) {
            throw new IndexOutOfBoundsException(i + " >= " + this.length);
        }
        if (i < 0) {
            throw new IndexOutOfBoundsException("" + i);
        }
        return this.value[i + this.offset];
    }

    public int getLength() {
        return this.length;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteArrayWindow) {
            ByteArrayWindow other = (ByteArrayWindow)obj;
            if (other.length != this.length) {
                return false;
            }
            for (int i = 0; i < this.length; ++i) {
                if (other.value[i] == this.value[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(ByteArrayWindow other, int maxBytesToCompare) {
        if (other.length < maxBytesToCompare || this.length < maxBytesToCompare) {
            return false;
        }
        for (int i = 0; i < maxBytesToCompare; ++i) {
            if (this.value[this.offset + i] == other.value[other.offset + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Objects.hash(this.getOffset(), this.getLength());
        result = 31 * result + Arrays.hashCode(this.getValue());
        return result;
    }
}

