/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.db;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.bindings.CompressedUnsignedLongArrayByteIterable;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.ReadonlyTransactionException;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOScopeComparator;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.RandomAccessManagedObject;
import org.snmp4j.agent.io.ImportMode;
import org.snmp4j.agent.mo.MOChangeEvent;
import org.snmp4j.agent.mo.MOChangeListener;
import org.snmp4j.agent.mo.MOPriorityProvider;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.util.MOScopePriorityComparator;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BEROutputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class MOXodusPersistence
implements MOChangeListener {
    private static final LogAdapter logger = LogFactory.getLogger(MOXodusPersistence.class);
    private final MOServer[] moServers;
    private final Environment environment;
    private boolean ignoreChangeListenerEvents;
    private int continuousChangeListening = 0;
    private SavingStrategy savingStrategy = SavingStrategy.onChangeEventsOnly;
    private MOScopeComparator moScopeComparator = new MOScopeComparator();
    private Map<OID, Boolean> persistenceExceptionList;

    public MOXodusPersistence(MOServer[] moServers, Environment environment) {
        this(moServers, environment, SavingStrategy.onChangeEventsOnly);
    }

    public MOXodusPersistence(MOServer[] moServers, Environment environment, SavingStrategy savingStrategy) {
        this.moServers = moServers;
        this.environment = environment;
        this.savingStrategy = savingStrategy;
    }

    public MOXodusPersistence(MOServer[] moServers, Environment environment, SavingStrategy savingStrategy, MOScopeComparator moScopeComparator) {
        this(moServers, environment, savingStrategy);
        if (moScopeComparator != null) {
            this.moScopeComparator = moScopeComparator;
        }
    }

    public SavingStrategy getSavingStrategy() {
        return this.savingStrategy;
    }

    public void setSavingStrategy(SavingStrategy savingStrategy) {
        this.savingStrategy = savingStrategy;
    }

    public boolean isIgnoreChangeListenerEvents() {
        return this.ignoreChangeListenerEvents;
    }

    public void setIgnoreChangeListenerEvents(boolean ignoreChangeListenerEvents) {
        this.ignoreChangeListenerEvents = ignoreChangeListenerEvents;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public boolean isContinuousChangeListening() {
        return this.continuousChangeListening > 1;
    }

    public synchronized void registerChangeListenersWithServer(MOServer moServer) {
        DefaultMOServer.registerChangeListener(moServer, this, mo -> mo instanceof RandomAccessManagedObject);
        this.continuousChangeListening = 1;
    }

    public synchronized void unregisterChangeListenersWithServer(MOServer moServer) {
        DefaultMOServer.unregisterChangeListener(moServer, this, mo -> mo instanceof RandomAccessManagedObject);
        this.continuousChangeListening = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isContextLoadable(OctetString context) {
        Transaction txn = this.environment.beginReadonlyTransaction();
        try {
            boolean bl = this.environment.storeExists(this.storeNameFromContext(context), txn);
            return bl;
        }
        finally {
            txn.abort();
        }
    }

    public void load(ImportMode importMode) {
        this.load(importMode, null);
    }

    public synchronized void load(ImportMode importMode, MOPriorityProvider priorityProvider) {
        this.load(importMode, priorityProvider, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(ImportMode importMode, MOPriorityProvider priorityProvider, boolean includeVolatile) {
        try {
            MOScopeComparator moScopeComparator = this.moScopeComparator;
            this.setIgnoreChangeListenerEvents(true);
            this.continuousChangeListening = this.continuousChangeListening > 0 ? (this.continuousChangeListening = 2) : 0;
            Transaction txn = this.environment.beginReadonlyTransaction();
            for (MOServer moServer : this.moServers) {
                HashMap<OctetString, Store> stores = new HashMap<OctetString, Store>();
                ManagedObject<?> bootMO = this.runSyncOnBootMO(txn, moServer, stores, importMode, priorityProvider, null);
                for (OctetString context : moServer.getContexts()) {
                    try {
                        if (!stores.containsKey(context)) {
                            stores.put(context, this.createStore(txn, context));
                        }
                        MOScopeComparator moScopeComparatorCtx = this.getMoScopeComparatorForContext(importMode, priorityProvider, moScopeComparator, txn, moServer, stores, bootMO, context);
                        Iterator<Map.Entry<MOScope, ManagedObject<?>>> moIterator = moServer.iterator(moScopeComparatorCtx, null);
                        this.runSynchronization(stores, txn, importMode, moIterator, includeVolatile);
                    }
                    catch (ReadonlyTransactionException rotex) {
                        logger.info("No persistent data for context '" + String.valueOf(context) + "' context found");
                    }
                }
                if (!moServer.isContextSupported(null)) continue;
                try {
                    MOScopeComparator moScopeComparatorCtx = this.getMoScopeComparatorForContext(importMode, priorityProvider, moScopeComparator, txn, moServer, stores, bootMO, null);
                    Iterator<Map.Entry<MOScope, ManagedObject<?>>> moIterator = moServer.iterator(moScopeComparatorCtx, mo -> mo != bootMO);
                    this.runSynchronization(stores, txn, importMode, moIterator, includeVolatile);
                }
                catch (ReadonlyTransactionException rotex) {
                    logger.info("No persistent data for context default context found");
                }
            }
            txn.abort();
        }
        finally {
            this.setIgnoreChangeListenerEvents(false);
        }
    }

    private MOScopeComparator getMoScopeComparatorForContext(ImportMode importMode, MOPriorityProvider priorityProvider, MOScopeComparator moScopeComparator, Transaction txn, MOServer moServer, Map<OctetString, Store> stores, ManagedObject<?> bootMO, OctetString context) {
        if (bootMO != null) {
            ManagedObject<?> contextBootMO = priorityProvider.getBootManagedObject(context);
            if (contextBootMO != bootMO) {
                this.runSyncOnBootMO(txn, moServer, stores, importMode, priorityProvider, context);
            }
            SortedMap<OID, Integer> priorityMap = priorityProvider.getPriorityMap(context);
            moScopeComparator = new MOScopePriorityComparator(priorityMap);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Using priority map " + String.valueOf(priorityMap) + " for context " + String.valueOf(context))));
            }
        }
        return moScopeComparator;
    }

    protected ManagedObject<?> runSyncOnBootMO(Transaction txn, MOServer moServer, Map<OctetString, Store> stores, ImportMode importMode, MOPriorityProvider priorityProvider, OctetString context) {
        ManagedObject<?> bootMO;
        block8: {
            boolean contextSupported;
            MOScope scope = null;
            bootMO = null;
            if (priorityProvider != null) {
                bootMO = priorityProvider.getBootManagedObject(context);
                scope = moServer.getRegisteredScopes(bootMO).get(context);
            }
            if (contextSupported = moServer.isContextSupported(context)) {
                try {
                    stores.put(context == null ? new OctetString() : context, this.createStore(txn, context));
                    if (bootMO == null) break block8;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Boot MO for context '" + String.valueOf(context) + "' is '" + String.valueOf(bootMO) + "', loading it.")));
                    }
                    try {
                        HashMap bootTask = new HashMap();
                        bootTask.put(scope, bootMO);
                        this.runSynchronization(stores, txn, importMode, bootTask.entrySet().iterator(), true);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("Boot MO loaded '" + String.valueOf(bootMO) + "' for context '" + String.valueOf(context) + "', order is: " + String.valueOf(priorityProvider.getPriorityMap(context)))));
                        }
                    }
                    catch (ReadonlyTransactionException rotex) {
                        logger.info("No persistent data for context " + String.valueOf(context == null ? "<default>" : context) + " context found");
                    }
                }
                catch (ReadonlyTransactionException rotex) {
                    logger.warn((Serializable)((Object)("No persistent data for context " + String.valueOf(context == null ? "<default>" : context) + " context found/accessible")));
                }
            }
        }
        return bootMO;
    }

    protected Store createStore(Transaction txn, OctetString context) {
        return this.environment.openStore(this.storeNameFromContext(context), StoreConfig.WITHOUT_DUPLICATES, txn);
    }

    protected String storeNameFromContext(OctetString context) {
        return context == null ? "" : context.toHexString();
    }

    public MOServer[] getMOServer() {
        return this.moServers;
    }

    public synchronized MOScopeComparator getMoScopeComparator() {
        return this.moScopeComparator;
    }

    public synchronized void setMoScopeComparator(MOScopeComparator moScopeComparator) {
        this.moScopeComparator = moScopeComparator == null ? new MOScopeComparator() : moScopeComparator;
    }

    protected void runSynchronization(Map<OctetString, Store> stores, Transaction txn, ImportMode importMode, Iterator<Map.Entry<MOScope, ManagedObject<?>>> moIterator, boolean includeVolatile) {
        while (moIterator.hasNext()) {
            Store store;
            RandomAccessManagedObject randomAccessManagedObject;
            Map.Entry<MOScope, ManagedObject<?>> entry = moIterator.next();
            if (entry.getValue() instanceof MOScalar) {
                logger.debug((Serializable)((Object)("MOScalar " + String.valueOf(entry.getValue()))));
            }
            if (!(entry.getValue() instanceof RandomAccessManagedObject) || !this.isPersistent(randomAccessManagedObject = (RandomAccessManagedObject)entry.getValue(), randomAccessManagedObject.getScope().getLowerBound(), null, includeVolatile)) continue;
            OctetString context = new OctetString();
            if (entry.getKey() instanceof MOContextScope) {
                context = ((MOContextScope)entry.getKey()).getContext();
            }
            if ((store = stores.get(context)) == null) {
                logger.info("DB store for context '" + String.valueOf(context) + "' not found, creating it.");
                store = this.createStore(txn, context);
            }
            Cursor cursor = store.openCursor(txn);
            OID oid = entry.getKey().getLowerBound();
            HashSet<OID> exported = null;
            ByteIterable objectKey = cursor.getSearchKeyRange(this.getKey(oid, new OID()));
            if (objectKey != null) {
                OID instanceOID;
                while ((instanceOID = this.getKeyOid(cursor.getKey())).startsWith(oid)) {
                    OID index2 = instanceOID.getSuffix(oid);
                    ByteIterable rawValues = cursor.getValue();
                    List<VariableBinding> rawVBS = this.decodeInstanceData(rawValues);
                    if (rawVBS == null || rawVBS.isEmpty()) {
                        if (!logger.isWarnEnabled()) break;
                        logger.warn((Serializable)((Object)("Unable to load persistent data: " + new OctetString(rawValues.getBytesUnsafe()).toHexString())));
                        break;
                    }
                    if (importMode == null) {
                        if (exported == null) {
                            exported = new HashSet<OID>(randomAccessManagedObject.instanceCount());
                        }
                        List<VariableBinding> exportVbs = null;
                        if (!randomAccessManagedObject.isVolatile(index2)) {
                            exportVbs = randomAccessManagedObject.exportInstance(index2);
                        }
                        if (exportVbs == null) {
                            cursor.deleteCurrent();
                        } else if (this.savingStrategy == SavingStrategy.checkForModificationsOnSave) {
                            byte[] exportRawValues = this.encodeInstanceData(exportVbs);
                            ArrayByteIterable exportByteIterable = new ArrayByteIterable(exportRawValues);
                            if (rawValues.compareTo(exportByteIterable) != 0) {
                                ByteIterable key = this.getKey(oid, index2);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Serializable)((Object)("Saving modified " + String.valueOf(context) + ":" + String.valueOf(oid) + "|" + String.valueOf(index2) + " (" + String.valueOf(key) + ") = " + String.valueOf(SNMP4JSettings.isSecretLoggingEnabled() != false ? new OctetString(exportRawValues).toHexString() + " <- " + String.valueOf(exportVbs) : Integer.valueOf(exportVbs.size())))));
                                }
                                store.put(txn, key, new ArrayByteIterable(rawValues));
                                exported.add(index2);
                            }
                        } else {
                            this.putInstanceData(txn, context, store, oid, index2, exportVbs);
                            exported.add(index2);
                        }
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("Loading data for " + String.valueOf(oid) + " with index " + String.valueOf(index2) + " (" + String.valueOf(cursor.getKey()) + "): " + String.valueOf(SNMP4JSettings.isSecretLoggingEnabled() != false ? rawVBS : Integer.valueOf(rawVBS.size())))));
                        }
                        randomAccessManagedObject.importInstance(index2, rawVBS, importMode);
                    }
                    if (cursor.getNext()) continue;
                    break;
                }
            }
            if (importMode == null) {
                Iterator<OID> oidIterator = randomAccessManagedObject.instanceIterator();
                while (oidIterator.hasNext()) {
                    OID nextInstanceOID = oidIterator.next();
                    if (exported != null && exported.contains(nextInstanceOID)) continue;
                    List<VariableBinding> vbs = null;
                    if (!randomAccessManagedObject.isVolatile(nextInstanceOID)) {
                        vbs = randomAccessManagedObject.exportInstance(nextInstanceOID);
                    }
                    if (vbs == null) continue;
                    this.putInstanceData(txn, context, store, oid, nextInstanceOID, vbs);
                }
            }
            cursor.close();
        }
    }

    private void putInstanceData(Transaction txn, OctetString context, Store store, OID oid, OID index2, List<VariableBinding> vbs) {
        byte[] rawValues = this.encodeInstanceData(vbs);
        ByteIterable key = this.getKey(oid, index2);
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Saving " + String.valueOf(context) + ":" + String.valueOf(oid) + "|" + String.valueOf(index2) + " (" + String.valueOf(key) + ") = " + String.valueOf(SNMP4JSettings.isSecretLoggingEnabled() != false ? new OctetString(rawValues).toHexString() + " <- " + String.valueOf(vbs) : Integer.valueOf(vbs.size())))));
        }
        store.put(txn, key, new ArrayByteIterable(rawValues));
    }

    protected List<VariableBinding> decodeInstanceData(ByteIterable rawData) {
        BERInputStream inputStream = new BERInputStream(ByteBuffer.wrap(rawData.getBytesUnsafe(), 0, rawData.getLength()));
        try {
            BER.MutableByte pduType = new BER.MutableByte();
            int vbLength = BER.decodeHeader(inputStream, pduType);
            if (pduType.getValue() != 48) {
                throw new IOException("Encountered invalid tag, SEQUENCE expected: " + pduType.getValue());
            }
            int startPos = (int)inputStream.getPosition();
            ArrayList<VariableBinding> variableBindings = new ArrayList<VariableBinding>();
            while (inputStream.getPosition() - (long)startPos < (long)vbLength) {
                VariableBinding vb = this.decodeVariableBinding(inputStream);
                variableBindings.add(vb);
            }
            if (inputStream.getPosition() - (long)startPos != (long)vbLength) {
                throw new IOException("Length of VB sequence (" + vbLength + ") does not match real length: " + ((int)inputStream.getPosition() - startPos));
            }
            return variableBindings;
        }
        catch (IOException e) {
            logger.error(e);
            return null;
        }
    }

    protected byte[] encodeInstanceData(List<VariableBinding> vbs) {
        ArrayList<VariableBinding> exports = new ArrayList<VariableBinding>(vbs.size());
        exports.addAll(vbs);
        int vbLength = 0;
        for (VariableBinding variableBinding : exports) {
            int indexOIDLength = MOXodusPersistence.getIndexOIDLength(variableBinding.getOid().getValue());
            int subLength = indexOIDLength + BER.getBERLengthOfLength(indexOIDLength) + 1 + variableBinding.getVariable().getBERLength();
            vbLength += BER.getBERLengthOfLength(subLength) + 1 + subLength;
        }
        BEROutputStream berOutputStream = new BEROutputStream(ByteBuffer.allocate(vbLength + BER.getBERLengthOfLength(vbLength) + 1));
        try {
            BER.encodeHeader(berOutputStream, 48, vbLength);
            for (VariableBinding vb : exports) {
                this.encodeVariableBinding(vb, berOutputStream);
            }
            berOutputStream.flush();
            berOutputStream.close();
            return berOutputStream.getBuffer().array();
        }
        catch (IOException iOException) {
            logger.error(iOException);
            return null;
        }
    }

    protected VariableBinding decodeVariableBinding(BERInputStream inputStream) throws IOException {
        BER.MutableByte type = new BER.MutableByte();
        int length = BER.decodeHeader(inputStream, type);
        if (type.getValue() != 48) {
            throw new IOException("Invalid sequence encoding: " + type.getValue());
        }
        OID index2 = new OID(MOXodusPersistence.decodeIndexOID(inputStream, type));
        Variable variable = AbstractVariable.createFromBER(inputStream);
        return new VariableBinding(index2, variable);
    }

    protected void encodeVariableBinding(VariableBinding vb, BEROutputStream outputStream) throws IOException {
        Variable variable = vb.getVariable();
        int indexOIDLength = MOXodusPersistence.getIndexOIDLength(vb.getOid().getValue());
        int length = indexOIDLength + BER.getBERLengthOfLength(indexOIDLength) + variable.getBERLength();
        BER.encodeHeader(outputStream, 48, length);
        MOXodusPersistence.encodeIndexOID(outputStream, (byte)6, vb.getOid().getValue());
        variable.encodeBER(outputStream);
    }

    protected ByteIterable getKey(OID oid, OID instanceID) {
        if (instanceID == null || instanceID.size() == 0) {
            return CompressedUnsignedLongArrayByteIterable.getIterable(oid.toUnsignedLongArray());
        }
        OID instanceOID = new OID(oid.getValue(), instanceID.getValue());
        return CompressedUnsignedLongArrayByteIterable.getIterable(instanceOID.toUnsignedLongArray());
    }

    protected OID getKeyOid(ByteIterable key) {
        int len = key.getLength();
        ByteIterator byteIterator = key.iterator();
        byte bytesPerLong = byteIterator.next();
        int[] values2 = new int[(len - 1) / bytesPerLong];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = (int)byteIterator.nextLong(bytesPerLong);
        }
        return new OID(values2);
    }

    public void save() {
        this.save(null);
    }

    public synchronized void save(MOPriorityProvider priorityProvider) {
        try {
            if (this.savingStrategy != SavingStrategy.onChangeEventsOnly || !this.isContinuousChangeListening()) {
                this.saveFullDump(priorityProvider, false);
            }
        }
        finally {
            this.setIgnoreChangeListenerEvents(false);
        }
    }

    public synchronized void saveFullDump(MOPriorityProvider priorityProvider, boolean includeVolatile) {
        for (MOServer moServer : this.moServers) {
            Transaction txn = this.environment.beginExclusiveTransaction();
            HashMap<OctetString, Store> stores = new HashMap<OctetString, Store>();
            for (OctetString context : moServer.getContexts()) {
                MOScopeComparator moScopeComparator = this.moScopeComparator;
                if (!stores.containsKey(context)) {
                    stores.put(context, this.createStore(txn, context));
                    moScopeComparator = this.getContextComparator(priorityProvider, moScopeComparator, context);
                }
                Iterator<Map.Entry<MOScope, ManagedObject<?>>> moIterator = moServer.iterator(moScopeComparator, null);
                this.runSynchronization(stores, txn, null, moIterator, includeVolatile);
            }
            if (moServer.isContextSupported(null)) {
                stores.put(new OctetString(), this.environment.openStore("", StoreConfig.WITHOUT_DUPLICATES, txn));
                MOScopeComparator moScopeComparator = this.moScopeComparator;
                moScopeComparator = this.getContextComparator(priorityProvider, moScopeComparator, null);
                Iterator<Map.Entry<MOScope, ManagedObject<?>>> moIterator = moServer.iterator(moScopeComparator, null);
                this.runSynchronization(stores, txn, null, moIterator, includeVolatile);
            }
            txn.flush();
            txn.commit();
        }
    }

    private MOScopeComparator getContextComparator(MOPriorityProvider priorityProvider, MOScopeComparator moScopeComparator, OctetString context) {
        if (priorityProvider == null) {
            return moScopeComparator;
        }
        SortedMap<OID, Integer> priorityMap = priorityProvider.getPriorityMap(context);
        if (priorityMap != null) {
            moScopeComparator = new MOScopePriorityComparator(priorityMap);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Priority map for context '" + String.valueOf(context) + "' is: " + String.valueOf(priorityProvider.getPriorityMap(context)))));
            }
        }
        return moScopeComparator;
    }

    public static void encodeIndexOID(OutputStream os, byte type, int[] oid) throws IOException {
        BER.encodeHeader(os, type, MOXodusPersistence.getIndexOIDLength(oid));
        int encodedLength = oid.length;
        int rpos = 0;
        while (encodedLength-- > 0) {
            BER.encodeSubID(os, oid[rpos++]);
        }
    }

    public static int getIndexOIDLength(int[] value) {
        int length = 0;
        for (int j : value) {
            length += BER.getSubIDLength(j);
        }
        return length;
    }

    public static int[] decodeIndexOID(BERInputStream is, BER.MutableByte type) throws IOException {
        type.setValue((byte)is.read());
        if (type.getValue() != 6) {
            throw new IOException("Wrong type. Not an OID: " + type.getValue() + BER.getPositionMessage(is));
        }
        int length = BER.decodeLength(is);
        int[] oid = new int[length];
        int pos = 0;
        while (length > 0) {
            int b2;
            int subidentifier = 0;
            do {
                int next;
                if ((next = is.read()) < 0) {
                    throw new IOException("Unexpected end of input stream" + BER.getPositionMessage(is));
                }
                b2 = next & 0xFF;
                subidentifier = (subidentifier << 7) + (b2 & 0x7F);
            } while (--length > 0 && (b2 & 0xFFFFFF80) != 0);
            oid[pos++] = subidentifier;
        }
        if (pos < oid.length) {
            int[] value = new int[pos];
            System.arraycopy(oid, 0, value, 0, pos);
            return value;
        }
        return oid;
    }

    @Override
    public void beforePrepareMOChange(MOChangeEvent changeEvent) {
    }

    @Override
    public void afterPrepareMOChange(MOChangeEvent changeEvent) {
    }

    @Override
    public void beforeMOChange(MOChangeEvent changeEvent) {
    }

    public Map<OID, Boolean> getPersistenceExceptionList() {
        return this.persistenceExceptionList;
    }

    public void setPersistenceExceptionList(Map<OID, Boolean> persistenceExceptionList) {
        this.persistenceExceptionList = persistenceExceptionList;
    }

    @Override
    public void afterMOChange(MOChangeEvent changeEvent) {
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Managed object " + String.valueOf(changeEvent.getChangedObject().getScope()) + " changed")));
        }
        if (!this.isIgnoreChangeListenerEvents()) {
            ManagedObject<SubRequest<?>> managedObject = changeEvent.getChangedObject();
            if (managedObject instanceof RandomAccessManagedObject) {
                RandomAccessManagedObject randomAccessManagedObject = (RandomAccessManagedObject)managedObject;
                OID instanceID = changeEvent.getOID();
                if (changeEvent.getOidType() != MOChangeEvent.OidType.index) {
                    instanceID = instanceID.getSuffix(managedObject.getScope().getLowerBound());
                }
                if (!this.isPersistent(randomAccessManagedObject, randomAccessManagedObject.getScope().getLowerBound(), instanceID, false)) {
                    return;
                }
                Set<OctetString> contexts = this.getContexts(managedObject);
                if (!contexts.isEmpty()) {
                    List<VariableBinding> vbs = randomAccessManagedObject.exportInstance(instanceID);
                    Transaction txn = this.environment.beginTransaction();
                    if (changeEvent.getModification() == null) {
                        for (OctetString context : contexts) {
                            Store store = this.createStore(txn, context);
                            this.putInstanceData(txn, context, store, managedObject.getScope().getLowerBound(), instanceID, vbs);
                        }
                    } else {
                        switch (changeEvent.getModification()) {
                            case removed: {
                                for (OctetString context : contexts) {
                                    Store store = this.createStore(txn, context);
                                    store.delete(txn, this.getKey(managedObject.getScope().getLowerBound(), instanceID));
                                    if (!logger.isDebugEnabled()) continue;
                                    logger.debug((Serializable)((Object)("Removed managed object " + String.valueOf(changeEvent.getChangedObject()) + "|" + String.valueOf(instanceID))));
                                }
                                break;
                            }
                            case added: 
                            case updated: {
                                for (OctetString context : contexts) {
                                    Store store = this.createStore(txn, context);
                                    this.putInstanceData(txn, context, store, managedObject.getScope().getLowerBound(), instanceID, vbs);
                                }
                                break;
                            }
                        }
                    }
                    txn.flush();
                    txn.commit();
                } else {
                    logger.warn((Serializable)((Object)("Managed object " + String.valueOf(changeEvent.getChangedObject()) + " is not registered to any MOServer known to " + String.valueOf(this))));
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Ignored change event " + String.valueOf(changeEvent))));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isPersistent(RandomAccessManagedObject<?> managedObject, OID instanceOID, OID instanceSubID, boolean includeVolatile) {
        if (includeVolatile || (instanceSubID != null ? managedObject.isVolatile(instanceSubID) : managedObject.isVolatile())) {
            if (this.isExceptionalPersistent(instanceOID)) {
                if (!logger.isDebugEnabled()) return true;
                logger.debug((Serializable)((Object)("Change of volatile " + String.valueOf(managedObject) + " is accepted by exception list")));
                return true;
            }
            if (instanceSubID == null) {
                if (!logger.isDebugEnabled()) return false;
                logger.debug((Serializable)((Object)("Ignored change of " + String.valueOf(managedObject) + " because it is volatile")));
                return false;
            }
            if (!logger.isDebugEnabled()) return false;
            logger.debug((Serializable)((Object)("Sub-instance " + String.valueOf(instanceSubID) + " from " + String.valueOf(managedObject) + " is volatile")));
            return false;
        }
        if (!this.isExceptionalNonPersistent(instanceOID)) return true;
        if (!logger.isDebugEnabled()) return false;
        logger.debug((Serializable)((Object)("Ignored change of " + String.valueOf(managedObject) + " because it is not accepted by exception list")));
        return false;
    }

    private boolean isExceptionalPersistent(OID oid) {
        return this.persistenceExceptionList != null && Objects.requireNonNullElse(this.persistenceExceptionList.get(oid), false) != false;
    }

    private boolean isExceptionalNonPersistent(OID oid) {
        return this.persistenceExceptionList != null && Objects.requireNonNullElse(this.persistenceExceptionList.get(oid), true) == false;
    }

    protected Set<OctetString> getContexts(ManagedObject<?> managedObject) {
        HashSet<OctetString> contexts = new HashSet<OctetString>();
        for (MOServer moServer : this.moServers) {
            contexts.addAll(Arrays.asList(moServer.getRegisteredContexts(managedObject)));
        }
        return contexts;
    }

    public static enum SavingStrategy {
        onChangeEventsOnly,
        checkForModificationsOnSave,
        fullDumpOnSave;

    }
}

