/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.master.index;

import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.snmp4j.agent.agentx.master.index.IndexEntry;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class IndexRegistryEntry
implements Comparable<IndexRegistryEntry> {
    private static final LogAdapter LOGGER = LogFactory.getLogger(IndexRegistryEntry.class);
    private final OctetString context;
    private final VariableBinding indexType;
    protected SortedMap<IndexEntry, IndexEntry> indexValues = new TreeMap<IndexEntry, IndexEntry>(new IndexComparator());
    protected SortedMap<IndexEntry, IndexEntry> usedValues = new TreeMap<IndexEntry, IndexEntry>(new IndexComparator());

    public IndexRegistryEntry(OctetString context, VariableBinding indexType) {
        this.context = context == null ? new OctetString() : context;
        this.indexType = indexType;
    }

    protected IndexEntry newIndexEntry(int sessionID, Variable indexValue) {
        return new IndexEntry(sessionID, indexValue);
    }

    protected void duplicateAllocation(IndexEntry entry) {
    }

    public synchronized int allocate(int sessionID, Variable indexValue, boolean testOnly) {
        IndexEntry newEntry = this.newIndexEntry(sessionID, indexValue);
        if (indexValue.getSyntax() != this.indexType.getSyntax()) {
            return 258;
        }
        IndexEntry oldEntry = (IndexEntry)this.indexValues.get(newEntry);
        if (oldEntry != null) {
            if (!testOnly) {
                this.duplicateAllocation(oldEntry);
            }
            return 259;
        }
        if (!testOnly) {
            this.indexValues.put(newEntry, newEntry);
        }
        return 0;
    }

    public synchronized int release(int sessionID, Variable indexValue, boolean testOnly) {
        IndexEntry removeKey = this.newIndexEntry(sessionID, indexValue);
        IndexEntry contained = (IndexEntry)this.indexValues.get(removeKey);
        if (contained != null && contained.getSessionID() == sessionID) {
            if (!testOnly && !this.removeEntry(contained)) {
                return 259;
            }
            return 0;
        }
        return 261;
    }

    protected boolean removeEntry(IndexEntry entryKey) {
        IndexEntry r = (IndexEntry)this.indexValues.remove(entryKey);
        if (r == null) {
            return false;
        }
        this.addUsed(r);
        return true;
    }

    protected void addUsed(IndexEntry entry) {
        this.usedValues.put(entry, entry);
    }

    public synchronized void release(int sessionID) {
        Iterator<IndexEntry> it = this.indexValues.values().iterator();
        while (it.hasNext()) {
            IndexEntry entry = it.next();
            if (entry.getSessionID() != sessionID) continue;
            it.remove();
            this.addUsed(entry);
        }
    }

    @Override
    public int compareTo(IndexRegistryEntry other) {
        int c = this.context.compareTo(other.context);
        if (c == 0) {
            c = this.indexType.getOid().compareTo(other.indexType.getOid());
        }
        return c;
    }

    public int hashCode() {
        return this.indexType.getOid().hashCode() + this.context.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof IndexRegistryEntry) {
            return this.indexType.getOid().equals(((IndexRegistryEntry)o).indexType.getOid());
        }
        return false;
    }

    public VariableBinding getIndexType() {
        return this.indexType;
    }

    public OctetString getContext() {
        return this.context;
    }

    public synchronized Variable newIndex(int sessionID, boolean testOnly) {
        try {
            IndexEntry last = null;
            if (!this.usedValues.isEmpty()) {
                last = this.usedValues.lastKey();
            }
            if (!this.indexValues.isEmpty()) {
                IndexEntry lastAllocated = this.indexValues.lastKey();
                if (last == null) {
                    last = lastAllocated;
                } else if (lastAllocated.compareTo(last) > 0) {
                    last = lastAllocated;
                }
            } else if (last == null) {
                return this.anyIndex(sessionID, testOnly);
            }
            OID nextIndex = last.getIndexValue().toSubIndex(true);
            nextIndex = nextIndex.nextPeer();
            Variable nextIndexValue = (Variable)last.getIndexValue().clone();
            nextIndexValue.fromSubIndex(nextIndex, true);
            int status = this.allocate(sessionID, nextIndexValue, testOnly);
            if (status != 0) {
                return null;
            }
            return nextIndexValue;
        }
        catch (Exception ex) {
            LOGGER.error("Exception occurred while creating/allocating new index:" + ex.getMessage(), ex);
            return null;
        }
    }

    public synchronized Variable anyIndex(int sessionID, boolean testOnly) {
        try {
            OID nextIndex;
            if (this.usedValues.isEmpty()) {
                nextIndex = this.indexValues.isEmpty() ? this.indexType.getVariable().toSubIndex(true) : this.indexValues.lastKey().getIndexValue().toSubIndex(true);
            } else {
                IndexEntry last = this.usedValues.firstKey();
                nextIndex = last.getIndexValue().toSubIndex(true);
            }
            nextIndex = nextIndex.nextPeer();
            Variable nextIndexValue = (Variable)this.indexType.getVariable().clone();
            nextIndexValue.fromSubIndex(nextIndex, true);
            int status = this.allocate(sessionID, nextIndexValue, testOnly);
            if (status != 0) {
                return null;
            }
            return nextIndexValue;
        }
        catch (Exception ex) {
            LOGGER.error("Exception occurred while creating/allocating any new index:" + ex.getMessage(), ex);
            return null;
        }
    }

    private static class IndexComparator
    implements Comparator<IndexEntry> {
        private IndexComparator() {
        }

        @Override
        public int compare(IndexEntry o1, IndexEntry o2) {
            Variable c1 = o1.getIndexValue();
            Variable c2 = o2.getIndexValue();
            return c1.compareTo(c2);
        }
    }
}

