/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.master;

import java.io.Serializable;
import java.util.TreeSet;
import java.util.function.Function;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.agentx.AgentXRegion;
import org.snmp4j.agent.agentx.master.AgentXMasterSession;
import org.snmp4j.agent.agentx.master.AgentXQueue;
import org.snmp4j.agent.agentx.master.AgentXRegEntry;
import org.snmp4j.agent.agentx.master.AgentXSearchRange;
import org.snmp4j.agent.mo.GenericManagedObject;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.request.SubRequestIterator;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;

public class AgentXNode
implements GenericManagedObject {
    private static final LogAdapter LOGGER = LogFactory.getLogger(AgentXNode.class);
    private TreeSet<AgentXRegEntry<?>> registrations = new TreeSet();
    private final AgentXRegion region;

    public AgentXNode(AgentXRegion region, AgentXRegEntry<?> registration) {
        this.region = new AgentXRegion(region);
        this.registrations.add(registration);
    }

    protected AgentXNode(AgentXRegion region, TreeSet<AgentXRegEntry<?>> registrations) {
        this.region = new AgentXRegion(region);
        this.registrations = registrations;
    }

    public AgentXNode getClone(AgentXRegion region) {
        return new AgentXNode(new AgentXRegion(region), (TreeSet)this.registrations.clone());
    }

    public int getRegistrationCount() {
        return this.registrations.size();
    }

    public synchronized boolean shrink(OID upper) {
        if (this.region.covers(upper)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Shrinking node " + this.toString() + " to " + String.valueOf(upper))));
            }
            this.region.setUpperBound(upper);
            return true;
        }
        return false;
    }

    public synchronized boolean expand(OID upper, boolean inclusive) {
        if (!this.region.covers(upper) && this.region.getUpperBound().compareTo(upper) >= 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Expanding node " + this.toString() + " to " + String.valueOf(upper) + ", inclusive=" + inclusive)));
            }
            this.region.setUpperBound(upper);
            this.region.setUpperIncluded(inclusive);
            return true;
        }
        return false;
    }

    public synchronized void addRegistration(AgentXRegEntry<?> entry) {
        this.registrations.add(entry);
    }

    public synchronized boolean removeRegistration(AgentXRegEntry<?> entry) {
        boolean removed = this.registrations.remove(entry);
        if (LOGGER.isDebugEnabled()) {
            if (removed) {
                LOGGER.debug((Serializable)((Object)("Removed registration " + String.valueOf(entry) + " from AgentX node " + this.toString())));
            } else {
                LOGGER.debug((Serializable)((Object)("Removing registration failed for " + String.valueOf(entry) + " from AgentX node " + this.toString())));
            }
        }
        return removed;
    }

    @Override
    public OID find(MOScope range) {
        OID next = OID.max(range.getLowerBound(), this.region.getLowerBound());
        if (this.region.covers(next) && this.getActiveRegistration() != null) {
            return next;
        }
        return null;
    }

    public final synchronized AgentXRegEntry<?> getActiveRegistration() {
        AgentXRegEntry<?> activeReg = null;
        while (!this.registrations.isEmpty() && activeReg == null) {
            activeReg = this.registrations.first();
            if (!activeReg.getSession().isClosed()) continue;
            this.registrations.remove(activeReg);
            LOGGER.warn((Serializable)((Object)("Removed registration from already closed session: " + String.valueOf(activeReg))));
            activeReg = null;
        }
        return activeReg;
    }

    @Override
    public void get(SubRequest<?> request) {
        this.get((SnmpRequest.SnmpSubRequest)request);
    }

    @Override
    public void get(SnmpRequest.SnmpSubRequest request) {
        AgentXRegEntry<?> activeReg = this.getActiveRegistration();
        if (activeReg == null) {
            request.getVariableBinding().setVariable(Null.noSuchObject);
            request.getStatus().setPhaseComplete(true);
            return;
        }
        AgentXQueue queue = activeReg.getSession().getQueue();
        AgentXSearchRange searchRange = new AgentXSearchRange(request.getScope().getLowerBound(), request.getScope().isLowerIncluded(), request.getScope().getUpperBound(), request.getScope().isUpperIncluded(), request);
        queue.add(searchRange, activeReg, false);
        AgentXNode.markAsProcessed(request);
    }

    @Override
    public MOScope getScope() {
        return this.region;
    }

    @Override
    public boolean next(SubRequest<?> request) {
        return this.next((SnmpRequest.SnmpSubRequest)request);
    }

    @Override
    public boolean next(SnmpRequest.SnmpSubRequest request) {
        return this.next(request, (Function<OID, Boolean>)null);
    }

    @Override
    public boolean next(SubRequest<?> request, Function<OID, Boolean> filter) {
        return this.next((SnmpRequest.SnmpSubRequest)request, filter);
    }

    @Override
    public boolean next(SnmpRequest.SnmpSubRequest request, Function<OID, Boolean> filter) {
        AgentXRegEntry<?> activeReg = this.getActiveRegistration();
        if (activeReg == null) {
            return false;
        }
        AgentXQueue queue = activeReg.getSession().getQueue();
        AgentXSearchRange searchRange = new AgentXSearchRange(request.getScope().getLowerBound(), request.getScope().isLowerIncluded(), this.region.getUpperBound(), this.region.isUpperIncluded(), request);
        OID upperRequestBound = request.getScope().getUpperBound();
        if (upperRequestBound != null && upperRequestBound.compareTo(this.region.getUpperBound()) < 0) {
            searchRange.setUpperBound(upperRequestBound);
            searchRange.setUpperIncluded(request.getScope().isUpperIncluded());
        }
        if (searchRange.isEmpty()) {
            return false;
        }
        int nonRepeaters = request.getRequest().getNonRepeaters();
        if (queue.add(searchRange, activeReg, request.getIndex() >= nonRepeaters, filter) && ((CommandResponderEvent)request.getRequest().getSource()).getPDU().getType() == -91) {
            SubRequestIterator<SnmpRequest.SnmpSubRequest> it = request.repetitions();
            while (it.hasNext()) {
                SubRequest sreq = it.next();
                sreq.getStatus().setProcessed(true);
            }
        }
        AgentXNode.markAsProcessed(request);
        return true;
    }

    @Override
    public void prepare(SubRequest<?> request) {
        this.prepare((SnmpRequest.SnmpSubRequest)request);
    }

    @Override
    public void prepare(SnmpRequest.SnmpSubRequest request) {
        this.addAgentXSet2Queue(request);
        AgentXNode.markAsProcessed(request);
    }

    @Override
    public void undo(SubRequest<?> request) {
        this.undo((SnmpRequest.SnmpSubRequest)request);
    }

    @Override
    public void undo(SnmpRequest.SnmpSubRequest request) {
        this.addAgentXSet2Queue(request);
        AgentXNode.markAsProcessed(request);
    }

    @Override
    public void cleanup(SubRequest<?> request) {
        this.cleanup((SnmpRequest.SnmpSubRequest)request);
    }

    @Override
    public void cleanup(SnmpRequest.SnmpSubRequest request) {
        this.addAgentXSet2Queue(request);
        AgentXNode.markAsProcessed(request);
    }

    @Override
    public void commit(SubRequest<?> request) {
        this.commit((SnmpRequest.SnmpSubRequest)request);
    }

    @Override
    public void commit(SnmpRequest.SnmpSubRequest request) {
        this.addAgentXSet2Queue(request);
        AgentXNode.markAsProcessed(request);
    }

    private static void markAsProcessed(SubRequest<?> request) {
        request.getStatus().setProcessed(true);
    }

    private void addAgentXSet2Queue(SnmpRequest.SnmpSubRequest request) {
        AgentXRegEntry<?> activeReg = this.getActiveRegistration();
        if (activeReg != null) {
            AgentXMasterSession<?> session = activeReg.getSession();
            if (session != null) {
                AgentXQueue queue = session.getQueue();
                if (queue != null) {
                    queue.add(request.getVariableBinding(), request, activeReg);
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Serializable)((Object)("No queue for session " + String.valueOf(session))));
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("No session for registration entry " + String.valueOf(activeReg))));
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Serializable)((Object)("No active registration left for " + String.valueOf(request))));
        }
    }

    public String toString() {
        return this.getClass().getName() + "[region=" + String.valueOf(this.region) + ",registrations=" + String.valueOf(this.registrations) + "]";
    }
}

