/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.util.Objects;
import org.snmp4j.util.DefaultThreadFactory;
import org.snmp4j.util.DefaultTimerFactory;
import org.snmp4j.util.OIDTextFormat;
import org.snmp4j.util.SimpleOIDTextFormat;
import org.snmp4j.util.SimpleVariableTextFormat;
import org.snmp4j.util.ThreadFactory;
import org.snmp4j.util.TimerFactory;
import org.snmp4j.util.VariableTextFormat;

public final class SNMP4JSettings {
    public static final int AGENTPP_ENTERPRISE_ID = 4976;
    private static int maxEngineIdCacheSize = 50000;
    private static boolean extensibilityEnabled = false;
    private static volatile boolean forwardRuntimeExceptions = false;
    private static ThreadFactory threadFactory = new DefaultThreadFactory();
    private static TimerFactory timerFactory = new DefaultTimerFactory();
    private static OIDTextFormat oidTextFormat = new SimpleOIDTextFormat();
    private static VariableTextFormat variableTextFormat = new SimpleVariableTextFormat();
    private static long threadJoinTimeout = 60000L;
    private static boolean allowSNMPv2InV1 = false;
    private static boolean noGetBulk = false;
    private static ReportSecurityLevelStrategy reportSecurityLevelStrategy = ReportSecurityLevelStrategy.standard;
    private static int enterpriseID = 4976;
    private static Snmp4jStatistics snmp4jStatistics = Snmp4jStatistics.basic;
    private static boolean checkUsmUserPassphraseLength = true;
    private static long defaultTimeoutMillis = 1000L;
    private static int defaultRetries = 0;
    private static int maxSizeRequestPDU = 65535;
    private static Character defaultNonPrintableEscapeCharacter;
    private static Boolean secretLoggingEnabled;

    public static int getMaxSizeRequestPDU() {
        return maxSizeRequestPDU;
    }

    public static void setMaxSizeRequestPDU(int maxSizeRequestPDU) {
        if (maxSizeRequestPDU < 484 || maxSizeRequestPDU > 65535) {
            throw new IllegalArgumentException();
        }
        SNMP4JSettings.maxSizeRequestPDU = maxSizeRequestPDU;
    }

    public static int getDefaultRetries() {
        return defaultRetries;
    }

    public static void setDefaultRetries(int defaultRetries) {
        if (defaultRetries < 0) {
            throw new IllegalArgumentException();
        }
        SNMP4JSettings.defaultRetries = defaultRetries;
    }

    public static void setExtensibilityEnabled(boolean enable) {
        extensibilityEnabled = enable;
    }

    public static boolean isExtensibilityEnabled() {
        return extensibilityEnabled;
    }

    public static void setForwardRuntimeExceptions(boolean forwardExceptions) {
        forwardRuntimeExceptions = forwardExceptions;
    }

    public static boolean isForwardRuntimeExceptions() {
        return forwardRuntimeExceptions;
    }

    public static ThreadFactory getThreadFactory() {
        return threadFactory;
    }

    public static void setThreadFactory(ThreadFactory newThreadFactory) {
        if (newThreadFactory == null) {
            throw new NullPointerException();
        }
        threadFactory = newThreadFactory;
    }

    public static TimerFactory getTimerFactory() {
        return timerFactory;
    }

    public static void setTimerFactory(TimerFactory newTimerFactory) {
        if (newTimerFactory == null) {
            throw new NullPointerException();
        }
        timerFactory = newTimerFactory;
    }

    public static OIDTextFormat getOIDTextFormat() {
        return oidTextFormat;
    }

    public static void setOIDTextFormat(OIDTextFormat newOidTextFormat) {
        if (newOidTextFormat == null) {
            throw new NullPointerException();
        }
        oidTextFormat = newOidTextFormat;
    }

    public static VariableTextFormat getVariableTextFormat() {
        return variableTextFormat;
    }

    public static void setVariableTextFormat(VariableTextFormat newVariableTextFormat) {
        if (newVariableTextFormat == null) {
            throw new NullPointerException();
        }
        variableTextFormat = newVariableTextFormat;
    }

    public static long getThreadJoinTimeout() {
        return threadJoinTimeout;
    }

    public static void setThreadJoinTimeout(long millis) {
        threadJoinTimeout = millis;
    }

    public static boolean isAllowSNMPv2InV1() {
        return allowSNMPv2InV1;
    }

    public static void setAllowSNMPv2InV1(boolean allowSNMPv2InV1) {
        SNMP4JSettings.allowSNMPv2InV1 = allowSNMPv2InV1;
    }

    public static ReportSecurityLevelStrategy getReportSecurityLevelStrategy() {
        return reportSecurityLevelStrategy;
    }

    public static void setReportSecurityLevelStrategy(ReportSecurityLevelStrategy reportSecurityLevelStrategy) {
        SNMP4JSettings.reportSecurityLevelStrategy = reportSecurityLevelStrategy;
    }

    public static boolean isNoGetBulk() {
        return noGetBulk;
    }

    public static void setNoGetBulk(boolean noGetBulk) {
        SNMP4JSettings.noGetBulk = noGetBulk;
    }

    public static int getEnterpriseID() {
        return enterpriseID;
    }

    public static void setEnterpriseID(int enterpriseID) {
        SNMP4JSettings.enterpriseID = enterpriseID;
    }

    public static int getMaxEngineIdCacheSize() {
        return maxEngineIdCacheSize;
    }

    public static void setMaxEngineIdCacheSize(int maxEngineIdCacheSize) {
        SNMP4JSettings.maxEngineIdCacheSize = maxEngineIdCacheSize;
    }

    public static Snmp4jStatistics getSnmp4jStatistics() {
        return snmp4jStatistics;
    }

    public static void setSnmp4jStatistics(Snmp4jStatistics snmp4jStatistics) {
        SNMP4JSettings.snmp4jStatistics = snmp4jStatistics;
    }

    public static boolean isCheckUsmUserPassphraseLength() {
        return checkUsmUserPassphraseLength;
    }

    public static void setCheckUsmUserPassphraseLength(boolean checkUsmUserPassphraseLength) {
        SNMP4JSettings.checkUsmUserPassphraseLength = checkUsmUserPassphraseLength;
    }

    public static long getDefaultTimeoutMillis() {
        return defaultTimeoutMillis;
    }

    public static void setDefaultTimeoutMillis(long defaultTimeoutMillis) {
        SNMP4JSettings.defaultTimeoutMillis = defaultTimeoutMillis;
    }

    public static Character getDefaultNonPrintableEscapeCharacter() {
        return defaultNonPrintableEscapeCharacter;
    }

    public static void setDefaultNonPrintableEscapeCharacter(Character defaultNonPrintableEscapeCharacter) {
        SNMP4JSettings.defaultNonPrintableEscapeCharacter = defaultNonPrintableEscapeCharacter;
    }

    public static Boolean isSecretLoggingEnabled() {
        return Objects.requireNonNullElse(secretLoggingEnabled, false);
    }

    public static boolean setSecretLoggingEnabled(boolean enableSecretLogging) {
        if (secretLoggingEnabled == null || !enableSecretLogging) {
            secretLoggingEnabled = enableSecretLogging;
        }
        return secretLoggingEnabled;
    }

    private SNMP4JSettings() {
    }

    public static enum ReportSecurityLevelStrategy {
        noAuthNoPrivIfNeeded,
        standard,
        neverNoAuthNoPriv;

    }

    public static enum Snmp4jStatistics {
        none,
        basic,
        extended;

    }
}

