/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.vfs;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\f"}, d2={"Ljetbrains/exodus/vfs/ClusterKey;", "", "iterable", "Ljetbrains/exodus/ByteIterable;", "(Ljetbrains/exodus/ByteIterable;)V", "clusterNumber", "", "getClusterNumber", "()J", "descriptor", "getDescriptor", "Companion", "xodus-vfs"})
public final class ClusterKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long descriptor;
    private final long clusterNumber;

    public ClusterKey(@NotNull ByteIterable iterable2) {
        Intrinsics.checkNotNullParameter(iterable2, "iterable");
        ByteIterator iterator2 = iterable2.iterator();
        this.descriptor = LongBinding.readCompressed(iterator2);
        this.clusterNumber = LongBinding.readCompressed(iterator2);
    }

    public final long getDescriptor() {
        return this.descriptor;
    }

    public final long getClusterNumber() {
        return this.clusterNumber;
    }

    @JvmStatic
    @NotNull
    public static final ArrayByteIterable toByteIterable(long fd, long clusterNumber) {
        return Companion.toByteIterable(fd, clusterNumber);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Ljetbrains/exodus/vfs/ClusterKey$Companion;", "", "()V", "toByteIterable", "Ljetbrains/exodus/ArrayByteIterable;", "fd", "", "clusterNumber", "xodus-vfs"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ArrayByteIterable toByteIterable(long fd, long clusterNumber) {
            LightOutputStream output = new LightOutputStream(8);
            int[] bytes = new int[8];
            LongBinding.writeCompressed(output, fd, bytes);
            LongBinding.writeCompressed(output, clusterNumber, bytes);
            ArrayByteIterable arrayByteIterable = output.asArrayByteIterable();
            Intrinsics.checkNotNullExpressionValue(arrayByteIterable, "output.asArrayByteIterable()");
            return arrayByteIterable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

