/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import jetbrains.exodus.util.ByteArraySpinAllocator;
import jetbrains.exodus.util.IOUtil;
import jetbrains.exodus.util.UnsafeHolder;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0007J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0007J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\fH\u0007J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\fH\u0007J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\fH\u0007J \u0010#\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010'\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\fH\u0007J\u0010\u0010(\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\fH\u0007J\u0010\u0010)\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\fH\u0007J\u001b\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010+\u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010,J#\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010+\u001a\u00020\f2\u0006\u0010-\u001a\u00020.H\u0007\u00a2\u0006\u0002\u0010/J#\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010+\u001a\u00020\f2\u0006\u0010-\u001a\u000200H\u0007\u00a2\u0006\u0002\u00101J\"\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u00192\u0006\u00104\u001a\u0002052\b\b\u0002\u00106\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Ljetbrains/exodus/util/IOUtil;", "", "()V", "BLOCK_SIZE", "", "BUFFER_ALLOCATOR", "Ljetbrains/exodus/util/ByteArraySpinAllocator;", "getBUFFER_ALLOCATOR$annotations", "getBUFFER_ALLOCATOR", "()Ljetbrains/exodus/util/ByteArraySpinAllocator;", "NO_FILES", "", "Ljava/io/File;", "[Ljava/io/File;", "READ_BUFFER_SIZE", "", "blockSize", "", "getBlockSize", "()J", "getStoreTypeMethod", "Ljava/lang/reflect/Method;", "copyStreams", "", "source", "Ljava/io/InputStream;", "target", "Ljava/io/OutputStream;", "bufferAllocator", "sourceLen", "deleteFile", "file", "deleteRecursively", "dir", "getAdjustedFileLength", "getDirectorySize", "extension", "recursive", "", "isRamDiskFile", "isRemoteFile", "isRemovableFile", "listFiles", "directory", "(Ljava/io/File;)[Ljava/io/File;", "filter", "Ljava/io/FileFilter;", "(Ljava/io/File;Ljava/io/FileFilter;)[Ljava/io/File;", "Ljava/io/FilenameFilter;", "(Ljava/io/File;Ljava/io/FilenameFilter;)[Ljava/io/File;", "readFully", "input", "bytes", "", "len", "xodus-utils"})
public final class IOUtil {
    @NotNull
    public static final IOUtil INSTANCE = new IOUtil();
    private static final int READ_BUFFER_SIZE = 16384;
    @NotNull
    private static final ByteArraySpinAllocator BUFFER_ALLOCATOR = new ByteArraySpinAllocator(16384);
    @NotNull
    private static final String BLOCK_SIZE = "exodus.io.blockSize";
    @NotNull
    private static final File[] NO_FILES = new File[0];
    @Nullable
    private static final Method getStoreTypeMethod = (Method)UnsafeHolder.INSTANCE.doPrivileged(getStoreTypeMethod.1.INSTANCE);

    private IOUtil() {
    }

    @NotNull
    public static final ByteArraySpinAllocator getBUFFER_ALLOCATOR() {
        return BUFFER_ALLOCATOR;
    }

    @JvmStatic
    public static /* synthetic */ void getBUFFER_ALLOCATOR$annotations() {
    }

    public final long getBlockSize() {
        Long l = Long.getLong(BLOCK_SIZE, 4096L);
        Intrinsics.checkNotNullExpressionValue(l, "getLong(BLOCK_SIZE, 0x1000)");
        return ((Number)l).longValue();
    }

    @JvmStatic
    public static final boolean isRemovableFile(@NotNull File file) {
        boolean bl;
        Intrinsics.checkNotNullParameter(file, "file");
        try {
            bl = Intrinsics.areEqual(Files.getFileStore(file.toPath()).getAttribute("volume:isRemovable"), true);
        }
        catch (Throwable _) {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isRemoteFile(@NotNull File file) {
        boolean bl;
        Intrinsics.checkNotNullParameter(file, "file");
        try {
            boolean bl2;
            Method method = getStoreTypeMethod;
            if (method == null) {
                bl2 = false;
            } else {
                boolean bl3;
                Method $this$isRemoteFile_u24lambda_u2d0 = method;
                boolean bl4 = false;
                bl2 = bl3 = Intrinsics.areEqual($this$isRemoteFile_u24lambda_u2d0.invoke((Object)Files.getFileStore(file.toPath()), new Object[0]), (Object)4);
            }
            bl = bl2;
        }
        catch (Throwable _) {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isRamDiskFile(@NotNull File file) {
        boolean bl;
        Intrinsics.checkNotNullParameter(file, "file");
        try {
            boolean bl2;
            Method method = getStoreTypeMethod;
            if (method == null) {
                bl2 = false;
            } else {
                boolean bl3;
                Method $this$isRamDiskFile_u24lambda_u2d1 = method;
                boolean bl4 = false;
                bl2 = bl3 = Intrinsics.areEqual($this$isRamDiskFile_u24lambda_u2d1.invoke((Object)Files.getFileStore(file.toPath()), new Object[0]), (Object)6);
            }
            bl = bl2;
        }
        catch (Throwable _) {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final long getAdjustedFileLength(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        long blockSize = INSTANCE.getBlockSize();
        boolean bl = false;
        return (file.length() + blockSize - 1L) / blockSize * blockSize;
    }

    @JvmStatic
    public static final long getDirectorySize(@NotNull File dir, @NotNull String extension, boolean recursive) {
        int n;
        int n2;
        File[] fileArray;
        Intrinsics.checkNotNullParameter(dir, "dir");
        Intrinsics.checkNotNullParameter(extension, "extension");
        long sum = 0L;
        if (recursive) {
            fileArray = IOUtil.listFiles(dir, IOUtil::getDirectorySize$lambda-3);
            n2 = 0;
            n = fileArray.length;
            while (n2 < n) {
                File childDir = fileArray[n2];
                ++n2;
                sum += IOUtil.getDirectorySize(childDir, extension, recursive);
            }
        }
        fileArray = IOUtil.listFiles(dir, (arg_0, arg_1) -> IOUtil.getDirectorySize$lambda-4(extension, arg_0, arg_1));
        n2 = 0;
        n = fileArray.length;
        while (n2 < n) {
            File file = fileArray[n2];
            ++n2;
            sum += IOUtil.getAdjustedFileLength(file);
        }
        return sum;
    }

    @JvmStatic
    public static final void copyStreams(@NotNull InputStream source, @NotNull OutputStream target, @NotNull ByteArraySpinAllocator bufferAllocator) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(bufferAllocator, "bufferAllocator");
        IOUtil.copyStreams(source, Long.MAX_VALUE, target, bufferAllocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void copyStreams(@NotNull InputStream source, long sourceLen, @NotNull OutputStream target, @NotNull ByteArraySpinAllocator bufferAllocator) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(bufferAllocator, "bufferAllocator");
        byte[] buffer = (byte[])bufferAllocator.alloc();
        try {
            long totalRead = 0L;
            while (totalRead < sourceLen) {
                int read2 = source.read(buffer);
                if (read2 < 0) {
                    break;
                }
                if (read2 <= 0) continue;
                target.write(buffer, 0, (int)Math.min(sourceLen - totalRead, (long)read2));
                totalRead += (long)read2;
            }
        }
        finally {
            bufferAllocator.dispose(buffer);
        }
    }

    @JvmStatic
    public static final void deleteRecursively(@NotNull File dir) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        File[] fileArray = IOUtil.listFiles(dir);
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File file = fileArray[n];
            ++n;
            if (file.isDirectory()) {
                IOUtil.deleteRecursively(file);
            }
            IOUtil.deleteFile(file);
        }
    }

    @JvmStatic
    public static final void deleteFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    @JvmStatic
    @NotNull
    public static final File[] listFiles(@NotNull File directory) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        File[] fileArray = directory.listFiles();
        if (fileArray == null) {
            fileArray = NO_FILES;
        }
        return fileArray;
    }

    @JvmStatic
    @NotNull
    public static final File[] listFiles(@NotNull File directory, @NotNull FilenameFilter filter) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(filter, "filter");
        File[] fileArray = directory.listFiles(filter);
        if (fileArray == null) {
            fileArray = NO_FILES;
        }
        return fileArray;
    }

    @JvmStatic
    @NotNull
    public static final File[] listFiles(@NotNull File directory, @NotNull FileFilter filter) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(filter, "filter");
        File[] fileArray = directory.listFiles(filter);
        if (fileArray == null) {
            fileArray = NO_FILES;
        }
        return fileArray;
    }

    @JvmStatic
    @JvmOverloads
    public static final int readFully(@NotNull InputStream input, @NotNull byte[] bytes, int len) {
        int off;
        int read2;
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        for (off = 0; off < len && (read2 = input.read(bytes, off, len - off)) >= 0; off += read2) {
        }
        return off;
    }

    public static /* synthetic */ int readFully$default(InputStream inputStream, byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = byArray.length;
        }
        return IOUtil.readFully(inputStream, byArray, n);
    }

    @JvmStatic
    @JvmOverloads
    public static final int readFully(@NotNull InputStream input, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        return IOUtil.readFully$default(input, bytes, 0, 4, null);
    }

    private static final boolean getDirectorySize$lambda-3(File obj) {
        return obj.isDirectory();
    }

    private static final boolean getDirectorySize$lambda-4(String $extension, File $noName_0, String name) {
        Intrinsics.checkNotNullParameter($extension, "$extension");
        Intrinsics.checkNotNullExpressionValue(name, "name");
        return StringsKt.endsWith$default(name, $extension, false, 2, null);
    }
}

