/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.util;

import java.io.ByteArrayInputStream;

public class ByteArraySizedInputStream
extends ByteArrayInputStream {
    public ByteArraySizedInputStream(byte[] buf) {
        super(buf);
    }

    public ByteArraySizedInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
    }

    public int size() {
        return this.count - this.mark;
    }

    public int count() {
        return this.count;
    }

    public int pos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public byte[] toByteArray() {
        return this.buf;
    }

    public ByteArraySizedInputStream copy() {
        return new ByteArraySizedInputStream(this.buf, this.pos, this.count);
    }

    public int hashCode() {
        int result = this.size() + 1;
        int mark = this.mark;
        int count = this.count;
        byte[] buf = this.buf;
        for (int i = mark; i < count; ++i) {
            result = result * 31 + buf[i];
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ByteArraySizedInputStream)) {
            return false;
        }
        ByteArraySizedInputStream right = (ByteArraySizedInputStream)obj;
        int size = this.size();
        if (size != right.size()) {
            return false;
        }
        int mark = this.mark;
        byte[] buf = this.buf;
        int rMark = right.mark;
        byte[] rBuf = this.buf;
        for (int i = 0; i < size; ++i) {
            if (buf[i + mark] == rBuf[i + rMark]) continue;
            return false;
        }
        return true;
    }
}

