/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import java.util.BitSet;
import java.util.Iterator;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.kotlin.KodusKt;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.NullLoggable;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.patricia.ChildReference;
import jetbrains.exodus.tree.patricia.ImmutableNodeKt;
import jetbrains.exodus.tree.patricia.MutableNode;
import jetbrains.exodus.tree.patricia.NodeBase;
import jetbrains.exodus.tree.patricia.NodeChildren;
import jetbrains.exodus.tree.patricia.NodeChildrenIterator;
import jetbrains.exodus.tree.patricia.PatriciaTreeBase;
import jetbrains.exodus.tree.patricia.PatriciaTreeMutable;
import jetbrains.exodus.tree.patricia.SearchResult;
import jetbrains.exodus.tree.patricia.V2ChildrenFormat;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0005=>?@AB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B'\b\u0012\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0007\b\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0013H\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J \u0010$\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u001eH\u0002J\u0018\u0010'\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u001eH\u0002J\u0018\u0010(\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u001eH\u0002J\u0018\u0010)\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u001eH\u0002J\b\u0010*\u001a\u00020\u000eH\u0016J\u001a\u0010+\u001a\u0004\u0018\u00010\u00012\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\bH\u0016J\b\u0010/\u001a\u000200H\u0016J\u0010\u0010/\u001a\u0002012\u0006\u0010.\u001a\u00020\bH\u0016J\b\u00102\u001a\u00020\u0013H\u0016J\b\u00103\u001a\u000201H\u0016J\u0010\u00104\u001a\u0002012\u0006\u0010.\u001a\u00020\bH\u0016J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010.\u001a\u00020\bH\u0002J\b\u0010;\u001a\u00020\u0017H\u0016J\u0010\u0010<\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006B"}, d2={"Ljetbrains/exodus/tree/patricia/ImmutableNode;", "Ljetbrains/exodus/tree/patricia/NodeBase;", "loggable", "Ljetbrains/exodus/log/RandomAccessLoggable;", "data", "Ljetbrains/exodus/log/ByteIterableWithAddress;", "(Ljetbrains/exodus/log/RandomAccessLoggable;Ljetbrains/exodus/log/ByteIterableWithAddress;)V", "type", "", "it", "Ljetbrains/exodus/log/ByteIteratorWithAddress;", "(BLjetbrains/exodus/log/RandomAccessLoggable;Ljetbrains/exodus/log/ByteIterableWithAddress;Ljetbrains/exodus/log/ByteIteratorWithAddress;)V", "()V", "baseAddress", "", "childAddressLength", "childrenCount", "", "dataOffset", "", "getLoggable", "()Ljetbrains/exodus/log/RandomAccessLoggable;", "v2Format", "", "getV2Format", "()Z", "addressByOffsetV2", "offset", "byteAt", "childReferenceBitsetV2", "Ljetbrains/exodus/tree/patricia/ChildReference;", "index", "bit", "childReferenceCompleteV2", "childReferenceSparseV2", "childReferenceV1", "fillChildReferenceBitsetV2", "", "node", "fillChildReferenceCompleteV2", "fillChildReferenceSparseV2", "fillChildReferenceV1", "getAddress", "getChild", "tree", "Ljetbrains/exodus/tree/patricia/PatriciaTreeBase;", "b", "getChildren", "Ljetbrains/exodus/tree/patricia/NodeChildren;", "Ljetbrains/exodus/tree/patricia/NodeChildrenIterator;", "getChildrenCount", "getChildrenLast", "getChildrenRange", "getMutableCopy", "Ljetbrains/exodus/tree/patricia/MutableNode;", "mutableTree", "Ljetbrains/exodus/tree/patricia/PatriciaTreeMutable;", "getV2Child", "Ljetbrains/exodus/tree/patricia/SearchResult;", "isMutable", "nextLong", "ImmutableNodeBitsetChildrenV2Iterator", "ImmutableNodeChildrenIterator", "ImmutableNodeCompleteChildrenV2Iterator", "ImmutableNodeSparseChildrenV2Iterator", "NodeChildrenIteratorBase", "xodus-environment"})
public final class ImmutableNode
extends NodeBase {
    @NotNull
    private final RandomAccessLoggable loggable;
    @NotNull
    private final ByteIterableWithAddress data;
    private final int dataOffset;
    private final short childrenCount;
    private final byte childAddressLength;
    private final long baseAddress;

    @NotNull
    public final RandomAccessLoggable getLoggable() {
        return this.loggable;
    }

    public ImmutableNode(@NotNull RandomAccessLoggable loggable, @NotNull ByteIterableWithAddress data) {
        Intrinsics.checkNotNullParameter(loggable, "loggable");
        Intrinsics.checkNotNullParameter(data, "data");
        byte by = loggable.getType();
        ByteIteratorWithAddress byteIteratorWithAddress = data.iterator();
        Intrinsics.checkNotNullExpressionValue(byteIteratorWithAddress, "data.iterator()");
        this(by, loggable, data, byteIteratorWithAddress);
    }

    private ImmutableNode(byte type, RandomAccessLoggable loggable, ByteIterableWithAddress data, ByteIteratorWithAddress it) {
        super(type, data, it);
        this.loggable = loggable;
        this.data = data;
        long baseAddress = -1L;
        if (PatriciaTreeBase.nodeHasChildren(type)) {
            int n;
            int i = CompressedUnsignedLongByteIterable.getInt(it);
            int childrenCount = i >>> 3;
            if (childrenCount < 257) {
                this.childrenCount = (short)childrenCount;
            } else {
                this.childrenCount = (short)(childrenCount - 257);
                baseAddress = CompressedUnsignedLongByteIterable.getLong(it);
            }
            int len = n = (i & 7) + 1;
            boolean bl = false;
            this.childAddressLength = (byte)len;
            ImmutableNodeKt.access$checkAddressLength(n);
        } else {
            this.childrenCount = 0;
            this.childAddressLength = 0;
        }
        this.baseAddress = baseAddress;
        this.dataOffset = (int)(it.getAddress() - data.getDataAddress());
    }

    public ImmutableNode() {
        super(ByteIterable.EMPTY, null);
        Object object = NullLoggable.create();
        Intrinsics.checkNotNullExpressionValue(object, "create()");
        this.loggable = (RandomAccessLoggable)object;
        object = ByteIterableWithAddress.EMPTY;
        Intrinsics.checkNotNullExpressionValue(object, "EMPTY");
        this.data = object;
        this.dataOffset = 0;
        this.childrenCount = 0;
        this.childAddressLength = 0;
        this.baseAddress = -1L;
    }

    @Override
    public long getAddress() {
        return this.loggable.getAddress();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    @NotNull
    public MutableNode getMutableCopy(@NotNull PatriciaTreeMutable mutableTree) {
        Intrinsics.checkNotNullParameter(mutableTree, "mutableTree");
        return mutableTree.mutateNode(this);
    }

    @Override
    @Nullable
    public NodeBase getChild(@NotNull PatriciaTreeBase tree, byte b2) {
        Intrinsics.checkNotNullParameter(tree, "tree");
        if (this.getV2Format()) {
            SearchResult searchResult = this.getV2Child(b2);
            if (searchResult != null) {
                SearchResult searchResult2 = searchResult;
                boolean bl = false;
                return tree.loadNode(this.addressByOffsetV2(searchResult2.getOffset()));
            }
        } else {
            int key = ImmutableNodeKt.getUnsigned(b2);
            int low = 0;
            int high = this.childrenCount - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int offset = mid * (this.childAddressLength + 1);
                int cmp = ImmutableNodeKt.getUnsigned(this.byteAt(offset)) - key;
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return tree.loadNode(this.nextLong(offset + 1));
            }
        }
        return null;
    }

    @Override
    @NotNull
    public NodeChildren getChildren() {
        return new NodeChildren(this){
            final /* synthetic */ ImmutableNode this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public NodeChildrenIterator iterator() {
                NodeChildrenIterator nodeChildrenIterator;
                block1: {
                    int n;
                    int childrenCount;
                    block0: {
                        childrenCount = this.this$0.getChildrenCount();
                        if (childrenCount != 0) break block0;
                        nodeChildrenIterator = this.this$0.new NodeBase.EmptyNodeChildrenIterator();
                        break block1;
                    }
                    nodeChildrenIterator = ImmutableNode.access$getV2Format(this.this$0) ? ((n = childrenCount) == 256 ? (NodeChildrenIteratorBase)this.this$0.new ImmutableNodeCompleteChildrenV2Iterator(-1, null) : ((1 <= n ? n < 33 : false) ? (NodeChildrenIteratorBase)this.this$0.new ImmutableNodeSparseChildrenV2Iterator(-1, null) : (NodeChildrenIteratorBase)this.this$0.new ImmutableNodeBitsetChildrenV2Iterator(-1, null))) : (NodeChildrenIteratorBase)this.this$0.new ImmutableNodeChildrenIterator(-1, null);
                }
                return nodeChildrenIterator;
            }
        };
    }

    @Override
    @NotNull
    public NodeChildrenIterator getChildren(byte b2) {
        if (this.getV2Format()) {
            SearchResult searchResult = this.getV2Child(b2);
            if (searchResult != null) {
                NodeChildrenIterator nodeChildrenIterator;
                SearchResult searchResult2 = searchResult;
                boolean bl = false;
                int index2 = searchResult2.getIndex();
                ChildReference node = new ChildReference(b2, this.addressByOffsetV2(searchResult2.getOffset()));
                switch (WhenMappings.$EnumSwitchMapping$0[searchResult2.getChildrenFormat().ordinal()]) {
                    case 1: {
                        nodeChildrenIterator = new ImmutableNodeCompleteChildrenV2Iterator(index2, node);
                        break;
                    }
                    case 2: {
                        nodeChildrenIterator = new ImmutableNodeSparseChildrenV2Iterator(index2, node);
                        break;
                    }
                    case 3: {
                        nodeChildrenIterator = new ImmutableNodeBitsetChildrenV2Iterator(index2, node);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return nodeChildrenIterator;
            }
        } else {
            int key = ImmutableNodeKt.getUnsigned(b2);
            int low = 0;
            int high = this.childrenCount - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int offset = mid * (this.childAddressLength + 1);
                int cmp = ImmutableNodeKt.getUnsigned(this.byteAt(offset)) - key;
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                long suffixAddress = this.nextLong(offset + 1);
                return new ImmutableNodeChildrenIterator(mid, new ChildReference(b2, suffixAddress));
            }
        }
        return new NodeBase.EmptyNodeChildrenIterator();
    }

    @Override
    @NotNull
    public NodeChildrenIterator getChildrenRange(byte b2) {
        int ub = ImmutableNodeKt.getUnsigned(b2);
        if (this.getV2Format()) {
            int childrenCount = this.getChildrenCount();
            if (childrenCount == 0) {
                return new NodeBase.EmptyNodeChildrenIterator();
            }
            if (childrenCount == 256) {
                return new ImmutableNodeCompleteChildrenV2Iterator(ub, new ChildReference(b2, this.addressByOffsetV2(ub * this.childAddressLength)));
            }
            boolean bl = 1 <= childrenCount ? childrenCount < 33 : false;
            if (bl) {
                int n = 0;
                while (n < childrenCount) {
                    int i;
                    byte nextByte;
                    int next;
                    if (ub > (next = ImmutableNodeKt.getUnsigned(nextByte = this.byteAt(i = n++)))) continue;
                    return new ImmutableNodeSparseChildrenV2Iterator(i, new ChildReference(nextByte, this.addressByOffsetV2(childrenCount + i * this.childAddressLength)));
                }
            } else {
                int bitsetIdx = ub / 64;
                long bitset = this.data.nextLong(this.dataOffset + bitsetIdx * 8, 8);
                int bit = ub % 64;
                long bitmask = 1L << bit;
                int index2 = Long.bitCount(bitset & bitmask - 1L);
                int n = 0;
                while (n < bitsetIdx) {
                    int i = n++;
                    index2 += Long.bitCount(this.data.nextLong(this.dataOffset + i * 8, 8));
                }
                int offset = 32 + index2 * this.childAddressLength;
                if ((bitset & bitmask) != 0L) {
                    return new ImmutableNodeBitsetChildrenV2Iterator(index2, new ChildReference(b2, this.addressByOffsetV2(offset)));
                }
                if (index2 < childrenCount) {
                    ImmutableNodeBitsetChildrenV2Iterator immutableNodeBitsetChildrenV2Iterator;
                    ImmutableNodeBitsetChildrenV2Iterator $this$getChildrenRange_u24lambda_u2d3 = immutableNodeBitsetChildrenV2Iterator = new ImmutableNodeBitsetChildrenV2Iterator(index2 - 1, new ChildReference(b2, this.addressByOffsetV2(offset)));
                    boolean bl2 = false;
                    $this$getChildrenRange_u24lambda_u2d3.next();
                    return immutableNodeBitsetChildrenV2Iterator;
                }
            }
        } else {
            int low = -1;
            int high = this.getChildrenCount();
            int offset = -1;
            byte resultByte = 0;
            while (high - low > 1) {
                int mid = low + high + 1 >>> 1;
                int off = mid * (this.childAddressLength + 1);
                byte actual = this.byteAt(off);
                if (ImmutableNodeKt.getUnsigned(actual) >= ub) {
                    offset = off;
                    resultByte = actual;
                    high = mid;
                    continue;
                }
                low = mid;
            }
            if (offset >= 0) {
                long suffixAddress = this.nextLong(offset + 1);
                return new ImmutableNodeChildrenIterator(high, new ChildReference(resultByte, suffixAddress));
            }
        }
        return new NodeBase.EmptyNodeChildrenIterator();
    }

    @Override
    public int getChildrenCount() {
        return this.childrenCount;
    }

    @Override
    @NotNull
    public NodeChildrenIterator getChildrenLast() {
        NodeChildrenIterator nodeChildrenIterator;
        block1: {
            int n;
            int childrenCount;
            block0: {
                childrenCount = this.getChildrenCount();
                if (childrenCount != 0) break block0;
                nodeChildrenIterator = new NodeBase.EmptyNodeChildrenIterator();
                break block1;
            }
            nodeChildrenIterator = this.getV2Format() ? ((n = childrenCount) == 256 ? (NodeChildrenIteratorBase)new ImmutableNodeCompleteChildrenV2Iterator(childrenCount, null) : ((1 <= n ? n < 33 : false) ? (NodeChildrenIteratorBase)new ImmutableNodeSparseChildrenV2Iterator(childrenCount, null) : (NodeChildrenIteratorBase)new ImmutableNodeBitsetChildrenV2Iterator(childrenCount, null))) : (NodeChildrenIteratorBase)new ImmutableNodeChildrenIterator(childrenCount, null);
        }
        return nodeChildrenIterator;
    }

    private final boolean getV2Format() {
        return this.baseAddress != -1L;
    }

    private final SearchResult getV2Child(byte b2) {
        int ub = ImmutableNodeKt.getUnsigned(b2);
        int childrenCount = this.getChildrenCount();
        if (childrenCount == 0) {
            return null;
        }
        if (childrenCount == 256) {
            return new SearchResult(ub, ub * this.childAddressLength, V2ChildrenFormat.Complete);
        }
        boolean bl = 1 <= childrenCount ? childrenCount < 33 : false;
        if (bl) {
            int i;
            int next;
            int n = 0;
            while (n < childrenCount && ub >= (next = ImmutableNodeKt.getUnsigned(this.byteAt(i = n++)))) {
                if (ub != next) continue;
                return new SearchResult(i, childrenCount + i * this.childAddressLength, V2ChildrenFormat.Sparse);
            }
        } else {
            int bit;
            long bitmask;
            int bitsetIdx = ub / 64;
            long bitset = this.data.nextLong(this.dataOffset + bitsetIdx * 8, 8);
            if ((bitset & (bitmask = 1L << (bit = ub % 64))) == 0L) {
                return null;
            }
            int index2 = Long.bitCount(bitset & bitmask - 1L);
            int n = 0;
            while (n < bitsetIdx) {
                int i = n++;
                index2 += Long.bitCount(this.data.nextLong(this.dataOffset + i * 8, 8));
            }
            return new SearchResult(index2, 32 + index2 * this.childAddressLength, V2ChildrenFormat.Bitset);
        }
        return null;
    }

    private final byte byteAt(int offset) {
        return this.data.byteAt(this.dataOffset + offset);
    }

    private final long nextLong(int offset) {
        return this.data.nextLong(this.dataOffset + offset, this.childAddressLength);
    }

    private final long addressByOffsetV2(int offset) {
        return this.nextLong(offset) + this.baseAddress;
    }

    private final ChildReference childReferenceV1(int index2) {
        int offset = index2 * (this.childAddressLength + 1);
        boolean bl = false;
        return new ChildReference(this.byteAt(offset), this.nextLong(offset + 1));
    }

    private final ChildReference childReferenceCompleteV2(int index2) {
        return new ChildReference((byte)index2, this.addressByOffsetV2(index2 * this.childAddressLength));
    }

    private final ChildReference childReferenceSparseV2(int index2) {
        return new ChildReference(this.byteAt(index2), this.addressByOffsetV2(this.getChildrenCount() + index2 * this.childAddressLength));
    }

    private final ChildReference childReferenceBitsetV2(int index2, int bit) {
        return new ChildReference((byte)bit, this.addressByOffsetV2(32 + index2 * this.childAddressLength));
    }

    private final void fillChildReferenceV1(int index2, ChildReference node) {
        int offset = index2 * (this.childAddressLength + 1);
        boolean bl = false;
        node.firstByte = this.byteAt(offset);
        node.suffixAddress = this.nextLong(offset + 1);
    }

    private final void fillChildReferenceCompleteV2(int index2, ChildReference node) {
        node.firstByte = (byte)index2;
        node.suffixAddress = this.addressByOffsetV2(index2 * this.childAddressLength);
    }

    private final void fillChildReferenceSparseV2(int index2, ChildReference node) {
        node.firstByte = this.byteAt(index2);
        node.suffixAddress = this.addressByOffsetV2(this.getChildrenCount() + index2 * this.childAddressLength);
    }

    private final void fillChildReferenceBitsetV2(int index2, int bit, ChildReference node) {
        node.firstByte = (byte)bit;
        node.suffixAddress = this.addressByOffsetV2(32 + index2 * this.childAddressLength);
    }

    public static final /* synthetic */ boolean access$getV2Format(ImmutableNode $this) {
        return $this.getV2Format();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u001a\u001a\u00020\fH\u0096\u0002J\b\u0010\u001b\u001a\u00020\fH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Ljetbrains/exodus/tree/patricia/ImmutableNode$NodeChildrenIteratorBase;", "Ljetbrains/exodus/tree/patricia/NodeChildrenIterator;", "index", "", "node", "Ljetbrains/exodus/tree/patricia/ChildReference;", "(Ljetbrains/exodus/tree/patricia/ImmutableNode;ILjetbrains/exodus/tree/patricia/ChildReference;)V", "getIndex", "()I", "setIndex", "(I)V", "isMutable", "", "()Z", "key", "Ljetbrains/exodus/ByteIterable;", "getKey", "()Ljetbrains/exodus/ByteIterable;", "getNode", "()Ljetbrains/exodus/tree/patricia/ChildReference;", "setNode", "(Ljetbrains/exodus/tree/patricia/ChildReference;)V", "parentNode", "Ljetbrains/exodus/tree/patricia/NodeBase;", "getParentNode", "()Ljetbrains/exodus/tree/patricia/NodeBase;", "hasNext", "hasPrev", "remove", "", "xodus-environment"})
    private abstract class NodeChildrenIteratorBase
    implements NodeChildrenIterator {
        private int index;
        @Nullable
        private ChildReference node;

        public NodeChildrenIteratorBase(@Nullable int index2, ChildReference node) {
            Intrinsics.checkNotNullParameter(ImmutableNode.this, "this$0");
            this.index = index2;
            this.node = node;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        public void setIndex(int n) {
            this.index = n;
        }

        @Override
        @Nullable
        public ChildReference getNode() {
            return this.node;
        }

        public void setNode(@Nullable ChildReference childReference) {
            this.node = childReference;
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.getIndex() < ImmutableNode.this.childrenCount - 1;
        }

        @Override
        public boolean hasPrev() {
            return this.getIndex() > 0;
        }

        @NotNull
        public Void remove() {
            throw new ExodusException("Can't remove manually Patricia node child, use Store.delete() instead");
        }

        @Override
        @NotNull
        public NodeBase getParentNode() {
            return ImmutableNode.this;
        }

        @Override
        @NotNull
        public ByteIterable getKey() {
            ByteIterable byteIterable = ImmutableNode.this.keySequence;
            Intrinsics.checkNotNullExpressionValue(byteIterable, "keySequence");
            return byteIterable;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\b\u001a\u00020\u0006H\u0096\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Ljetbrains/exodus/tree/patricia/ImmutableNode$ImmutableNodeChildrenIterator;", "Ljetbrains/exodus/tree/patricia/ImmutableNode$NodeChildrenIteratorBase;", "Ljetbrains/exodus/tree/patricia/ImmutableNode;", "index", "", "node", "Ljetbrains/exodus/tree/patricia/ChildReference;", "(Ljetbrains/exodus/tree/patricia/ImmutableNode;ILjetbrains/exodus/tree/patricia/ChildReference;)V", "next", "nextInPlace", "", "prev", "prevInPlace", "xodus-environment"})
    private final class ImmutableNodeChildrenIterator
    extends NodeChildrenIteratorBase {
        public ImmutableNodeChildrenIterator(@Nullable int index2, ChildReference node) {
            Intrinsics.checkNotNullParameter(ImmutableNode.this, "this$0");
            super(index2, node);
        }

        @Override
        @NotNull
        public ChildReference next() {
            ChildReference childReference;
            this.setIndex(this.getIndex() + 1);
            ChildReference it = childReference = ImmutableNode.this.childReferenceV1(this.getIndex());
            boolean bl = false;
            this.setNode(it);
            return childReference;
        }

        @Override
        @NotNull
        public ChildReference prev() {
            ChildReference childReference;
            this.setIndex(this.getIndex() + -1);
            ChildReference it = childReference = ImmutableNode.this.childReferenceV1(this.getIndex());
            boolean bl = false;
            this.setNode(it);
            return childReference;
        }

        @Override
        public void nextInPlace() {
            this.setIndex(this.getIndex() + 1);
            ImmutableNode.this.fillChildReferenceV1(this.getIndex(), KodusKt.getNotNull(this.getNode()));
        }

        @Override
        public void prevInPlace() {
            this.setIndex(this.getIndex() + -1);
            ImmutableNode.this.fillChildReferenceV1(this.getIndex(), KodusKt.getNotNull(this.getNode()));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\b\u001a\u00020\u0006H\u0096\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Ljetbrains/exodus/tree/patricia/ImmutableNode$ImmutableNodeCompleteChildrenV2Iterator;", "Ljetbrains/exodus/tree/patricia/ImmutableNode$NodeChildrenIteratorBase;", "Ljetbrains/exodus/tree/patricia/ImmutableNode;", "index", "", "node", "Ljetbrains/exodus/tree/patricia/ChildReference;", "(Ljetbrains/exodus/tree/patricia/ImmutableNode;ILjetbrains/exodus/tree/patricia/ChildReference;)V", "next", "nextInPlace", "", "prev", "prevInPlace", "xodus-environment"})
    private final class ImmutableNodeCompleteChildrenV2Iterator
    extends NodeChildrenIteratorBase {
        public ImmutableNodeCompleteChildrenV2Iterator(@Nullable int index2, ChildReference node) {
            Intrinsics.checkNotNullParameter(ImmutableNode.this, "this$0");
            super(index2, node);
        }

        @Override
        @NotNull
        public ChildReference next() {
            ChildReference childReference;
            this.setIndex(this.getIndex() + 1);
            ChildReference it = childReference = ImmutableNode.this.childReferenceCompleteV2(this.getIndex());
            boolean bl = false;
            this.setNode(it);
            return childReference;
        }

        @Override
        @NotNull
        public ChildReference prev() {
            ChildReference childReference;
            this.setIndex(this.getIndex() + -1);
            ChildReference it = childReference = ImmutableNode.this.childReferenceCompleteV2(this.getIndex());
            boolean bl = false;
            this.setNode(it);
            return childReference;
        }

        @Override
        public void nextInPlace() {
            this.setIndex(this.getIndex() + 1);
            ImmutableNode.this.fillChildReferenceCompleteV2(this.getIndex(), KodusKt.getNotNull(this.getNode()));
        }

        @Override
        public void prevInPlace() {
            this.setIndex(this.getIndex() + -1);
            ImmutableNode.this.fillChildReferenceCompleteV2(this.getIndex(), KodusKt.getNotNull(this.getNode()));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\b\u001a\u00020\u0006H\u0096\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Ljetbrains/exodus/tree/patricia/ImmutableNode$ImmutableNodeSparseChildrenV2Iterator;", "Ljetbrains/exodus/tree/patricia/ImmutableNode$NodeChildrenIteratorBase;", "Ljetbrains/exodus/tree/patricia/ImmutableNode;", "index", "", "node", "Ljetbrains/exodus/tree/patricia/ChildReference;", "(Ljetbrains/exodus/tree/patricia/ImmutableNode;ILjetbrains/exodus/tree/patricia/ChildReference;)V", "next", "nextInPlace", "", "prev", "prevInPlace", "xodus-environment"})
    private final class ImmutableNodeSparseChildrenV2Iterator
    extends NodeChildrenIteratorBase {
        public ImmutableNodeSparseChildrenV2Iterator(@Nullable int index2, ChildReference node) {
            Intrinsics.checkNotNullParameter(ImmutableNode.this, "this$0");
            super(index2, node);
        }

        @Override
        @NotNull
        public ChildReference next() {
            ChildReference childReference;
            this.setIndex(this.getIndex() + 1);
            ChildReference it = childReference = ImmutableNode.this.childReferenceSparseV2(this.getIndex());
            boolean bl = false;
            this.setNode(it);
            return childReference;
        }

        @Override
        @NotNull
        public ChildReference prev() {
            ChildReference childReference;
            this.setIndex(this.getIndex() + -1);
            ChildReference it = childReference = ImmutableNode.this.childReferenceSparseV2(this.getIndex());
            boolean bl = false;
            this.setNode(it);
            return childReference;
        }

        @Override
        public void nextInPlace() {
            this.setIndex(this.getIndex() + 1);
            ImmutableNode.this.fillChildReferenceSparseV2(this.getIndex(), KodusKt.getNotNull(this.getNode()));
        }

        @Override
        public void prevInPlace() {
            this.setIndex(this.getIndex() + -1);
            ImmutableNode.this.fillChildReferenceSparseV2(this.getIndex(), KodusKt.getNotNull(this.getNode()));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\t\u0010\u000f\u001a\u00020\u0006H\u0096\u0002J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/exodus/tree/patricia/ImmutableNode$ImmutableNodeBitsetChildrenV2Iterator;", "Ljetbrains/exodus/tree/patricia/ImmutableNode$NodeChildrenIteratorBase;", "Ljetbrains/exodus/tree/patricia/ImmutableNode;", "index", "", "node", "Ljetbrains/exodus/tree/patricia/ChildReference;", "(Ljetbrains/exodus/tree/patricia/ImmutableNode;ILjetbrains/exodus/tree/patricia/ChildReference;)V", "bit", "bitset", "Ljava/util/BitSet;", "kotlin.jvm.PlatformType", "decIndex", "", "incIndex", "next", "nextInPlace", "prev", "prevInPlace", "xodus-environment"})
    private final class ImmutableNodeBitsetChildrenV2Iterator
    extends NodeChildrenIteratorBase {
        private final BitSet bitset;
        private int bit;

        /*
         * WARNING - void declaration
         */
        public ImmutableNodeBitsetChildrenV2Iterator(@Nullable int index2, ChildReference node) {
            void array;
            Intrinsics.checkNotNullParameter(ImmutableNode.this, "this$0");
            super(index2, node);
            long[] lArray = new long[4];
            ImmutableNode immutableNode = ImmutableNode.this;
            long[] lArray2 = lArray;
            ImmutableNodeBitsetChildrenV2Iterator immutableNodeBitsetChildrenV2Iterator = this;
            boolean bl = false;
            Iterable $this$forEach$iv = ArraysKt.getIndices((long[])array);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                int element$iv;
                int i = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                array[i] = immutableNode.data.nextLong(immutableNode.dataOffset + i * 8, 8);
            }
            immutableNodeBitsetChildrenV2Iterator.bitset = BitSet.valueOf((long[])array);
            this.bit = -1;
        }

        @Override
        @NotNull
        public ChildReference next() {
            ChildReference childReference;
            this.incIndex();
            ChildReference it = childReference = ImmutableNode.this.childReferenceBitsetV2(this.getIndex(), this.bit);
            boolean bl = false;
            this.setNode(it);
            return childReference;
        }

        @Override
        @NotNull
        public ChildReference prev() {
            ChildReference childReference;
            this.decIndex();
            ChildReference it = childReference = ImmutableNode.this.childReferenceBitsetV2(this.getIndex(), this.bit);
            boolean bl = false;
            this.setNode(it);
            return childReference;
        }

        @Override
        public void nextInPlace() {
            this.incIndex();
            ImmutableNode.this.fillChildReferenceBitsetV2(this.getIndex(), this.bit, KodusKt.getNotNull(this.getNode()));
        }

        @Override
        public void prevInPlace() {
            this.decIndex();
            ImmutableNode.this.fillChildReferenceBitsetV2(this.getIndex(), this.bit, KodusKt.getNotNull(this.getNode()));
        }

        private final void incIndex() {
            this.setIndex(this.getIndex() + 1);
            this.getIndex();
            if (this.bit < 0) {
                int n = 0;
                int n2 = this.getIndex();
                if (n <= n2) {
                    int i;
                    do {
                        i = n++;
                        this.bit = this.bitset.nextSetBit(this.bit + 1);
                    } while (i != n2);
                }
            } else {
                this.bit = this.bitset.nextSetBit(this.bit + 1);
            }
            if (this.bit < 0) {
                throw new ExodusException("Inconsistent children bitset in Patricia node");
            }
        }

        private final void decIndex() {
            this.setIndex(this.getIndex() + -1);
            this.getIndex();
            if (this.bit < 0) {
                this.bit = 256;
                int n = this.getIndex();
                int n2 = ImmutableNode.this.getChildrenCount();
                while (n < n2) {
                    int i = n++;
                    this.bit = this.bitset.previousSetBit(this.bit - 1);
                }
            } else {
                if (this.bit == 0) {
                    throw new ExodusException("Inconsistent children bitset in Patricia node");
                }
                this.bit = this.bitset.previousSetBit(this.bit - 1);
            }
            if (this.bit < 0) {
                throw new ExodusException("Inconsistent children bitset in Patricia node");
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[V2ChildrenFormat.values().length];
            nArray[V2ChildrenFormat.Complete.ordinal()] = 1;
            nArray[V2ChildrenFormat.Sparse.ordinal()] = 2;
            nArray[V2ChildrenFormat.Bitset.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

