/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import java.util.Arrays;
import java.util.Iterator;
import jetbrains.exodus.tree.patricia.ChildReference;
import jetbrains.exodus.tree.patricia.ChildReferenceMutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ChildReferenceSet
implements Iterable<ChildReference> {
    private ChildReference[] refs;

    ChildReferenceSet() {
        this.clear(0);
    }

    void clear(int capacity) {
        this.refs = capacity == 0 ? null : new ChildReference[capacity];
    }

    int size() {
        return this.refs == null ? 0 : this.refs.length;
    }

    boolean isEmpty() {
        return this.size() == 0;
    }

    ChildReference get(byte b2) {
        int index2 = this.searchFor(b2);
        return index2 < 0 ? null : this.refs[index2];
    }

    ChildReference getRight() {
        int size = this.size();
        return size > 0 ? this.refs[size - 1] : null;
    }

    int searchFor(byte b2) {
        ChildReference[] refs = this.refs;
        int key = b2 & 0xFF;
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high + 1 >>> 1;
            ChildReference midRef = refs[mid];
            int n = cmp = midRef == null ? 1 : (midRef.firstByte & 0xFF) - key;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low - 1;
    }

    ChildReference referenceAt(int index2) {
        return this.refs[index2];
    }

    void putRight(@NotNull ChildReference ref) {
        int size = this.size();
        this.ensureCapacity(size + 1, size);
        this.refs[size] = ref;
    }

    void insertAt(int index2, @NotNull ChildReferenceMutable ref) {
        this.ensureCapacity(this.size() + 1, index2);
        this.refs[index2] = ref;
    }

    void setAt(int index2, @NotNull ChildReference ref) {
        this.refs[index2] = ref;
    }

    boolean remove(byte b2) {
        int index2 = this.searchFor(b2);
        if (index2 < 0) {
            return false;
        }
        int size = this.size();
        if (size == 1) {
            this.refs = null;
        } else {
            ChildReference[] refs = this.refs;
            int refsToCopy = size - index2 - 1;
            if (refsToCopy > 0) {
                System.arraycopy(refs, index2 + 1, refs, index2, refsToCopy);
            }
            this.refs = Arrays.copyOf(refs, refs.length - 1);
        }
        return true;
    }

    public ChildReferenceIterator iterator() {
        return this.iterator(-1);
    }

    ChildReferenceIterator iterator(int index2) {
        return new ChildReferenceIterator(this, index2);
    }

    private void ensureCapacity(int capacity, int insertPos) {
        ChildReference[] refs = this.refs;
        if (refs == null) {
            this.refs = new ChildReference[capacity];
        } else {
            int length = refs.length;
            if (length >= capacity) {
                if (insertPos < length - 1) {
                    System.arraycopy(refs, insertPos, refs, insertPos + 1, length - insertPos - 1);
                }
            } else {
                this.refs = new ChildReference[Math.max(length, capacity)];
                System.arraycopy(refs, 0, this.refs, 0, insertPos);
                System.arraycopy(refs, insertPos, this.refs, insertPos + 1, length - insertPos);
            }
        }
    }

    static final class ChildReferenceIterator
    implements Iterator<ChildReference> {
        private final ChildReference[] refs;
        private final int size;
        private int index;

        ChildReferenceIterator(ChildReferenceSet set, int index2) {
            this.refs = set.refs;
            this.size = set.size();
            this.index = index2;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size - 1;
        }

        @Override
        public ChildReference next() {
            ChildReference ref;
            int i = this.index;
            do {
                if (++i < this.size) continue;
                return null;
            } while ((ref = this.refs[i]) == null);
            this.index = i;
            return ref;
        }

        public ChildReference prev() {
            ChildReference ref;
            int i = this.index;
            do {
                if (--i >= 0) continue;
                return null;
            } while ((ref = this.refs[i]) == null);
            this.index = i;
            return ref;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        int getIndex() {
            return this.index;
        }

        @Nullable
        ChildReference currentRef() {
            int i = this.index;
            return i >= 0 && i < this.size ? this.refs[i] : null;
        }
    }
}

