/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LoggableIterator;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.Dumpable;
import jetbrains.exodus.tree.btree.AddressIterator;
import jetbrains.exodus.tree.btree.BTreeBase;
import jetbrains.exodus.tree.btree.BTreeDup;
import jetbrains.exodus.tree.btree.BTreeDupMutable;
import jetbrains.exodus.tree.btree.BTreeMutable;
import jetbrains.exodus.tree.btree.BTreeMutatingTraverser;
import jetbrains.exodus.tree.btree.BTreeReclaimTraverser;
import jetbrains.exodus.tree.btree.BaseLeafNodeMutable;
import jetbrains.exodus.tree.btree.BasePageMutable;
import jetbrains.exodus.tree.btree.LeafNode;
import jetbrains.exodus.tree.btree.LeafNodeDupMutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LeafNodeDup
extends LeafNode {
    @NotNull
    protected final BTreeDup tree;

    LeafNodeDup(@NotNull BTreeBase mainTree, @NotNull RandomAccessLoggable loggable) {
        super(loggable);
        this.tree = new BTreeDup(mainTree, this);
    }

    @Override
    @NotNull
    public ByteIterable getValue() {
        return this.tree.getRoot().getMinKey().getKey();
    }

    @Override
    public int compareValueTo(@NotNull ByteIterable iterable2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public BTreeBase getTree() {
        return this.tree;
    }

    @Override
    @NotNull
    public AddressIterator addressIterator() {
        BTreeMutatingTraverser traverser = BTreeMutatingTraverser.create(this.tree);
        return new AddressIterator(null, traverser.currentNode.size > 0, traverser);
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public boolean isDup() {
        return true;
    }

    @Override
    public long getDupCount() {
        return this.tree.size;
    }

    @Override
    public boolean valueExists(@NotNull ByteIterable value) {
        return this.tree.hasKey(value);
    }

    @NotNull
    BTreeDupMutable getTreeCopyMutable() {
        return this.tree.getMutableCopy();
    }

    @Override
    public String toString() {
        return "LND {key:" + this.getKey().toString() + '}';
    }

    @Override
    public void dump(PrintStream out, int level, Dumpable.ToString render) {
        super.dump(out, level, render);
        this.tree.getRoot().dump(out, level + 1, render);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doReclaim(@NotNull BTreeReclaimTraverser context, int leafIndex) {
        BTreeDupMutable tree;
        BaseLeafNodeMutable mutable;
        long keyAddress = context.currentNode.getKeyAddress(leafIndex);
        BTreeMutable mainTree = context.mainTree;
        if (keyAddress < 0L) {
            mutable = ((BasePageMutable)context.currentNode).keys[leafIndex];
            if (!mutable.isDup()) return;
            tree = ((LeafNodeDupMutable)mutable).tree;
        } else if (keyAddress == this.getAddress()) {
            BasePageMutable node = context.currentNode.getMutableCopy(mainTree);
            Iterator<RandomAccessLoggable> converted = LeafNodeDupMutable.convert(this, mainTree);
            mainTree.addExpiredLoggable(keyAddress);
            tree = ((LeafNodeDupMutable)((Object)converted)).tree;
            mutable = converted;
            node.set(leafIndex, mutable, null);
            context.wasReclaim = true;
            context.setPage(node);
        } else {
            RandomAccessLoggable upToDate = mainTree.getLoggable(keyAddress);
            switch (upToDate.getType()) {
                case 7: 
                case 8: {
                    mutable = null;
                    tree = new LeafNodeDup(mainTree, upToDate).getTreeCopyMutable();
                    tree.mainTree = mainTree;
                    break;
                }
                case 6: {
                    return;
                }
                default: {
                    throw new ExodusException("Unexpected loggable type " + upToDate.getType());
                }
            }
        }
        BTreeReclaimTraverser dupStack = new BTreeReclaimTraverser(tree);
        block14: for (RandomAccessLoggable loggable : context.dupLeafsLo) {
            switch (loggable.getType()) {
                case 11: {
                    new LeafNode(loggable).reclaim(dupStack);
                    continue block14;
                }
                case 9: {
                    tree.reclaimBottom(loggable, dupStack);
                    continue block14;
                }
                case 10: {
                    tree.reclaimInternal(loggable, dupStack);
                    continue block14;
                }
            }
            throw new ExodusException("Unexpected loggable type " + loggable.getType());
        }
        block15: for (RandomAccessLoggable loggable : context.dupLeafsHi) {
            switch (loggable.getType()) {
                case 11: {
                    new LeafNode(loggable).reclaim(dupStack);
                    continue block15;
                }
                case 9: {
                    tree.reclaimBottom(loggable, dupStack);
                    continue block15;
                }
                case 10: {
                    tree.reclaimInternal(loggable, dupStack);
                    continue block15;
                }
            }
            throw new ExodusException("Unexpected loggable type " + loggable.getType());
        }
        while (dupStack.canMoveUp()) {
            dupStack.popAndMutate();
        }
        if (!dupStack.wasReclaim || mutable != null) return;
        mainTree.addExpiredLoggable(keyAddress);
        BasePageMutable node = context.currentNode.getMutableCopy(mainTree);
        node.set(leafIndex, new LeafNodeDupMutable(tree), null);
        context.wasReclaim = true;
        context.setPage(node);
    }

    @Override
    protected void reclaim(@NotNull BTreeReclaimTraverser context) {
        long startAddress = this.tree.getStartAddress();
        Log log = this.tree.log;
        if (startAddress != -1L && log.hasAddress(startAddress)) {
            BoundLoggableIterator itr = new BoundLoggableIterator(log.getLoggableIterator(startAddress), log.getFileAddress(this.getAddress()));
            LeafNodeDup.collect(context.dupLeafsLo, itr.next(), itr);
        }
        super.reclaim(context);
    }

    @Nullable
    static RandomAccessLoggable collect(@NotNull List<RandomAccessLoggable> output, @NotNull RandomAccessLoggable loggable, @NotNull Iterator<RandomAccessLoggable> loggables) {
        while (true) {
            switch (loggable.getType()) {
                case 0: {
                    break;
                }
                case 7: 
                case 8: {
                    return loggable;
                }
                case 9: 
                case 10: 
                case 11: {
                    output.add(loggable);
                    break;
                }
                default: {
                    throw new ExodusException("Unexpected loggable type " + loggable.getType());
                }
            }
            if (!loggables.hasNext()) break;
            loggable = loggables.next();
        }
        return null;
    }

    private static final class BoundLoggableIterator
    implements Iterator<RandomAccessLoggable> {
        @NotNull
        private final LoggableIterator data;
        private final long upperBound;

        private BoundLoggableIterator(@NotNull LoggableIterator data, long upperBound) {
            this.data = data;
            this.upperBound = upperBound;
        }

        @Override
        public boolean hasNext() {
            return this.data.hasNext() && this.data.getHighAddress() < this.upperBound;
        }

        @Override
        public RandomAccessLoggable next() {
            return this.data.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

