/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import jetbrains.exodus.tree.btree.BTreeTraverser;
import jetbrains.exodus.tree.btree.BaseLeafNode;
import jetbrains.exodus.tree.btree.BasePage;
import jetbrains.exodus.tree.btree.ILeafNode;
import jetbrains.exodus.tree.btree.LeafNodeKV;
import jetbrains.exodus.tree.btree.TreePos;
import org.jetbrains.annotations.NotNull;

class BTreeTraverserDup
extends BTreeTraverser {
    protected boolean inDupTree;

    BTreeTraverserDup(@NotNull BasePage currentNode) {
        super(currentNode);
    }

    @Override
    public boolean canMoveDown() {
        int currentPos = this.currentPos;
        BasePage currentNode = this.currentNode;
        return currentPos < currentNode.size && (!currentNode.isBottom() || currentPos >= 0 && currentNode.isDupKey(currentPos));
    }

    @Override
    protected BasePage getChildForMoveDown() {
        if (this.currentNode.isBottom()) {
            BaseLeafNode leaf = this.currentNode.getKey(this.currentPos);
            this.inDupTree = true;
            return leaf.getTree().getRoot();
        }
        return super.getChildForMoveDown();
    }

    @Override
    public void moveUp() {
        super.moveUp();
        if (this.currentNode.isBottom()) {
            this.inDupTree = false;
        }
    }

    @Override
    protected ILeafNode handleLeaf(BaseLeafNode leaf) {
        if (leaf.isDupLeaf()) {
            return new LeafNodeKV(leaf.getValue(), leaf.getKey());
        }
        return super.handleLeaf(leaf);
    }

    @Override
    protected ILeafNode handleLeafR(BaseLeafNode leaf) {
        if (leaf.isDupLeaf()) {
            return new LeafNodeKV(leaf.getValue(), leaf.getKey());
        }
        if (leaf.isDup()) {
            this.inDupTree = true;
            return this.pushChild(new TreePos(this.currentNode, this.currentPos), leaf.getTree().getRoot(), 0);
        }
        return super.handleLeaf(leaf);
    }

    @Override
    protected ILeafNode handleLeafL(BaseLeafNode leaf) {
        if (leaf.isDupLeaf()) {
            return new LeafNodeKV(leaf.getValue(), leaf.getKey());
        }
        if (leaf.isDup()) {
            this.inDupTree = true;
            BasePage root = leaf.getTree().getRoot();
            return this.pushChild(new TreePos(this.currentNode, this.currentPos), root, root.size - 1);
        }
        return super.handleLeaf(leaf);
    }

    protected void popUntilDupRight() {
        TreePos current;
        int bottom = this.top;
        do {
            current = this.stack[--bottom];
            this.stack[bottom] = null;
        } while (!current.node.isBottom());
        this.currentNode = current.node;
        this.currentPos = current.pos;
        this.top = bottom;
        this.inDupTree = false;
    }

    protected void popUntilDupLeft() {
    }

    @Override
    protected boolean isDup() {
        return true;
    }
}

