/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.InvalidSettingException;
import jetbrains.exodus.core.dataStructures.ConcurrentIntObjectCache;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogUtil;
import jetbrains.exodus.util.MathUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\b \u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0017\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0014\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u000fH&J\b\u0010\u0016\u001a\u00020\u0011H&J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H&J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H&J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H$J\b\u0010\u001b\u001a\u00020\u001cH&J \u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0018\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0004J\u001d\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H \u00a2\u0006\u0002\b!R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0007\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006#"}, d2={"Ljetbrains/exodus/log/LogCache;", "", "memoryUsage", "", "pageSize", "", "(JI)V", "memoryUsagePercentage", "(II)V", "getMemoryUsage$xodus_environment", "()J", "getMemoryUsagePercentage", "()I", "getPageSize$xodus_environment", "allocPage", "", "cachePage", "", "log", "Ljetbrains/exodus/log/Log;", "pageAddress", "page", "clear", "getCachedPage", "getPage", "getPageIterable", "Ljetbrains/exodus/ArrayByteIterable;", "hitRate", "", "readBytes", "bytes", "readFullPage", "removePage", "removePage$xodus_environment", "Companion", "xodus-environment"})
public abstract class LogCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long memoryUsage;
    private final int memoryUsagePercentage;
    private final int pageSize;
    protected static final int MINIMUM_PAGE_SIZE = 1024;
    protected static final int DEFAULT_OPEN_FILES_COUNT = 16;
    protected static final int MINIMUM_MEM_USAGE_PERCENT = 5;
    protected static final int MAXIMUM_MEM_USAGE_PERCENT = 95;
    @NotNull
    private static final ConcurrentIntObjectCache<byte[]> TAIL_PAGES_CACHE = new ConcurrentIntObjectCache(10, 0, 2, null);

    public final long getMemoryUsage$xodus_environment() {
        return this.memoryUsage;
    }

    protected final int getMemoryUsagePercentage() {
        return this.memoryUsagePercentage;
    }

    public final int getPageSize$xodus_environment() {
        return this.pageSize;
    }

    protected LogCache(long memoryUsage, final int pageSize) {
        LogCache.Companion.checkPageSize(pageSize);
        this.pageSize = pageSize;
        LogCache.Companion.checkIntegerLogarithm(pageSize, new Function0<String>(){

            @Override
            @NotNull
            public final String invoke() {
                return Intrinsics.stringPlus("Log cache page size should be a power of 2: ", pageSize);
            }
        });
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory <= memoryUsage) {
            throw new InvalidSettingException("Memory usage cannot be greater than JVM maximum memory");
        }
        this.memoryUsage = memoryUsage;
        this.memoryUsagePercentage = 0;
    }

    protected LogCache(int memoryUsagePercentage, final int pageSize) {
        LogCache.Companion.checkPageSize(pageSize);
        if (memoryUsagePercentage < 5) {
            throw new InvalidSettingException("Memory usage percent cannot be less than 5");
        }
        if (memoryUsagePercentage > 95) {
            throw new InvalidSettingException("Memory usage percent cannot be greater than 95");
        }
        this.pageSize = pageSize;
        LogCache.Companion.checkIntegerLogarithm(pageSize, new Function0<String>(){

            @Override
            @NotNull
            public final String invoke() {
                return Intrinsics.stringPlus("Log cache page size should be a power of 2: ", pageSize);
            }
        });
        long maxMemory = Runtime.getRuntime().maxMemory();
        this.memoryUsage = maxMemory == Long.MAX_VALUE ? Long.MAX_VALUE : maxMemory / 100L * (long)memoryUsagePercentage;
        this.memoryUsagePercentage = memoryUsagePercentage;
    }

    public abstract void clear();

    public abstract float hitRate();

    public abstract void cachePage(@NotNull Log var1, long var2, @NotNull byte[] var4);

    @NotNull
    public abstract byte[] getPage(@NotNull Log var1, long var2);

    @Nullable
    public abstract byte[] getCachedPage(@NotNull Log var1, long var2);

    @NotNull
    protected abstract ArrayByteIterable getPageIterable(@NotNull Log var1, long var2);

    public abstract void removePage$xodus_environment(@NotNull Log var1, long var2);

    @NotNull
    protected final byte[] readFullPage(@NotNull Log log, long pageAddress) {
        byte[] byArray;
        int readAheadMultiple;
        Intrinsics.checkNotNullParameter(log, "log");
        long fileAddress = log.getFileAddress(pageAddress);
        for (readAheadMultiple = 1; readAheadMultiple < log.getConfig().getCacheReadAheadMultiple() && log.getFileAddress(pageAddress + (long)(this.pageSize * readAheadMultiple)) == fileAddress && this.getCachedPage(log, pageAddress + (long)(this.pageSize * readAheadMultiple)) == null; ++readAheadMultiple) {
        }
        if (readAheadMultiple == 1) {
            byte[] byArray2;
            byte[] page = byArray2 = this.allocPage();
            boolean bl = false;
            this.readBytes(log, page, pageAddress);
            byArray = byArray2;
        } else {
            byte[] byArray3;
            byte[] pages = new byte[this.pageSize * readAheadMultiple];
            this.readBytes(log, pages, pageAddress);
            int n = 1;
            while (n < readAheadMultiple) {
                int i = n++;
                byte[] page = this.allocPage();
                System.arraycopy(pages, this.pageSize * i, page, 0, this.pageSize);
                this.cachePage(log, pageAddress + (long)(this.pageSize * i), page);
            }
            byte[] page = byArray3 = this.allocPage();
            boolean bl = false;
            System.arraycopy(pages, 0, page, 0, this.getPageSize$xodus_environment());
            this.cachePage(log, pageAddress, page);
            byArray = byArray3;
        }
        return byArray;
    }

    @NotNull
    public final byte[] allocPage() {
        return new byte[this.pageSize];
    }

    private final void readBytes(Log log, byte[] bytes, long pageAddress) {
        int bytesRead = log.readBytes(bytes, pageAddress);
        if (bytesRead != bytes.length) {
            throw new ExodusException("Can't read full page from log [" + log.getLocation() + "] with address " + pageAddress + " (file " + LogUtil.getLogFilename(log.getFileAddress(pageAddress)) + "), offset: " + pageAddress % log.getFileLengthBound() + ", read: " + bytesRead);
        }
    }

    @JvmStatic
    @NotNull
    protected static final byte[] postProcessTailPage(@NotNull byte[] page) {
        return Companion.postProcessTailPage(page);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0005R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/exodus/log/LogCache$Companion;", "", "()V", "DEFAULT_OPEN_FILES_COUNT", "", "MAXIMUM_MEM_USAGE_PERCENT", "MINIMUM_MEM_USAGE_PERCENT", "MINIMUM_PAGE_SIZE", "TAIL_PAGES_CACHE", "Ljetbrains/exodus/core/dataStructures/ConcurrentIntObjectCache;", "", "checkIntegerLogarithm", "", "i", "exceptionMessage", "Lkotlin/Function0;", "", "checkPageSize", "pageSize", "getCachedTailPage", "cachePageSize", "isTailPage", "", "page", "postProcessTailPage", "xodus-environment"})
    public static final class Companion {
        private Companion() {
        }

        private final void checkPageSize(int pageSize) {
            if (pageSize < 1024) {
                throw new InvalidSettingException("Page size cannot be less than 1024");
            }
            if (pageSize % 1024 != 0) {
                throw new InvalidSettingException("Page size should be multiple of 1024");
            }
        }

        private final void checkIntegerLogarithm(int i, Function0<String> exceptionMessage) {
            if (1 << MathUtil.integerLogarithm(i) != i) {
                throw new InvalidSettingException(exceptionMessage.invoke());
            }
        }

        @JvmStatic
        @NotNull
        protected final byte[] postProcessTailPage(@NotNull byte[] page) {
            Intrinsics.checkNotNullParameter(page, "page");
            if (this.isTailPage(page)) {
                int length = page.length;
                byte[] cachedTailPage = this.getCachedTailPage(length);
                if (cachedTailPage != null) {
                    return cachedTailPage;
                }
                TAIL_PAGES_CACHE.cacheObject(length, page);
            }
            return page;
        }

        @Nullable
        public final byte[] getCachedTailPage(int cachePageSize) {
            return (byte[])TAIL_PAGES_CACHE.tryKey(cachePageSize);
        }

        private final boolean isTailPage(byte[] page) {
            for (byte b2 : page) {
                if (b2 == -128) continue;
                return false;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

