/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.log.ArrayByteIterableWithAddress;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.LogAwareFixedLengthByteIterable;
import org.jetbrains.annotations.NotNull;

public abstract class ByteIterableWithAddress
implements ByteIterable {
    public static final ByteIterableWithAddress EMPTY = ByteIterableWithAddress.getEmpty(-1L);
    private final long address;

    protected ByteIterableWithAddress(long address) {
        this.address = address;
    }

    public final long getDataAddress() {
        return this.address;
    }

    public byte byteAt(int offset) {
        return this.iterator(offset).next();
    }

    public long nextLong(int offset, int length) {
        return this.iterator(offset).nextLong(length);
    }

    public int getCompressedUnsignedInt() {
        return CompressedUnsignedLongByteIterable.getInt(this);
    }

    @Override
    public abstract ByteIteratorWithAddress iterator();

    public abstract ByteIteratorWithAddress iterator(int var1);

    public abstract int compareTo(int var1, int var2, @NotNull ByteIterable var3);

    public abstract ByteIterableWithAddress clone(int var1);

    @Override
    public byte[] getBytesUnsafe() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLength() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ByteIterable subIterable(int offset, int length) {
        return new LogAwareFixedLengthByteIterable(this, offset, length);
    }

    @Override
    public int compareTo(@NotNull ByteIterable right) {
        throw new UnsupportedOperationException();
    }

    static ByteIterableWithAddress getEmpty(long address) {
        return new ArrayByteIterableWithAddress(address, ByteIterable.EMPTY_BYTES, 0, 0);
    }
}

