/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io.inMemory;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Map;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.LongObjectCache;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.log.LogUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\r\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u001d\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001bR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ljetbrains/exodus/io/inMemory/Memory;", "", "()V", "allBlocks", "", "Ljetbrains/exodus/io/inMemory/Memory$Block;", "getAllBlocks$xodus_environment", "()Ljava/util/Collection;", "data", "Ljetbrains/exodus/core/dataStructures/hash/LongHashMap;", "lastBlock", "removedBlocks", "Ljetbrains/exodus/core/dataStructures/LongObjectCache;", "clear", "", "clear$xodus_environment", "dump", "location", "Ljava/io/File;", "getOrCreateBlockData", "address", "", "length", "getOrCreateBlockData$xodus_environment", "removeBlock", "", "blockAddress", "removeBlock$xodus_environment", "Block", "xodus-environment"})
public class Memory {
    @Nullable
    private Block lastBlock;
    @NotNull
    private final LongHashMap<Block> data = new LongHashMap(0, 0.0f, 3, null);
    @NotNull
    private final LongObjectCache<Block> removedBlocks = new LongObjectCache(100);

    @NotNull
    public final Collection<Block> getAllBlocks$xodus_environment() {
        Collection<Block> collection = this.data.values();
        Intrinsics.checkNotNullExpressionValue(collection, "data.values");
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Block getOrCreateBlockData$xodus_environment(long address, long length) {
        Block block;
        LongHashMap<Block> $this$synchronized$iv = this.data;
        boolean $i$f$synchronized = false;
        synchronized ($this$synchronized$iv) {
            Block block2;
            Block block3;
            Block block4;
            boolean bl = false;
            LongHashMap<Block> $this$getOrCreateBlockData_u24lambda_u2d2 = $this$synchronized$iv;
            boolean bl2 = false;
            Block block5 = $this$getOrCreateBlockData_u24lambda_u2d2.get((Object)address);
            if (block5 == null) {
                block4 = null;
            } else {
                Block block6;
                Block it = block6 = block5;
                boolean bl3 = false;
                if ((long)it.getSize() != length) {
                    it.setSize(length);
                }
                this.lastBlock = it;
                block4 = block3 = block6;
            }
            if (block3 == null) {
                int n;
                Block block7;
                LongHashMap<Block> $this$getOrCreateBlockData_u24lambda_u2d2_u24lambda_u2d1 = $this$getOrCreateBlockData_u24lambda_u2d2;
                boolean bl4 = false;
                Block block8 = this.lastBlock;
                this.lastBlock = block7 = new Block(address, block8 == null ? 2048 : (n = block8.getSize()));
                Map map = $this$getOrCreateBlockData_u24lambda_u2d2_u24lambda_u2d1;
                Long l = address;
                Block block9 = this.lastBlock;
                map.put(l, block9);
                block2 = block7;
            } else {
                block2 = block3;
            }
            block = block2;
        }
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeBlock$xodus_environment(long blockAddress) {
        Block removed;
        Block block;
        LongHashMap<Block> $this$synchronized$iv = this.data;
        boolean $i$f$synchronized = false;
        synchronized ($this$synchronized$iv) {
            boolean bl = false;
            LongHashMap<Block> $this$removeBlock_u24lambda_u2d3 = $this$synchronized$iv;
            boolean bl2 = false;
            block = $this$removeBlock_u24lambda_u2d3.remove((Object)blockAddress);
        }
        Block block2 = removed = block;
        if (block2 != null) {
            Block it = block2;
            boolean bl = false;
            LongHashMap<Block> $this$synchronized$iv2 = this.data;
            boolean $i$f$synchronized2 = false;
            synchronized ($this$synchronized$iv2) {
                boolean bl3 = false;
                LongHashMap<Block> $this$removeBlock_u24lambda_u2d5_u24lambda_u2d4 = $this$synchronized$iv2;
                boolean bl4 = false;
                Block block3 = this.removedBlocks.cacheObject(blockAddress, removed);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear$xodus_environment() {
        LongHashMap<Block> $this$synchronized$iv = this.data;
        boolean $i$f$synchronized = false;
        synchronized ($this$synchronized$iv) {
            boolean bl = false;
            LongHashMap<Block> $this$clear_u24lambda_u2d6 = $this$synchronized$iv;
            boolean bl2 = false;
            $this$clear_u24lambda_u2d6.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dump(@NotNull File location) {
        Intrinsics.checkNotNullParameter(location, "location");
        location.mkdirs();
        Function2 saver2 = new Function2<Long, Block, Unit>(location){
            final /* synthetic */ File $location;
            {
                this.$location = $location;
                super(2);
            }

            public final void invoke(long key, @NotNull Block block) {
                Intrinsics.checkNotNullParameter(block, "block");
                try {
                    File dest = new File(this.$location, LogUtil.getLogFilename(key));
                    RandomAccessFile output = new RandomAccessFile(dest, "rw");
                    output.write(block.getData(), 0, block.getSize());
                    output.close();
                }
                catch (IOException e) {
                    throw new ExodusException(e);
                }
            }
        };
        LongHashMap<Block> $this$synchronized$iv = this.data;
        boolean $i$f$synchronized = false;
        synchronized ($this$synchronized$iv) {
            boolean bl = false;
            LongHashMap<Block> $this$dump_u24lambda_u2d9 = $this$synchronized$iv;
            boolean bl2 = false;
            $this$dump_u24lambda_u2d9.forEach((arg_0, arg_1) -> Memory.dump$lambda-9$lambda-7(saver2, arg_0, arg_1));
            boolean bl3 = this.removedBlocks.forEachEntry(arg_0 -> Memory.dump$lambda-9$lambda-8(saver2, arg_0));
        }
    }

    private static final void dump$lambda-9$lambda-7(Function2 $tmp0, Long p0, Block p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final boolean dump$lambda-9$lambda-8(Function2 $saver, Map.Entry entry) {
        Intrinsics.checkNotNullParameter($saver, "$saver");
        Object object = entry.getKey();
        Intrinsics.checkNotNullExpressionValue(object, "entry.key");
        Object k = object;
        object = entry.getValue();
        Intrinsics.checkNotNullExpressionValue(object, "entry.value");
        $saver.invoke(k, object);
        return true;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016J(\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u0000H\u0016J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0003J\u001e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Ljetbrains/exodus/io/inMemory/Memory$Block;", "Ljetbrains/exodus/io/Block;", "_address", "", "initialSize", "", "(JI)V", "<set-?>", "", "data", "getData", "()[B", "size", "getSize", "()I", "ensureCapacity", "", "minCapacity", "getAddress", "length", "read", "output", "position", "offset", "count", "refresh", "setSize", "write", "b", "off", "len", "xodus-environment"})
    public static final class Block
    implements jetbrains.exodus.io.Block {
        private final long _address;
        private int size;
        @NotNull
        private byte[] data;

        public Block(long _address, int initialSize) {
            this._address = _address;
            this.data = new byte[initialSize];
        }

        public final int getSize() {
            return this.size;
        }

        @NotNull
        public final byte[] getData() {
            return this.data;
        }

        @Override
        public long getAddress() {
            return this._address;
        }

        @Override
        public long length() {
            return this.size;
        }

        public final void setSize(long size) {
            this.size = (int)size;
        }

        public final void write(@NotNull byte[] b2, int off, int len) {
            Intrinsics.checkNotNullParameter(b2, "b");
            int newSize = this.size + len;
            this.ensureCapacity(newSize);
            System.arraycopy(b2, off, this.data, this.size, len);
            this.size = newSize;
        }

        @Override
        public int read(@NotNull byte[] output, long position, int offset, int count) {
            Intrinsics.checkNotNullParameter(output, "output");
            int result = count;
            if (position < 0L) {
                throw new ExodusException("Block index out of range, underflow");
            }
            long maxRead = (long)this.size - position;
            if (maxRead < 0L) {
                throw new ExodusException("Block index out of range");
            }
            if (maxRead < (long)result) {
                result = (int)maxRead;
            }
            System.arraycopy(this.data, (int)position, output, offset, result);
            return result;
        }

        @Override
        @NotNull
        public Block refresh() {
            return this;
        }

        public final void ensureCapacity(int minCapacity) {
            int oldCapacity = this.data.length;
            if (minCapacity > oldCapacity) {
                byte[] oldData = this.data;
                int newCapacity = oldCapacity * 3 / 2 + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.data = new byte[newCapacity];
                System.arraycopy(oldData, 0, this.data, 0, oldCapacity);
            }
        }
    }
}

