/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.ObjectCache;
import jetbrains.exodus.core.dataStructures.ObjectCacheBase;
import jetbrains.exodus.util.SharedRandomAccessFile;
import org.jetbrains.annotations.NotNull;

public final class SharedOpenFilesCache {
    private static final Object syncObject = new Object();
    private static int cacheSize = 0;
    private static volatile SharedOpenFilesCache theCache = null;
    private final ObjectCache<File, SharedRandomAccessFile> cache;

    private SharedOpenFilesCache(int openFiles) {
        this.cache = new ObjectCache(openFiles);
    }

    public static void setSize(int cacheSize) {
        if (cacheSize <= 0) {
            throw new IllegalArgumentException("Cache size must be a positive integer value");
        }
        SharedOpenFilesCache.cacheSize = cacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SharedOpenFilesCache getInstance() {
        if (cacheSize == 0) {
            throw new ExodusException("Size of SharedOpenFilesCache is not set");
        }
        SharedOpenFilesCache result = theCache;
        if (result == null) {
            Object object = syncObject;
            synchronized (object) {
                result = theCache;
                if (result == null) {
                    result = theCache = new SharedOpenFilesCache(cacheSize);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidate() throws IOException {
        SharedOpenFilesCache obsolete;
        Object object = syncObject;
        synchronized (object) {
            obsolete = theCache;
            theCache = null;
        }
        if (obsolete != null) {
            obsolete.clear();
        }
    }

    @NotNull
    SharedRandomAccessFile getCachedFile(@NotNull File file) throws IOException {
        SharedRandomAccessFile result;
        try (ObjectCacheBase.CriticalSection ignored = this.cache.newCriticalSection();){
            result = this.cache.tryKey(file);
            if (result != null && result.employ() > 1) {
                result.close();
                result = null;
            }
        }
        if (result == null) {
            result = this.openFile(file);
            SharedRandomAccessFile obsolete = null;
            try (ObjectCacheBase.CriticalSection ignored = this.cache.newCriticalSection();){
                if (this.cache.getObject(file) == null) {
                    result.employ();
                    obsolete = this.cache.cacheObject(file, result);
                }
            }
            if (obsolete != null) {
                obsolete.close();
            }
        }
        return result;
    }

    @NotNull
    SharedRandomAccessFile openFile(@NotNull File file) throws IOException {
        return new SharedRandomAccessFile(file, "r");
    }

    void removeFile(@NotNull File file) throws IOException {
        SharedRandomAccessFile result;
        try (ObjectCacheBase.CriticalSection ignored = this.cache.newCriticalSection();){
            result = this.cache.remove(file);
        }
        if (result != null) {
            result.close();
        }
    }

    void removeDirectory(@NotNull File dir) throws IOException {
        ArrayList<SharedRandomAccessFile> result = new ArrayList<SharedRandomAccessFile>();
        ArrayList<File> obsoleteFiles = new ArrayList<File>();
        try (ObjectCacheBase.CriticalSection ignored = this.cache.newCriticalSection();){
            Iterator<File> keys2 = this.cache.keys();
            while (keys2.hasNext()) {
                File file = keys2.next();
                if (!file.getParentFile().equals(dir)) continue;
                obsoleteFiles.add(file);
                result.add(this.cache.getObject(file));
            }
            for (File file : obsoleteFiles) {
                this.cache.remove(file);
            }
        }
        for (SharedRandomAccessFile obsolete : result) {
            obsolete.close();
        }
    }

    private void clear() throws IOException {
        ArrayList<SharedRandomAccessFile> openFiles = new ArrayList<SharedRandomAccessFile>();
        try (ObjectCacheBase.CriticalSection ignored = this.cache.newCriticalSection();){
            Iterator<SharedRandomAccessFile> it = this.cache.values();
            while (it.hasNext()) {
                openFiles.add(it.next());
            }
            this.cache.clear();
        }
        for (SharedRandomAccessFile file : openFiles) {
            file.close();
        }
    }
}

