/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.util.List;
import java.util.Map;
import jetbrains.exodus.core.dataStructures.decorators.HashMapDecorator;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.debug.StackTrace;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.MetaTreeImpl;
import jetbrains.exodus.env.ReadWriteTransaction;
import jetbrains.exodus.env.ReadonlyTransaction;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionFinishedException;
import jetbrains.exodus.tree.ITree;
import jetbrains.exodus.tree.TreeMetaInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TransactionBase
implements Transaction {
    @NotNull
    private static final StackTrace EMPTY_TRACE = new StackTrace(new StackTraceElement[0]);
    @NotNull
    private final EnvironmentImpl env;
    @NotNull
    private final Thread creatingThread;
    private MetaTreeImpl metaTree;
    @NotNull
    private final IntHashMap<ITree> immutableTrees;
    @NotNull
    private final Map<Object, Object> userObjects;
    @Nullable
    private final StackTrace trace;
    private final long created;
    private long started;
    private boolean isExclusive;
    private final boolean wasCreatedExclusive;
    @Nullable
    private StackTrace traceFinish;
    private boolean disableStoreGetCache;

    public TransactionBase(@NotNull EnvironmentImpl env, boolean isExclusive) {
        this.env = env;
        this.creatingThread = Thread.currentThread();
        this.isExclusive = isExclusive;
        this.wasCreatedExclusive = isExclusive;
        this.immutableTrees = new IntHashMap();
        this.userObjects = new HashMapDecorator<Object, Object>();
        this.trace = env.transactionTimeout() > 0 || env.getEnvironmentConfig().getProfilerEnabled() ? new StackTrace() : null;
        this.started = this.created = System.currentTimeMillis();
        this.traceFinish = null;
    }

    @Override
    public Transaction getSnapshot() {
        return this.getSnapshot(null);
    }

    @Override
    public Transaction getSnapshot(@Nullable Runnable beginHook) {
        this.checkIsFinished();
        return new ReadWriteTransaction(this, beginHook);
    }

    @Override
    public Transaction getReadonlySnapshot() {
        this.checkIsFinished();
        return new ReadonlyTransaction(this);
    }

    @Override
    @NotNull
    public EnvironmentImpl getEnvironment() {
        return this.env;
    }

    @Override
    public long getStartTime() {
        return this.started;
    }

    @Override
    public long getHighAddress() {
        return this.metaTree.logTip.highAddress;
    }

    @Override
    public boolean isExclusive() {
        return this.isExclusive;
    }

    @Override
    public boolean isFinished() {
        return this.traceFinish != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object getUserObject(@NotNull Object key) {
        Map<Object, Object> map = this.userObjects;
        synchronized (map) {
            return this.userObjects.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserObject(@NotNull Object key, @NotNull Object value) {
        Map<Object, Object> map = this.userObjects;
        synchronized (map) {
            this.userObjects.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ITree getTree(@NotNull StoreImpl store) {
        this.checkIsFinished();
        int structureId = store.getStructureId();
        ITree result = this.immutableTrees.get(structureId);
        if (result == null) {
            result = store.openImmutableTree(this.getMetaTree());
            IntHashMap<ITree> intHashMap = this.immutableTrees;
            synchronized (intHashMap) {
                this.immutableTrees.put(structureId, result);
            }
        }
        return result;
    }

    public void checkIsFinished() {
        if (this.isFinished()) {
            throw this.traceFinish == EMPTY_TRACE ? new TransactionFinishedException() : new TransactionFinishedException(this.traceFinish);
        }
    }

    public boolean isDisableStoreGetCache() {
        return this.disableStoreGetCache;
    }

    public void setDisableStoreGetCache(boolean disableStoreGetCache) {
        this.disableStoreGetCache = disableStoreGetCache;
    }

    @NotNull
    Thread getCreatingThread() {
        return this.creatingThread;
    }

    @NotNull
    MetaTreeImpl getMetaTree() {
        return this.metaTree;
    }

    void setMetaTree(@NotNull MetaTreeImpl metaTree) {
        this.checkIsFinished();
        this.metaTree = metaTree;
    }

    long getRoot() {
        return this.getMetaTree().root;
    }

    boolean checkVersion(long root) {
        return this.metaTree.root == root;
    }

    @Nullable
    public StackTrace getTrace() {
        return this.trace;
    }

    long getCreated() {
        return this.created;
    }

    void setStarted(long started) {
        this.started = started;
    }

    boolean wasCreatedExclusive() {
        return this.wasCreatedExclusive;
    }

    boolean isGCTransaction() {
        return false;
    }

    @Nullable
    TreeMetaInfo getTreeMetaInfo(@NotNull String name) {
        this.checkIsFinished();
        return this.metaTree.getMetaInfo(name, this.env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeRemoved(@NotNull StoreImpl store) {
        this.checkIsFinished();
        IntHashMap<ITree> intHashMap = this.immutableTrees;
        synchronized (intHashMap) {
            this.immutableTrees.remove(store.getStructureId());
        }
    }

    @NotNull
    List<String> getAllStoreNames() {
        this.checkIsFinished();
        return this.getMetaTree().getAllStoreNames();
    }

    @Nullable
    abstract Runnable getBeginHook();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearImmutableTrees() {
        IntHashMap<ITree> intHashMap = this.immutableTrees;
        synchronized (intHashMap) {
            this.immutableTrees.clear();
        }
    }

    protected void setExclusive(boolean isExclusive) {
        this.isExclusive = isExclusive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setIsFinished() {
        if (this.traceFinish == null) {
            this.clearImmutableTrees();
            Map<Object, Object> map = this.userObjects;
            synchronized (map) {
                this.userObjects.clear();
            }
            this.traceFinish = this.env.getEnvironmentConfig().isEnvTxnTraceFinish() ? new StackTrace() : EMPTY_TRACE;
            return true;
        }
        return false;
    }

    protected Runnable getWrappedBeginHook(@Nullable Runnable beginHook) {
        return () -> {
            EnvironmentImpl env = this.getEnvironment();
            this.setMetaTree(env.getMetaTreeInternal());
            env.registerTransaction(this);
            if (beginHook != null) {
                beginHook.run();
            }
        };
    }
}

