/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.ContextualEnvironmentImpl;
import jetbrains.exodus.env.ContextualStore;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.tree.TreeMetaInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextualStoreImpl
extends StoreImpl
implements ContextualStore {
    @NotNull
    private final ContextualEnvironmentImpl environment;

    public ContextualStoreImpl(@NotNull ContextualEnvironmentImpl env, @NotNull String name, @NotNull TreeMetaInfo metaInfo) {
        super(env, name, metaInfo);
        this.environment = env;
    }

    @Override
    @NotNull
    public ContextualEnvironmentImpl getEnvironment() {
        return this.environment;
    }

    @Override
    @Nullable
    public ByteIterable get(@NotNull ByteIterable key) {
        return this.get(this.environment.getAndCheckCurrentTransaction(), key);
    }

    @Override
    public boolean exists(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return this.exists(this.environment.getAndCheckCurrentTransaction(), key, value);
    }

    @Override
    public boolean put(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return this.put(this.environment.getAndCheckCurrentTransaction(), key, value);
    }

    @Override
    public void putRight(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        this.putRight(this.environment.getAndCheckCurrentTransaction(), key, value);
    }

    @Override
    public boolean add(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return this.add(this.environment.getAndCheckCurrentTransaction(), key, value);
    }

    @Override
    public boolean delete(@NotNull ByteIterable key) {
        return this.delete(this.environment.getAndCheckCurrentTransaction(), key);
    }

    @Override
    public long count() {
        return this.count(this.environment.getAndCheckCurrentTransaction());
    }

    @Override
    public Cursor openCursor() {
        return this.openCursor(this.environment.getAndCheckCurrentTransaction());
    }
}

