/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.util;

import java.util.Iterator;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.iterate.OrderedEntityIdCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImmutableSingleTypeEntityIdCollection
implements OrderedEntityIdCollection {
    private final int singleTypeId;
    @NotNull
    private final long[] idArray;

    public ImmutableSingleTypeEntityIdCollection(int singleTypeId, @NotNull long[] idArray) {
        this.singleTypeId = singleTypeId;
        this.idArray = idArray;
    }

    @Override
    public int count() {
        return this.idArray.length;
    }

    @Override
    public EntityId getFirst() {
        return new PersistentEntityId(this.singleTypeId, this.idArray[0]);
    }

    @Override
    public EntityId getLast() {
        return new PersistentEntityId(this.singleTypeId, this.idArray[this.idArray.length - 1]);
    }

    @NotNull
    public long[] getIdArray() {
        return this.idArray;
    }

    @Override
    @NotNull
    public Iterator<EntityId> iterator() {
        return new Iterator<EntityId>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < ImmutableSingleTypeEntityIdCollection.this.idArray.length;
            }

            @Override
            @Nullable
            public EntityId next() {
                return new PersistentEntityId(ImmutableSingleTypeEntityIdCollection.this.singleTypeId, ImmutableSingleTypeEntityIdCollection.this.idArray[this.i++]);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<EntityId> reverseIterator() {
        return new Iterator<EntityId>(){
            private int i;
            {
                this.i = ImmutableSingleTypeEntityIdCollection.this.idArray.length;
            }

            @Override
            public boolean hasNext() {
                return this.i > 0;
            }

            @Override
            @Nullable
            public EntityId next() {
                return new PersistentEntityId(ImmutableSingleTypeEntityIdCollection.this.singleTypeId, ImmutableSingleTypeEntityIdCollection.this.idArray[--this.i]);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

