/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.ArrayDeque;
import java.util.Collection;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableDecoratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleDecorator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.SourceMappingIterator;
import jetbrains.exodus.entitystore.tables.LinkValue;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.entitystore.util.EntityIdSetFactory;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.kotlin.KodusKt;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/exodus/entitystore/iterate/SelectManyIterable;", "Ljetbrains/exodus/entitystore/iterate/EntityIterableDecoratorBase;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "source", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "linkId", "", "distinct", "", "(Ljetbrains/exodus/entitystore/PersistentStoreTransaction;Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;IZ)V", "canBeCached", "getHandleImpl", "Ljetbrains/exodus/entitystore/EntityIterableHandle;", "getIteratorImpl", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "Companion", "SelectManyDistinctIterator", "xodus-entity-store"})
public final class SelectManyIterable
extends EntityIterableDecoratorBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int linkId;
    private final boolean distinct;

    public SelectManyIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source, int linkId, boolean distinct2) {
        Intrinsics.checkNotNullParameter(txn, "txn");
        Intrinsics.checkNotNullParameter(source, "source");
        super(txn, source);
        this.linkId = linkId;
        this.distinct = distinct2;
    }

    public /* synthetic */ SelectManyIterable(PersistentStoreTransaction persistentStoreTransaction, EntityIterableBase entityIterableBase, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        this(persistentStoreTransaction, entityIterableBase, n, bl);
    }

    @Override
    public boolean canBeCached() {
        return super.canBeCached() && this.distinct;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter(txn, "txn");
        return new SelectManyDistinctIterator(txn);
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        PersistentEntityStoreImpl persistentEntityStoreImpl = this.getStore();
        EntityIterableType entityIterableType = Companion.getType();
        EntityIterableHandle entityIterableHandle = this.source.getHandle();
        return new EntityIterableHandleDecorator(this, persistentEntityStoreImpl, entityIterableType, entityIterableHandle){
            @NotNull
            private final int[] linkIds;
            final /* synthetic */ SelectManyIterable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                int[] nArray = new int[]{SelectManyIterable.access$getLinkId$p(this.this$0)};
                int[] nArray2 = EntityIterableHandleBase.mergeFieldIds(nArray, this.decorated.getLinkIds());
                Intrinsics.checkNotNullExpressionValue(nArray2, "mergeFieldIds(intArrayOf\u2026nkId), decorated.linkIds)");
                this.linkIds = nArray2;
            }

            @NotNull
            public int[] getLinkIds() {
                return this.linkIds;
            }

            public void toString(@NotNull StringBuilder builder) {
                Intrinsics.checkNotNullParameter(builder, "builder");
                super.toString(builder);
                this.applyDecoratedToBuilder(builder);
                builder.append('-');
                builder.append(SelectManyIterable.access$getLinkId$p(this.this$0));
                builder.append('-');
                builder.append(SelectManyIterable.access$getDistinct$p(this.this$0));
            }

            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                Intrinsics.checkNotNullParameter(hash, "hash");
                super.hashCode(hash);
                hash.applyDelimiter();
                hash.apply(SelectManyIterable.access$getLinkId$p(this.this$0));
                hash.applyDelimiter();
                hash.apply((byte)(SelectManyIterable.access$getDistinct$p(this.this$0) ? 1 : 0));
            }

            public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                Intrinsics.checkNotNullParameter(source, "source");
                Intrinsics.checkNotNullParameter(target, "target");
                return linkId == SelectManyIterable.access$getLinkId$p(this.this$0) || this.decorated.isMatchedLinkAdded(source, target, linkId);
            }

            public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                Intrinsics.checkNotNullParameter(source, "source");
                Intrinsics.checkNotNullParameter(target, "target");
                return linkId == SelectManyIterable.access$getLinkId$p(this.this$0) || this.decorated.isMatchedLinkDeleted(source, target, linkId);
            }
        };
    }

    private static final EntityIterableBase _init_$lambda-0(PersistentStoreTransaction txn, PersistentEntityStoreImpl $noName_1, Object[] parameters) {
        Intrinsics.checkNotNullExpressionValue(txn, "txn");
        Object object = parameters[1];
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type jetbrains.exodus.entitystore.iterate.EntityIterableBase");
        }
        EntityIterableBase entityIterableBase = (EntityIterableBase)object;
        Object object2 = parameters[0];
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        Integer n = Integer.valueOf((String)object2);
        Intrinsics.checkNotNullExpressionValue(n, "valueOf(parameters[0] as String)");
        return new SelectManyIterable(txn, entityIterableBase, ((Number)n).intValue(), false, 8, null);
    }

    static {
        EntityIterableBase.registerType(Companion.getType(), SelectManyIterable::_init_$lambda-0);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000fH\u0016J\b\u0010\u0018\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0014J\n\u0010\u001a\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/exodus/entitystore/iterate/SelectManyIterable$SelectManyDistinctIterator;", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "Ljetbrains/exodus/entitystore/iterate/SourceMappingIterator;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "(Ljetbrains/exodus/entitystore/iterate/SelectManyIterable;Ljetbrains/exodus/entitystore/PersistentStoreTransaction;)V", "auxArray", "", "auxStream", "Ljetbrains/exodus/util/LightOutputStream;", "ids", "Ljava/util/ArrayDeque;", "Lkotlin/Pair;", "Ljetbrains/exodus/entitystore/EntityId;", "idsCollected", "", "sourceIt", "srcId", "usedCursors", "Ljetbrains/exodus/core/dataStructures/hash/IntHashMap;", "Ljetbrains/exodus/env/Cursor;", "collectIds", "", "dispose", "getSourceId", "hasNextImpl", "nextIdImpl", "xodus-entity-store"})
    private final class SelectManyDistinctIterator
    extends EntityIteratorBase
    implements SourceMappingIterator {
        @NotNull
        private final PersistentStoreTransaction txn;
        @NotNull
        private final EntityIteratorBase sourceIt;
        @NotNull
        private final IntHashMap<Cursor> usedCursors;
        @NotNull
        private final ArrayDeque<Pair<EntityId, EntityId>> ids;
        @NotNull
        private final LightOutputStream auxStream;
        @NotNull
        private final int[] auxArray;
        private boolean idsCollected;
        private EntityId srcId;

        public SelectManyDistinctIterator(PersistentStoreTransaction txn) {
            Intrinsics.checkNotNullParameter(SelectManyIterable.this, "this$0");
            Intrinsics.checkNotNullParameter(txn, "txn");
            super(SelectManyIterable.this);
            this.txn = txn;
            this.sourceIt = (EntityIteratorBase)SelectManyIterable.this.source.iterator();
            this.usedCursors = new IntHashMap(6, 2.0f);
            this.ids = new ArrayDeque();
            this.auxStream = new LightOutputStream();
            this.auxArray = new int[8];
        }

        @Override
        protected boolean hasNextImpl() {
            if (!this.idsCollected) {
                this.idsCollected = true;
                this.collectIds();
            }
            return !this.ids.isEmpty();
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                Pair<EntityId, EntityId> pair = this.ids.poll();
                this.srcId = pair.getFirst();
                return pair.getSecond();
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean dispose() {
            this.sourceIt.disposeIfShouldBe();
            if (!super.dispose()) return false;
            Collection collection = this.usedCursors.values();
            Intrinsics.checkNotNullExpressionValue(collection, "usedCursors.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Cursor it = (Cursor)element$iv;
                boolean bl = false;
                it.close();
            }
            Unit it = Unit.INSTANCE;
            return true;
        }

        @Override
        @NotNull
        public EntityId getSourceId() {
            EntityId entityId = this.srcId;
            if (entityId == null) {
                Intrinsics.throwUninitializedPropertyAccessException("srcId");
                entityId = null;
            }
            return entityId;
        }

        private final void collectIds() {
            EntityIteratorBase sourceIt = this.sourceIt;
            int linkId = SelectManyIterable.this.linkId;
            if (linkId >= 0) {
                Object usedIds;
                Object object = usedIds = SelectManyIterable.this.distinct ? EntityIdSetFactory.newSet() : EntityIdSetFactory.newImmutableSet();
                block0: while (sourceIt.hasNext()) {
                    Cursor cursor;
                    Object object2;
                    Object it;
                    EntityId sourceId;
                    if (sourceIt.nextId() == null) continue;
                    int typeId = sourceId.getTypeId();
                    Cursor cursor2 = this.usedCursors.get(typeId);
                    if (cursor2 == null) {
                        Cursor cursor3 = this.getStore().getLinksFirstIndexCursor(this.txn, typeId);
                        it = cursor3;
                        boolean bl = false;
                        object2 = this.usedCursors;
                        Integer n = typeId;
                        object2.put(n, it);
                        Cursor cursor4 = cursor3;
                        Intrinsics.checkNotNullExpressionValue(cursor4, "store.getLinksFirstIndex\u2026sedCursors[typeId] = it }");
                        cursor = cursor4;
                    } else {
                        cursor = cursor2;
                    }
                    Cursor cursor5 = cursor;
                    long sourceLocalId = sourceId.getLocalId();
                    ByteIterable value = cursor5.getSearchKey(PropertyKey.propertyKeyToEntry(this.auxStream, this.auxArray, sourceLocalId, linkId));
                    if (value == null) {
                        if (usedIds.contains(null)) continue;
                        it = usedIds.add(null);
                        Intrinsics.checkNotNullExpressionValue(it, "usedIds.add(null)");
                        usedIds = it;
                        this.ids.add(TuplesKt.to(sourceId, null));
                        continue;
                    }
                    while (true) {
                        PropertyKey key;
                        LinkValue linkValue = LinkValue.entryToLinkValue(KodusKt.getNotNull(value));
                        object2 = linkValue.getEntityId();
                        Intrinsics.checkNotNullExpressionValue(object2, "linkValue.entityId");
                        Object nextId = object2;
                        if (!usedIds.contains((EntityId)nextId)) {
                            object2 = usedIds.add((EntityId)nextId);
                            Intrinsics.checkNotNullExpressionValue(object2, "usedIds.add(nextId)");
                            usedIds = object2;
                            this.ids.add(TuplesKt.to(sourceId, nextId));
                        }
                        if (!cursor5.getNext() || (key = PropertyKey.entryToPropertyKey(cursor5.getKey())).getPropertyId() != linkId || key.getEntityLocalId() != sourceLocalId) continue block0;
                        value = cursor5.getValue();
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/exodus/entitystore/iterate/SelectManyIterable$Companion;", "", "()V", "type", "Ljetbrains/exodus/entitystore/EntityIterableType;", "getType", "()Ljetbrains/exodus/entitystore/EntityIterableType;", "xodus-entity-store"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityIterableType getType() {
            return EntityIterableType.SELECTMANY_DISTINCT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

