/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.io.Closeable;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityLinksIterableBase;
import jetbrains.exodus.entitystore.iterate.SingleKeyCursorCounter;
import jetbrains.exodus.entitystore.iterate.SingleKeyCursorIsEmptyChecker;
import jetbrains.exodus.entitystore.tables.LinkValue;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.env.Cursor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u0001:\u0003\"#$B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001cH\u0016J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntityToLinksIterable;", "Ljetbrains/exodus/entitystore/iterate/EntityLinksIterableBase;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "entityId", "Ljetbrains/exodus/entitystore/EntityId;", "typeId", "", "linkId", "(Ljetbrains/exodus/entitystore/PersistentStoreTransaction;Ljetbrains/exodus/entitystore/EntityId;II)V", "firstKey", "Ljetbrains/exodus/ByteIterable;", "getFirstKey", "()Ljetbrains/exodus/ByteIterable;", "countImpl", "", "getEntityTypeId", "getHandleImpl", "Ljetbrains/exodus/entitystore/EntityIterableHandle;", "getIteratorImpl", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "getKey", "Ljetbrains/exodus/ArrayByteIterable;", "kotlin.jvm.PlatformType", "getLast", "Ljetbrains/exodus/entitystore/Entity;", "getReverseIteratorImpl", "isEmptyImpl", "", "navigateToLast", "cursor", "Ljetbrains/exodus/env/Cursor;", "nonCachedHasFastCountAndIsEmpty", "openCursor", "Companion", "LinksIterator", "LinksReverseIterator", "xodus-entity-store"})
public final class EntityToLinksIterable
extends EntityLinksIterableBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int typeId;
    private final int linkId;

    public EntityToLinksIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityId entityId, int typeId, int linkId) {
        Intrinsics.checkNotNullParameter(txn, "txn");
        Intrinsics.checkNotNullParameter(entityId, "entityId");
        super(txn, entityId);
        this.typeId = typeId;
        this.linkId = linkId;
    }

    @Override
    public int getEntityTypeId() {
        return this.typeId;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter(txn, "txn");
        return new LinksIterator(this.openCursor(txn));
    }

    @Override
    @NotNull
    public EntityIteratorBase getReverseIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter(txn, "txn");
        return new LinksReverseIterator(this.openCursor(txn));
    }

    @Override
    public boolean nonCachedHasFastCountAndIsEmpty() {
        return true;
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        PersistentEntityStoreImpl persistentEntityStoreImpl = this.getStore();
        EntityIterableType entityIterableType = EntityIterableType.ENTITY_TO_LINKS;
        return new ConstantEntityIterableHandle(this, persistentEntityStoreImpl, entityIterableType){
            final /* synthetic */ EntityToLinksIterable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            @NotNull
            public int[] getLinkIds() {
                int[] nArray = new int[]{EntityToLinksIterable.access$getLinkId$p(this.this$0)};
                return nArray;
            }

            public void toString(@NotNull StringBuilder builder) {
                Intrinsics.checkNotNullParameter(builder, "builder");
                super.toString(builder);
                ((PersistentEntityId)this.this$0.entityId).toString(builder);
                builder.append('-');
                builder.append(EntityToLinksIterable.access$getTypeId$p(this.this$0));
                builder.append('-');
                builder.append(EntityToLinksIterable.access$getLinkId$p(this.this$0));
            }

            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                Intrinsics.checkNotNullParameter(hash, "hash");
                ((PersistentEntityId)this.this$0.entityId).toHash(hash);
                hash.applyDelimiter();
                hash.apply(EntityToLinksIterable.access$getTypeId$p(this.this$0));
                hash.applyDelimiter();
                hash.apply(EntityToLinksIterable.access$getLinkId$p(this.this$0));
            }

            public int getEntityTypeId() {
                return EntityToLinksIterable.access$getTypeId$p(this.this$0);
            }

            public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                Intrinsics.checkNotNullParameter(source, "source");
                Intrinsics.checkNotNullParameter(target, "target");
                return EntityToLinksIterable.access$getTypeId$p(this.this$0) == source.getTypeId() && Intrinsics.areEqual(this.this$0.entityId, target);
            }

            public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                Intrinsics.checkNotNullParameter(source, "source");
                Intrinsics.checkNotNullParameter(target, "target");
                return this.isMatchedLinkAdded(source, target, linkId);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Entity getLast() {
        Object object = this.getStore().getAndCheckCurrentTransaction();
        Intrinsics.checkNotNullExpressionValue(object, "store.andCheckCurrentTransaction");
        PersistentStoreTransaction txn = object;
        object = this.openCursor(txn);
        Throwable throwable = null;
        try {
            Cursor cursor = (Cursor)object;
            boolean bl = false;
            if (this.navigateToLast(cursor)) {
                Entity entity = txn.getEntity(new PersistentEntityId(this.typeId, PropertyKey.entryToPropertyKey(cursor.getValue()).getEntityLocalId()));
                return entity;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
        return null;
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter(txn, "txn");
        return new SingleKeyCursorCounter(this.openCursor(txn), this.getFirstKey()).getCount();
    }

    @Override
    public boolean isEmptyImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter(txn, "txn");
        return new SingleKeyCursorIsEmptyChecker(this.openCursor(txn), this.getFirstKey()).isEmpty();
    }

    private final Cursor openCursor(PersistentStoreTransaction txn) {
        Cursor cursor = this.getStore().getLinksSecondIndexCursor(txn, this.typeId);
        Intrinsics.checkNotNullExpressionValue(cursor, "store.getLinksSecondIndexCursor(txn, typeId)");
        return cursor;
    }

    private final ByteIterable getFirstKey() {
        EntityId entityId = this.entityId;
        Intrinsics.checkNotNullExpressionValue(entityId, "entityId");
        ArrayByteIterable arrayByteIterable = this.getKey(entityId);
        Intrinsics.checkNotNullExpressionValue(arrayByteIterable, "getKey(entityId)");
        return arrayByteIterable;
    }

    private final ArrayByteIterable getKey(EntityId entityId) {
        return LinkValue.linkValueToEntry(new LinkValue(entityId, this.linkId));
    }

    private final boolean navigateToLast(Cursor cursor) {
        ArrayByteIterable lastKey = this.getKey(new PersistentEntityId(this.entityId.getTypeId(), this.entityId.getLocalId() + 1L));
        if (cursor.getSearchKeyRange(lastKey) == null ? !cursor.getLast() : !cursor.getPrev()) {
            return false;
        }
        LinkValue key = LinkValue.entryToLinkValue(cursor.getKey());
        return Intrinsics.areEqual(key.getEntityId(), this.entityId) && key.getLinkId() == this.linkId;
    }

    private static final EntityIterableBase _init_$lambda-1(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
        Intrinsics.checkNotNullExpressionValue(txn, "txn");
        Object object = parameters[0];
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        Object object2 = parameters[1];
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        Object object3 = parameters[2];
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        Object object4 = parameters[3];
        if (object4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        return new EntityToLinksIterable(txn, new PersistentEntityId(Integer.parseInt((String)object), Long.parseLong((String)object2)), Integer.parseInt((String)object3), Integer.parseInt((String)object4));
    }

    public static final /* synthetic */ int access$getLinkId$p(EntityToLinksIterable $this) {
        return $this.linkId;
    }

    static {
        EntityLinksIterableBase.registerType(EntityIterableType.ENTITY_TO_LINKS, EntityToLinksIterable::_init_$lambda-1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntityToLinksIterable$LinksIterator;", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "index", "Ljetbrains/exodus/env/Cursor;", "(Ljetbrains/exodus/entitystore/iterate/EntityToLinksIterable;Ljetbrains/exodus/env/Cursor;)V", "hasNext", "", "hasNextImpl", "nextIdImpl", "Ljetbrains/exodus/entitystore/EntityId;", "xodus-entity-store"})
    private final class LinksIterator
    extends EntityIteratorBase {
        private boolean hasNext;

        public LinksIterator(Cursor index2) {
            Intrinsics.checkNotNullParameter(EntityToLinksIterable.this, "this$0");
            Intrinsics.checkNotNullParameter(index2, "index");
            super(EntityToLinksIterable.this);
            this.setCursor(index2);
            this.hasNext = index2.getSearchKey(EntityToLinksIterable.this.getFirstKey()) != null;
        }

        @Override
        public boolean hasNextImpl() {
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                PersistentEntityId persistentEntityId;
                EntityToLinksIterable.this.explain(EntityIterableType.ENTITY_TO_LINKS);
                PersistentEntityId it = persistentEntityId = new PersistentEntityId(EntityToLinksIterable.this.typeId, PropertyKey.entryToPropertyKey(this.getCursor().getValue()).getEntityLocalId());
                boolean bl = false;
                this.hasNext = this.getCursor().getNextDup();
                return persistentEntityId;
            }
            return null;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntityToLinksIterable$LinksReverseIterator;", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "index", "Ljetbrains/exodus/env/Cursor;", "(Ljetbrains/exodus/entitystore/iterate/EntityToLinksIterable;Ljetbrains/exodus/env/Cursor;)V", "hasNext", "", "hasNextImpl", "nextIdImpl", "Ljetbrains/exodus/entitystore/EntityId;", "xodus-entity-store"})
    private final class LinksReverseIterator
    extends EntityIteratorBase {
        private boolean hasNext;

        public LinksReverseIterator(Cursor index2) {
            Intrinsics.checkNotNullParameter(EntityToLinksIterable.this, "this$0");
            Intrinsics.checkNotNullParameter(index2, "index");
            super(EntityToLinksIterable.this);
            this.setCursor(index2);
            this.hasNext = EntityToLinksIterable.this.navigateToLast(index2);
        }

        @Override
        public boolean hasNextImpl() {
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                PersistentEntityId persistentEntityId;
                EntityToLinksIterable.this.explain(EntityIterableType.ENTITY_TO_LINKS);
                PersistentEntityId it = persistentEntityId = new PersistentEntityId(EntityToLinksIterable.this.typeId, PropertyKey.entryToPropertyKey(this.getCursor().getValue()).getEntityLocalId());
                boolean bl = false;
                this.hasNext = this.getCursor().getPrevDup();
                return persistentEntityId;
            }
            return null;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntityToLinksIterable$Companion;", "", "()V", "xodus-entity-store"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

