/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.NoSuchElementException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.QueryCancellingPolicy;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import jetbrains.exodus.env.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityIteratorBase
implements EntityIterator {
    public static final EntityIteratorBase EMPTY = new NonDisposableEntityIterator(EntityIterableBase.EMPTY){

        @Override
        public boolean skip(int number) {
            return false;
        }

        @Override
        protected boolean hasNextImpl() {
            return false;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            return null;
        }
    };
    private static int nextIdCounter = 0;
    @NotNull
    private final EntityIterableBase iterable;
    private boolean finished;
    private boolean disposed;
    private Cursor cursor;
    @Nullable
    private QueryCancellingPolicy queryCancellingPolicy;

    protected EntityIteratorBase(@NotNull EntityIterableBase iterable2) {
        this.iterable = iterable2;
        this.cursor = null;
        this.finished = iterable2 == EntityIterableBase.EMPTY;
        this.disposed = false;
    }

    @NotNull
    public EntityIterableBase getIterable() {
        return this.iterable;
    }

    @Override
    public final boolean hasNext() {
        if (this.finished) {
            return false;
        }
        this.checkDisposed();
        boolean result = this.hasNextImpl();
        if (!result) {
            this.finished = true;
            this.disposeIfShouldBe();
        }
        return result;
    }

    @Override
    @Nullable
    public Entity next() {
        this.throwNoSuchElementExceptionIfNecessary();
        this.checkDisposed();
        EntityId nextEntityId = this.nextId();
        return nextEntityId == null ? null : this.iterable.getEntity(nextEntityId);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("EntityIterator.remove() is not supported.");
    }

    @Override
    public boolean skip(int number) {
        if (this.finished) {
            return false;
        }
        this.checkDisposed();
        while (number-- > 0 && this.hasNextImpl()) {
            this.nextIdImpl();
        }
        return this.hasNextImpl();
    }

    @Override
    @Nullable
    public EntityId nextId() {
        this.throwNoSuchElementExceptionIfNecessary();
        if ((++nextIdCounter & 0x1FF) == 0) {
            QueryCancellingPolicy.cancelIfNecessary(this.getQueryCancellingPolicy());
        }
        return this.nextIdImpl();
    }

    @Nullable
    public EntityId getLast() {
        EntityId result = null;
        while (this.hasNext()) {
            result = this.nextId();
        }
        return result;
    }

    @Override
    public boolean shouldBeDisposed() {
        Cursor cursor = this.cursor;
        return cursor != null && cursor.isMutable();
    }

    @Override
    public boolean dispose() {
        this.queryCancellingPolicy = null;
        if (!this.disposed) {
            this.disposed = true;
            Cursor cursor = this.cursor;
            if (cursor != null) {
                cursor.close();
                this.cursor = null;
            }
            return true;
        }
        return false;
    }

    public void disposeIfShouldBe() {
        if (this.shouldBeDisposed()) {
            this.dispose();
        }
    }

    @NotNull
    protected QueryCancellingPolicy getQueryCancellingPolicy() {
        QueryCancellingPolicy result = this.queryCancellingPolicy;
        if (result == null) {
            result = this.iterable.getTransaction().getQueryCancellingPolicy();
            if (result == null) {
                result = QueryCancellingPolicy.NONE;
            }
            this.queryCancellingPolicy = result;
        }
        return result;
    }

    protected PersistentEntityStoreImpl getStore() {
        return this.iterable.getStore();
    }

    protected Cursor getCursor() {
        return this.cursor;
    }

    protected void setCursor(@NotNull Cursor cursor) {
        if (this.cursor != null) {
            throw new RuntimeException("EntityIterator: Cursor is already set.");
        }
        this.cursor = cursor;
    }

    protected int getIndex() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    protected EntityIdSet toSet() {
        return null;
    }

    private void throwNoSuchElementExceptionIfNecessary() {
        if (this.finished) {
            throw new NoSuchElementException();
        }
    }

    private void checkDisposed() {
        if (this.disposed) {
            throw new EntityStoreException("Can't access disposed EntityIterator.");
        }
    }

    protected abstract boolean hasNextImpl();

    @Nullable
    protected abstract EntityId nextIdImpl();
}

