/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachedInstanceIterable
extends EntityIterableBase {
    @NotNull
    private final EntityIterableHandle sourceHandle;

    protected CachedInstanceIterable(@Nullable PersistentStoreTransaction txn, @NotNull EntityIterableBase source) {
        super(txn);
        this.sourceHandle = source.getHandle();
        this.txnGetter = source.txnGetter;
    }

    @Override
    @NotNull
    public EntityIterator iterator() {
        return this.getIteratorImpl();
    }

    @Override
    public boolean nonCachedHasFastCountAndIsEmpty() {
        return true;
    }

    @Override
    public long size() {
        return this.countImpl(this.getTransaction());
    }

    @Override
    public long count() {
        return this.countImpl(this.getTransaction());
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return this.sourceHandle;
    }

    @Override
    public boolean canBeCached() {
        return false;
    }

    @Override
    public boolean isCachedInstance() {
        return true;
    }

    public boolean isUpdatable() {
        return false;
    }

    @Override
    public boolean isEmptyImpl(@NotNull PersistentStoreTransaction txn) {
        return this.countImpl(txn) == 0L;
    }

    protected abstract CachedInstanceIterable orderById();
}

