/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.Transaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Settings {
    private Settings() {
    }

    @Nullable
    public static String get(@NotNull Store settingsStore, @NotNull String name) {
        return settingsStore.getEnvironment().computeInTransaction(txn -> Settings.get(txn, settingsStore, name));
    }

    @Nullable
    public static String get(@NotNull Transaction txn, @NotNull Store settingsStore, @NotNull String name) {
        try {
            ByteIterable entry = settingsStore.get(txn, StringBinding.stringToEntry(name));
            if (entry != null) {
                return StringBinding.entryToString(entry);
            }
        }
        catch (ExodusException exodusException) {
            // empty catch block
        }
        return null;
    }

    public static void set(@NotNull Store settingsStore, @NotNull String name, @NotNull String setting) {
        settingsStore.getEnvironment().executeInTransaction(txn -> Settings.set(txn, settingsStore, name, setting));
    }

    public static void set(@NotNull Transaction txn, @NotNull Store settingsStore, @NotNull String name, @NotNull String setting) {
        settingsStore.put(txn, StringBinding.stringToEntry(name), StringBinding.stringToEntry(setting));
    }

    public static void delete(@NotNull Store settingsStore, @NotNull String name) {
        settingsStore.getEnvironment().executeInTransaction(txn -> settingsStore.delete(txn, StringBinding.stringToEntry(name)));
    }
}

