/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.management.Statistics;
import jetbrains.exodus.management.StatisticsItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentEntityStoreStatistics
extends Statistics<Type> {
    @NotNull
    private final PersistentEntityStoreImpl store;

    PersistentEntityStoreStatistics(@NotNull PersistentEntityStoreImpl store) {
        super((Enum[])Type.values());
        this.store = store;
        this.createAllStatisticsItems();
    }

    @Override
    protected StatisticsItem createStatisticsItem(@NotNull Type key) {
        if (!this.store.getConfig().getGatherStatistics()) {
            return new StatisticsItem(this);
        }
        return super.createStatisticsItem(key);
    }

    @Override
    @NotNull
    public StatisticsItem getStatisticsItem(@NotNull String statisticsName) {
        if (!this.store.getConfig().getGatherStatistics()) {
            return new StatisticsItem(this);
        }
        return super.getStatisticsItem(statisticsName);
    }

    @Override
    @NotNull
    protected StatisticsItem createNewBuiltInItem(@NotNull Type key) {
        switch (key) {
            case BLOBS_DISK_USAGE: {
                return new BlobsDiskUsageStatisticsItem(this);
            }
            case CACHING_JOBS: {
                return new CachingJobsStatisticsItem(this);
            }
        }
        return super.createNewBuiltInItem(key);
    }

    private static class CachingJobsStatisticsItem
    extends StatisticsItem {
        public CachingJobsStatisticsItem(@NotNull PersistentEntityStoreStatistics statistics) {
            super(statistics);
        }

        @Override
        @Nullable
        protected Long getAutoUpdatedTotal() {
            PersistentEntityStoreStatistics statistics = (PersistentEntityStoreStatistics)this.getStatistics();
            return statistics == null ? null : Long.valueOf(statistics.store.getAsyncProcessor().pendingJobs());
        }
    }

    private static class BlobsDiskUsageStatisticsItem
    extends StatisticsItem {
        public BlobsDiskUsageStatisticsItem(@NotNull PersistentEntityStoreStatistics statistics) {
            super(statistics);
        }

        @Override
        @Nullable
        protected Long getAutoUpdatedTotal() {
            PersistentEntityStoreStatistics statistics = (PersistentEntityStoreStatistics)this.getStatistics();
            return statistics == null ? null : Long.valueOf(statistics.store.getBlobVault().size());
        }
    }

    public static enum Type {
        BLOBS_DISK_USAGE("Blobs disk usage"),
        CACHING_JOBS("Caching jobs");

        public final String id;

        private Type(String id) {
            this.id = id;
        }
    }
}

