/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import jetbrains.exodus.ExodusException;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIdCache;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import org.jetbrains.annotations.NotNull;

public class PersistentEntityId
implements EntityId {
    @NotNull
    public static final PersistentEntityId EMPTY_ID = new PersistentEntityId(0, 0L);
    private static final long serialVersionUID = -3875948066835180514L;
    private final int entityTypeId;
    private final long entityLocalId;

    public PersistentEntityId(int entityTypeId, long entityLocalId, int version) {
        this.entityTypeId = entityTypeId;
        this.entityLocalId = entityLocalId;
    }

    public PersistentEntityId(int entityTypeId, long entityLocalId) {
        if (entityLocalId < 0L) {
            throw new ExodusException("LocalId can't be negative");
        }
        this.entityTypeId = entityTypeId;
        this.entityLocalId = entityLocalId;
    }

    public PersistentEntityId(@NotNull EntityId id) {
        this(id.getTypeId(), id.getLocalId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PersistentEntityId)) {
            return false;
        }
        PersistentEntityId that = (PersistentEntityId)obj;
        return this.entityLocalId == that.entityLocalId && this.entityTypeId == that.entityTypeId;
    }

    public int hashCode() {
        return (int)((long)(this.entityTypeId << 20) ^ this.entityLocalId);
    }

    @Override
    public int getTypeId() {
        return this.entityTypeId;
    }

    @Override
    public long getLocalId() {
        return this.entityLocalId;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder builder = new StringBuilder(10);
        this.toString(builder);
        return builder.toString();
    }

    public void toString(@NotNull StringBuilder builder) {
        builder.append(this.entityTypeId);
        builder.append('-');
        builder.append(this.entityLocalId);
    }

    public void toHash(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
        hash.apply(this.entityTypeId);
        hash.applyDelimiter();
        hash.apply(this.entityLocalId);
    }

    public static EntityId toEntityId(@NotNull CharSequence representation) {
        return EntityIdCache.getEntityId(representation);
    }

    @Override
    public int compareTo(@NotNull EntityId o) {
        long rightLocalId = o.getLocalId();
        int rightType = o.getTypeId();
        if (this.entityTypeId < rightType) {
            return -2;
        }
        if (this.entityTypeId > rightType) {
            return 2;
        }
        return Long.compare(this.entityLocalId, rightLocalId);
    }
}

