/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.tables.Table;
import org.jetbrains.annotations.NotNull;

class OpenTablesCache {
    private final TableCreator creator;
    private final Object lock;
    private IntHashMap<Table> cache;

    OpenTablesCache(@NotNull TableCreator creator) {
        this.creator = creator;
        this.lock = new Object();
        this.cache = new IntHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Table get(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        Table result = this.cache.get(entityTypeId);
        if (result != null) {
            return result;
        }
        Object object = this.lock;
        synchronized (object) {
            result = this.cache.get(entityTypeId);
            if (result == null && (result = this.creator.createTable(txn, entityTypeId)).canBeCached()) {
                IntHashMap<Table> newCache = this.cloneCache();
                newCache.put(entityTypeId, result);
                this.cache = newCache;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(int entityTypeId) {
        Object object = this.lock;
        synchronized (object) {
            if (this.cache.containsKey(entityTypeId)) {
                IntHashMap<Table> newCache = this.cloneCache();
                newCache.remove(entityTypeId);
                this.cache = newCache;
            }
        }
    }

    private IntHashMap<Table> cloneCache() {
        IntHashMap<Table> currentCache = this.cache;
        IntHashMap<Table> result = new IntHashMap<Table>(currentCache.size());
        currentCache.forEachEntry(entry -> {
            result.put((Integer)entry.getKey(), (Table)entry.getValue());
            return true;
        });
        return result;
    }

    static interface TableCreator {
        @NotNull
        public Table createTable(@NotNull PersistentStoreTransaction var1, int var2);
    }
}

