/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.io.File;
import java.io.IOException;
import jetbrains.exodus.entitystore.BlobHandleGenerator;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.FileSystemBlobVaultOld;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import org.jetbrains.annotations.NotNull;

public class FileSystemBlobVault
extends FileSystemBlobVaultOld {
    private static final int EXPECTED_VERSION = 1;

    public FileSystemBlobVault(@NotNull PersistentEntityStoreConfig config, @NotNull String parentDirectory, @NotNull String blobsDirectory, @NotNull String blobExtension, @NotNull BlobHandleGenerator blobHandleGenerator) throws IOException {
        super(config, parentDirectory, blobsDirectory, blobExtension, blobHandleGenerator, 1);
    }

    @Override
    @NotNull
    public File getBlobLocation(long blobHandle, boolean readonly) {
        String file;
        if (blobHandle < 256L) {
            return super.getBlobLocation(blobHandle, readonly);
        }
        byte[] bytes = new byte[8];
        int handleLen = 0;
        do {
            bytes[handleLen++] = (byte)(blobHandle & 0xFFL);
        } while ((blobHandle >>= 8) > 0L);
        File dir = this.getVaultLocation();
        while (true) {
            file = Integer.toHexString(bytes[--handleLen] & 0xFF);
            if (handleLen == 0) break;
            dir = new File(dir, file);
        }
        if (!readonly) {
            dir.mkdirs();
        }
        File result = new File(dir, file + this.getBlobExtension());
        if (!readonly && result.exists()) {
            throw new EntityStoreException("Can't update existing blob file: " + result);
        }
        return result;
    }

    protected long getBlobHandleByFile(@NotNull File file) {
        String name = file.getName();
        String blobExtension = this.getBlobExtension();
        int blobExtensionStart = name.indexOf(blobExtension);
        if (name.endsWith(blobExtension) && (blobExtensionStart == 2 || blobExtensionStart == 1)) {
            try {
                long result = Integer.parseInt(name.substring(0, blobExtensionStart), 16);
                File f = file;
                int shift = 0;
                while ((f = f.getParentFile()) != null) {
                    if (f.equals(this.getVaultLocation())) {
                        return result;
                    }
                    result += (long)Integer.parseInt(f.getName(), 16) << (shift += 8);
                }
            }
            catch (NumberFormatException nfe) {
                throw new EntityStoreException("Not a file of filesystem blob vault: " + file, nfe);
            }
        }
        throw new EntityStoreException("Not a file of filesystem blob vault: " + file);
    }
}

