/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent;

import jetbrains.exodus.core.dataStructures.persistent.AbstractPersistentHashSet;
import jetbrains.exodus.core.dataStructures.persistent.PersistentHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentHashMap<K, V> {
    private final PersistentHashSet<Entry<K, V>> set;

    public PersistentHashMap() {
        this.set = new PersistentHashSet();
    }

    private PersistentHashMap(@NotNull AbstractPersistentHashSet.RootTableNode<Entry<K, V>> root) {
        this.set = new PersistentHashSet<Entry<Entry<K, V>, V>>(root);
    }

    public ImmutablePersistentHashMap getCurrent() {
        return new ImmutablePersistentHashMap();
    }

    public PersistentHashMap<K, V> getClone() {
        return new PersistentHashMap<K, V>(this.set.getRoot());
    }

    public MutablePersistentHashMap beginWrite() {
        return new MutablePersistentHashMap();
    }

    public boolean endWrite(@NotNull MutablePersistentHashMap tree) {
        return this.set.endWrite(tree);
    }

    public static class Entry<K, V> {
        @NotNull
        private final K key;
        private final V value;

        private Entry(@NotNull K key) {
            this(key, null);
        }

        private Entry(@NotNull K key, @Nullable V value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object obj) {
            return this.key.equals(((Entry)obj).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        @NotNull
        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }

    public class MutablePersistentHashMap
    extends PersistentHashSet.MutablePersistentHashSet<Entry<K, V>> {
        MutablePersistentHashMap() {
            super(PersistentHashMap.this.set);
        }

        public V get(@NotNull K key) {
            Entry entry = this.getRoot().getKey(new Entry(key), key.hashCode(), 0);
            return entry == null ? null : (Object)entry.getValue();
        }

        public boolean containsKey(@NotNull K key) {
            return this.getRoot().getKey(new Entry(key), key.hashCode(), 0) != null;
        }

        public void put(@NotNull K key, @NotNull V value) {
            this.add(new Entry(key, value));
        }

        public V removeKey(@NotNull K key) {
            Object result;
            Entry entry = this.getRoot().getKey(new Entry(key), key.hashCode(), 0);
            Object v = result = entry == null ? null : (Object)entry.getValue();
            if (entry != null) {
                this.remove(entry);
            }
            return result;
        }
    }

    public class ImmutablePersistentHashMap
    extends PersistentHashSet.ImmutablePersistentHashSet<Entry<K, V>> {
        ImmutablePersistentHashMap() {
            super(PersistentHashMap.this.set.getRoot());
        }

        public V get(@NotNull K key) {
            Entry entry = this.getRoot().getKey(new Entry(key), key.hashCode(), 0);
            return entry == null ? null : (Object)entry.getValue();
        }

        public boolean containsKey(@NotNull K key) {
            return this.getRoot().getKey(new Entry(key), key.hashCode(), 0) != null;
        }
    }
}

