/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.hash;

import java.util.AbstractSet;
import java.util.Iterator;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import jetbrains.exodus.util.MathUtil;
import org.jetbrains.annotations.NotNull;

public class IntHashSet
extends AbstractSet<Integer> {
    private Entry[] table;
    private int capacity;
    private int size;
    private final float loadFactor;
    private int mask;

    public IntHashSet() {
        this(0);
    }

    public IntHashSet(int capacity) {
        this(capacity, 1.0f);
    }

    public IntHashSet(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.init(capacity);
    }

    public boolean contains(int key) {
        Entry[] table = this.table;
        int index2 = HashUtil.indexFor(key, table.length, this.mask);
        Entry e = table[index2];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.hashNext;
        }
        return false;
    }

    @Override
    public boolean contains(Object key) {
        return this.contains((Integer)key);
    }

    @Override
    public boolean add(int key) {
        Entry[] table = this.table;
        int index2 = HashUtil.indexFor(key, table.length, this.mask);
        Entry e = table[index2];
        while (e != null) {
            if (e.key == key) {
                return false;
            }
            e = e.hashNext;
        }
        e = new Entry(key);
        e.hashNext = table[index2];
        table[index2] = e;
        ++this.size;
        if (this.size > this.capacity) {
            this.rehash(HashUtil.nextCapacity(this.capacity));
        }
        return true;
    }

    @Override
    public boolean add(Integer key) {
        return this.add((int)key);
    }

    public boolean remove(int key) {
        Entry[] table = this.table;
        int index2 = HashUtil.indexFor(key, table.length, this.mask);
        Entry e = table[index2];
        if (e == null) {
            return false;
        }
        if (e.key == key) {
            table[index2] = e.hashNext;
        } else {
            Entry last;
            do {
                last = e;
                if ((e = e.hashNext) != null) continue;
                return false;
            } while (e.key != key);
            last.hashNext = e.hashNext;
        }
        --this.size;
        return true;
    }

    @Override
    public boolean remove(Object key) {
        return this.remove((Integer)key);
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        return new HashSetIterator<Integer>(){

            @Override
            public Integer next() {
                return this.nextEntry().key;
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    private void allocateTable(int length) {
        this.table = new Entry[length];
        this.mask = (1 << MathUtil.integerLogarithm(this.table.length)) - 1;
    }

    private void init(int capacity) {
        if (capacity < 4) {
            capacity = 4;
        }
        this.allocateTable(HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor)));
        this.capacity = capacity;
        this.size = 0;
    }

    private void rehash(int capacity) {
        int length = HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor));
        this.capacity = capacity;
        if (length != this.table.length) {
            RehashIterator entries = new RehashIterator();
            this.allocateTable(length);
            Entry[] table = this.table;
            int mask = this.mask;
            while (entries.hasNext()) {
                Entry e = (Entry)entries.next();
                int index2 = HashUtil.indexFor(e.key, length, mask);
                e.hashNext = table[index2];
                table[index2] = e;
            }
        }
    }

    private abstract class HashSetIterator<T>
    implements Iterator<T> {
        private final Entry[] table;
        private int index;
        private Entry e;
        private Entry last;

        HashSetIterator() {
            this.table = IntHashSet.this.table;
            this.index = 0;
            this.e = null;
            this.initNextEntry();
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            IntHashSet.this.remove(this.last.key);
            this.last = null;
        }

        protected Entry nextEntry() {
            Entry result = this.last = this.e;
            this.initNextEntry();
            return result;
        }

        private void initNextEntry() {
            Entry result = this.e;
            if (result != null) {
                result = result.hashNext;
            }
            Entry[] table = this.table;
            while (result == null && this.index < table.length) {
                result = table[this.index++];
            }
            this.e = result;
        }
    }

    private static class Entry {
        private final int key;
        private Entry hashNext;

        private Entry(int key) {
            this.key = key;
        }
    }

    private final class RehashIterator
    extends HashSetIterator<Entry> {
        private RehashIterator() {
        }

        @Override
        public Entry next() {
            return this.nextEntry();
        }
    }
}

